#pragma once

//! @file Utility/UI/ComboBox.h
//! @brief R{{bNXNXCN[ht@C

#include <vector>
#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

	//! @class ComboBox
	//! @brief R{{bNXNX
	class ComboBox : public UI::Control
	{
	private:
		struct ITEM
		{
			Int32 index;
			Int32 id;
			Mix::StringW text;

			Mix::Vector2 pos;
			Mix::RectangleF rect;

			ITEM( Int32 _index, Int32 _id, const wchar_t* _pText )
			{
				index = _index;
				id = _id;
				text = _pText;
			}
		};

		typedef std::vector<ComboBox::ITEM> ItemList;

	private:
		Mix::RectangleF m_Rect;

		Mix::RectangleF m_SelectedFrameRect;
		Mix::RectangleF m_SelectedRect;

		Mix::Vector2 m_SelectedItemPos;
		Mix::RectangleF m_SelectedItemRect;

		Mix::RectangleF m_DropButtonRect;
		Mix::Vector2 m_DropAllowPoints[3];

		Mix::RectangleF m_DropDownFrameRect;
		Mix::RectangleF m_DropDownRect;

		Mix::RectangleF m_HoverItemRect;
		Int32 m_HoverItemIndex;

		ComboBox::ItemList m_ItemList;
		Int32 m_SelectedItemIndex;

		Boolean m_bDrop;

	public:
		//! @brief RXgN^
		ComboBox( void );
		//! @brief fXgN^
		virtual ~ComboBox( void );

		//! @brief ACeǉ܂
		//! @param[in] id ǉACeID
		//! @param[in] pText ACẽeLXg
		void AddItem( Int32 id, const wchar_t* pText );
		//! @brief ACe폜܂
		//! @param[in] id 폜ACeID
		void RemoveItem( Int32 id );
		//! @brief SẴACe폜܂
		void ClearItems( void );

		//! @brief ACeI܂
		//! @param[in] id IbNotifyACeID
		//! @param[in] bNotify IύXꂽƂʒmꍇ True
		void SetSelectedItem( Int32 id, Boolean bNotify = True );
		//! @brief IĂACeID擾܂
		//! @return ACeIDԂ܂
		Int32 GetSelectedItem( void ) const;

	protected:
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args );
		virtual const Mix::RectangleF& GetRectangle( void ) const;

		virtual void OnMouseMove( Mix::HID::IMouse* pMouse );
		virtual void OnMouseLeave( Mix::HID::IMouse* pMouse );
		virtual void OnMouseDown( Mix::HID::IMouse* pMouse );

		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args );

	private:
		ComboBox::ItemList::const_iterator FindItem( Int32 id ) const;

	private:
		static const Float32 ITEM_MARGIN;
	};
}}
