#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

Control::Control( void ) :
m_pParent( NULL ),
m_ID( 0 ),
m_bEnabled( True ),
m_bFocus( False ),
m_bDispose( False )
{
}

Control::~Control( void )
{
}

void Control::Initialize( UI::Dialog* pParent, UInt32 id )
{
	if( m_pParent != pParent )
	{
		if( m_pParent != NULL )
		{
			m_pParent->RemoveControl( this );
		}

		if( pParent != NULL )
		{
			pParent->AddControl( this );
		}

		m_pParent = pParent;
	}

	m_ID = id;

	if( m_pParent != NULL )
	{
		OnInitialize();
	}
}

UI::Dialog* Control::GetParent( void ) const
{
	return m_pParent;
}

UInt32 Control::GetID( void ) const
{
	return m_ID;
}

void Control::SetPosition( const Mix::Vector2& pos )
{
	m_Pos = pos;
}

const Mix::Vector2& Control::GetPosition( void ) const
{
	return m_Pos;
}

void Control::SetSize( const Mix::Vector2& size )
{
	m_Size = Mix::Vector2::Max( Mix::Vector2::Zero(), size );
}

const Mix::Vector2& Control::GetSize( void ) const
{
	return m_Size;
}

void Control::SetEanbled( Boolean state )
{
	m_bEnabled = state;
}

Boolean Control::GetEnabled( void ) const
{
	return m_bEnabled;
}

Boolean Control::IsDispose( void ) const
{
	return m_bDispose;
}

Boolean Control::IsFocus( void ) const
{
	return m_bFocus;
}

void Control::SetFocus( Boolean state )
{
	m_bFocus = state;
}

void Control::Dispose( void )
{
	if( m_bDispose == False )
	{
		OnDispose();
		m_bDispose = True;
	}
}

}}
