#pragma once

//! @file Utility/UI/Control.h
//! @brief Rg[NXCN[ht@C

#include "Mix/HID/IMouse.h"
#include "Mix/Graphics/Utility/ICanvasRenderer.h"

#include "Utility/UI/Dialog.h"

namespace Utility{ namespace UI {

	//! @class Control
	//! @brief Rg[NX
	class Control
	{
	protected:
		//! @struct UPDATE_EVENT_ARGS
		//! @brief XVCxgp[^\
		struct UPDATE_EVENT_ARGS
		{
			Mix::Vector2 offset;					//!< `W̃ItZbg
			Mix::HID::IMouse* pMouse;				//!< }EX
			Mix::Graphics::Utility::IFont* pFont;	//!< tHg
		};

		//! @struct DRAW_EVENT_ARGS
		//! @brief `Cxgp[^\
		struct DRAW_EVENT_ARGS
		{
			Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer;	//!< LoX

			Mix::Vector4 borderColor;					//!< {[_[J[
			Mix::Vector4 backgroundColor;				//!< obNOEhJ[P
			Mix::Vector4 darkBackgroundColor;			//!< obNOEhJ[Q
			Mix::Vector4 darkDarkBackgroundColor;		//!< obNOEhJ[R
			Mix::Vector4 textColor;						//!< eLXgJ[

			Mix::Vector4 selectedBackgroundColor;		//!< ĨobNOEhJ[
			Mix::Vector4 selectedTextColor;				//!< ĨeLXgJ[
		};

	private:
		UI::Dialog* m_pParent;

		UInt32 m_ID;

		Mix::Vector2 m_Pos;
		Mix::Vector2 m_Size;

		Boolean m_bEnabled;
		Boolean m_bFocus;
		Boolean m_bDispose;

	public:
		//! @brief RXgN^
		Control( void );
		//! @brief fXgN^
		virtual ~Control( void );

		//! @brief ܂
		//! @param[in] pParent eɂȂ_CAÕ|C^
		//! @param[in] id gID
		void Initialize( UI::Dialog* pParent, UInt32 id );

		//! @brief ẽ_CAÕ|C^擾܂
		//! @return ẽ_CAÕ|C^Ԃ܂
		UI::Dialog* GetParent( void ) const;
		//! @brief gID擾܂
		//! @return gIDԂ܂
		UInt32 GetID( void ) const;

		//! @brief ʒuݒ肵܂
		//! @param[in] pos ʒu
		void SetPosition( const Mix::Vector2& pos );
		//! @brief ʒu擾܂
		//! @return ʒuԂ܂
		const Mix::Vector2& GetPosition( void ) const;

		//! @brief TCYݒ肵܂
		//! @param[in] size TCY
		void SetSize( const Mix::Vector2& size );
		//! @brief TCY擾܂
		//! @return TCYԂ܂
		const Mix::Vector2& GetSize( void ) const;

		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		void SetEanbled( Boolean state );
		//! @brief Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		Boolean GetEnabled( void ) const;

		//! @brief tH[JXĂ邩ǂ擾܂
		//! @return tH[JXĂꍇ True Ԃ܂
		Boolean IsFocus( void ) const;
		//! @brief jĂ邩ǂ擾܂
		//! @return jĂꍇ True Ԃ܂
		Boolean IsDispose( void ) const;

	protected:
		//! @brief Rg[XV܂
		//! @param[in] args XVp[^
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args ) = 0;

		//! @brief Rg[̋`擾܂
		//! @return Rg[̋`Ԃ܂
		virtual const Mix::RectangleF& GetRectangle( void ) const = 0;

		//! @brief ۂɌĂяo܂
		virtual void OnInitialize( void ) {}
		//! @brief jۂɌĂяo܂
		virtual void OnDispose( void ) {}

		//! @brief }EXJ[\ړۂɌĂяo܂
		//! @param[in] pMosue }EX
		virtual void OnMouseMove( Mix::HID::IMouse* pMouse ) {}
		//! @brief }EXJ[\Rg[ɓۂɌĂяo܂
		//! @param[in] pMosue }EX
		virtual void OnMouseEnter( Mix::HID::IMouse* pMouse ) {}
		//! @brief }EXJ[\Rg[OɏoۂɌĂяo܂
		//! @param[in] pMosue }EX
		virtual void OnMouseLeave( Mix::HID::IMouse* pMouse ) {}
		//! @brief }EX{^ꂽۂɌĂяo܂
		//! @param[in] pMosue }EX
		virtual void OnMouseDown( Mix::HID::IMouse* pMouse ) {}
		//! @brief }EX{^ꂽۂɌĂяo܂
		//! @param[in] pMosue }EX
		virtual void OnMouseUp( Mix::HID::IMouse* pMouse ) {}

		//! @brief Rg[`悷ۂɌĂяo܂
		//! @param[in] args Rg[̕`p[^
		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args ) {}

	private:
		void SetFocus( Boolean state );
		void Dispose( void );

		friend class Dialog;
	};
}}
