#pragma once

//! @file Utility/UI/Dialog.h
//! @brief _CAONXCN[ht@C

#include <set>
#include <list>

namespace Utility{ namespace UI {

	class Manager;
	class Control;
	class Button;
	class CheckBox;
	class SliderI;
	class SliderF;
	class ComboBox;
	class Color;

	//! @class Dialog
	//! @brief _CAONX
	class Dialog
	{
	private:
		struct UPDATE_EVENT_ARGS
		{
			Mix::HID::IMouse* pMouse;
			Mix::Graphics::Utility::IFont* pFont;
		};

		struct DRAW_EVENT_ARGS
		{
			Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer;

			Mix::Vector4 borderColor;
			Mix::Vector4 backgroundColor;
			Mix::Vector4 textColor;

			Mix::Vector4 selectedBackgroundColor;
			Mix::Vector4 selectedTextColor;

			Mix::Vector4 dlgCaptionBackgroundColor;
			Mix::Vector4 dlgCaptionTextColor;

			Mix::Vector4 ctrlBackgroundColor;
			Mix::Vector4 ctrlDarkBackgroundColor;
			Mix::Vector4 ctrlDarkDarkBackgroundColor;
		};

		enum STATE_TYPE
		{
			STATE_IDLE		= 0,
			STATE_MOVE		= 1,
			STATE_REQ_CLOSE	= 2,
		};

		enum HIT_FLAG
		{
			HIT_CAPTION		= 0x00000001,
			HIT_CLOSEBUTTON	= 0x00000002,
			HIT_CLIENT		= 0x00000004,
			HIT_CONTROL		= 0x00000008,
		};

		typedef std::set<UI::Control*> ControlMap;
		typedef std::list<UI::Control*> ControlList;

		static Float32 MARGIN;

	private:
		UI::Manager* m_pManager;
		Dialog::ControlMap m_ControlMap;
		Dialog::ControlList m_ControlUpdateList;
		Dialog::ControlList m_ControlDrawList;

		Mix::StringW m_Caption;
		Mix::Vector2 m_Pos;
		Mix::Vector2 m_Size;

		Mix::RectangleF m_Rect;

		Mix::RectangleF m_CaptionRect;
		Mix::RectangleF m_CaptionTextRect;
		Mix::Vector2 m_CaptionPos;

		Boolean m_bHUDEnabled;

		Boolean m_bCloseButtonDown;
		Boolean m_bCloseButtonEnabled;
		Mix::RectangleF m_CloseButtonFrameRect;
		Mix::RectangleF m_CloseButtonRect;
		Mix::Vector2 m_CloseButtonLines[4];

		Mix::RectangleF m_BackgroundRect;

		Mix::Vector2 m_ClientPos;
		Mix::RectangleF m_ClientRect;

		UI::Control* m_pHoverControl;
		UI::Control* m_pFocusControl;

		Dialog::STATE_TYPE m_State;

		Boolean m_bClose;
		Boolean m_bActive;
		Boolean m_bDispose;

	public:
		//! @brief RXgN^
		Dialog( void );
		//! @brief fXgN^
		virtual ~Dialog( void );

	public:
		//! @brief _CAOJ܂
		//! @param[in] pManager }l[W
		void Open( UI::Manager* pManager );

		//! @brief _CAO܂
		void Close( void );
		//! @brief _CAOĂ邩ǂ擾܂
		//! @return _CAOĂꍇ True Ԃ܂
		Boolean IsClose( void ) const;

		//! @brief }l[W̃|C^擾܂
		//! @return }l[W̃|C^Ԃ܂
		UI::Manager* GetManager( void ) const;

		//! @brief LvVݒ肵܂
		//! @param[in] pCaption LvV
		void SetCaption( const wchar_t* pCaption );
		//! @brief LvV擾܂
		//! @return LvVԂ܂
		const wchar_t* GetCaption( void ) const;

		//! @brief ʒuݒ肵܂
		//! @param[in] pos ʒu
		void SetPosition( const Mix::Vector2& pos );
		//! @brief ʒu擾܂
		//! @return ʒuԂ܂
		const Mix::Vector2& GetPosition( void ) const;

		//! @brief TCYݒ肵܂
		//! @param[in] size TCY
		void SetSize( const Mix::Vector2& size );
		//! @brief TCY擾܂
		//! @return TCYԂ܂
		const Mix::Vector2& GetSize( void ) const;

		//! @brief HUDLɂ邩ǂݒ肵܂
		//! @param[in] HUDLɂꍇ True
		//! @note ̐ݒLɂꍇARg[݂̂̂\悤ɂȂ܂
		void SetHUDEnabled( Boolean state );
		//! @brief HUDLǂ擾܂
		//! @return HUDLȏꍇ True Ԃ܂
		Boolean GetHUDEnabled( void ) const;

		//! @brief N[Y{^Lɂ邩ǂݒ肵܂
		//! @param[in] state N[Y{^Lɂꍇ Ture
		void SetCloseButtonEnabled( Boolean state );
		//! @brief N[Y{^Lǂ擾܂
		//! @return N[Y{^Lȏꍇ True Ԃ܂
		Boolean GetCloseButtonEnabled( void ) const;

		//! @brief _CAOĂ邩ǂ擾܂
		//! @return Ăꍇ True Ԃ܂
		Boolean IsActive( void ) const;

		//! @brief _CAOj܂
		void Dispose( void );
		//! @brief _CAOjĂ邩ǂ擾܂
		//! @return jĂꍇ True Ԃ܂
		Boolean IsDispose( void ) const;

	protected:
		//! @brief _CAOJꂽۂɌĂяo܂
		virtual void OnOpen( void ) {}
		//! @brief _CAOꂽۂɌĂяo܂
		virtual void OnClose( void ) {}
		//! @brief _CAOjꂽۂɌĂяo܂
		virtual void OnDispose( void ) {}
		//! @brief {^NbNꂽۂɌĂяo܂
		//! @param[in] pButton NbNꂽ{^̃|C^
		virtual void OnButton_Click( Utility::UI::Button* pButton ) {}
		//! @brief `FbN{bNXNbNꂽۂɌĂяo܂
		//! @param[in] pCheckBox NbNꂽ`FbN{bNX̃|C^
		virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox ) {}
		//! @brief XC_[̒lύXꂽꍇɌĂяo܂
		//! @param[in] pSlider lύXꂽXC_[̃|C^
		virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider ) {}
		//! @brief XC_[̒lύXꂽꍇɌĂяo܂
		//! @param[in] pSlider lύXꂽXC_[̃|C^
		virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider ) {}
		//! @brief R{{bNX̃ACȇIύXꂽۂɌĂяo܂
		//! @param[in] pComboBox ACȇIύXꂽR{{bNX̃|C^
		virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox ) {}
		//! @brief J[̒l̑IύXꂽۂɌĂяo܂
		//! @param[in] pColor J[̒l̑IύXꂽJ[̃|C^
		virtual void OnColor_ValueChanged( Utility::UI::Color* pColor ) {}

	private:
		void Update( const Utility::UI::Dialog::UPDATE_EVENT_ARGS& args );
		void SetActive( Boolean state, Mix::HID::IMouse* pMouse );
		void AddControl( Utility::UI::Control* pControl );
		void RemoveControl( Utility::UI::Control* pControl );

		Boolean Contains( const Mix::Vector2& pos ) const;

		const Mix::RectangleF& GetRectangle( void ) const;

		void MouseMove( Mix::HID::IMouse* pMouse );
		void MouseDown( Mix::HID::IMouse* pMouse );
		void MouseUp( Mix::HID::IMouse* pMouse );
		void Draw( const Utility::UI::Dialog::DRAW_EVENT_ARGS& args );

	private:
		UInt32 HitTest( const Mix::Vector2& pos ) const;
		UI::Control* FindControl( const Mix::Vector2& pos ) const;

		friend class Manager;
		friend class Control;
		friend class Button;
		friend class CheckBox;
		friend class SliderI;
		friend class SliderF;
		friend class ComboBox;
		friend class Color;
	};
}}
