#include "Utility/UI/Label.h"
#include "Mix/Graphics.h"

namespace Utility{ namespace UI {

Label::Label( void ) :
m_bBorderEnabled( False )
{
}

Label::~Label( void )
{
}

void Label::SetText( const wchar_t* pText )
{
	m_Text = pText;
}

const wchar_t* Label::GetText( void ) const
{
	return m_Text.GetConstPtr();
}

void Label::SetBorderEnabled( Boolean state )
{
	m_bBorderEnabled = state;
}

Boolean Label::GetBorderEnabled( void ) const
{
	return m_bBorderEnabled;
}

void Label::Update( const Control::UPDATE_EVENT_ARGS& args )
{
	const Mix::Vector2& pos = GetPosition();
	const Mix::Vector2& size = GetSize();

	m_Rect.x = args.offset.x + pos.x;
	m_Rect.y = args.offset.y + pos.y;
	m_Rect.width = size.x;
	m_Rect.height = size.y;

	m_BackgroundRect.x = m_Rect.x + 1.0f;
	m_BackgroundRect.y = m_Rect.y + 1.0f;
	m_BackgroundRect.width = m_Rect.width - 2.0f;
	m_BackgroundRect.height = m_Rect.height - 2.0f;

	if( m_Text.GetNum() > 0 )
	{
		Mix::Vector2 textSize = Mix::Graphics::Utility::MeasureString( args.pFont, m_Text.GetConstPtr() );

		m_TextRect.x = m_BackgroundRect.x + 2.0f;
		m_TextRect.y = m_BackgroundRect.y + 2.0f;
		m_TextRect.width = m_BackgroundRect.width - 4.0f;
		m_TextRect.height = m_BackgroundRect.height - 4.0f;

		m_TextPos.x = m_TextRect.x;
		m_TextPos.y = ( m_TextRect.height >= textSize.y )? ( m_TextRect.y + ( m_TextRect.height - textSize.y ) * 0.5f ) : m_TextRect.y;
	}
	else
	{
		m_TextPos = Mix::Vector2( 0.0f, 0.0f );
		m_TextRect = Mix::RectangleF( 0.0f, 0.0f, 0.0f, 0.0f );
	}
}

const Mix::RectangleF& Label::GetRectangle( void ) const
{
	return m_Rect;
}

void Label::OnDraw( const Control::DRAW_EVENT_ARGS& args )
{
	if( m_bBorderEnabled == True )
	{
		args.pCanvasRenderer->SetColor( args.borderColor );
		args.pCanvasRenderer->AddRectangle( m_Rect );
	}

	if( m_Text.GetNum() > 0 )
	{
		args.pCanvasRenderer->SetClip( m_TextRect );
		args.pCanvasRenderer->SetColor( args.textColor );
		args.pCanvasRenderer->AddString( m_TextPos, m_Text.GetConstPtr() );
	}
}

}}
