#pragma once

//! @file Utility/UI/Label.h
//! @brief xNXCN[ht@C

#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

	//! @class Label
	//! @brief xNX
	class Label : public UI::Control
	{
	private:
		Mix::RectangleF m_Rect;
		Mix::RectangleF m_BackgroundRect;

		Mix::StringW m_Text;
		Mix::Vector2 m_TextPos;
		Mix::RectangleF m_TextRect;

		Boolean m_bBorderEnabled;

	public:
		//! @brief RXgN^
		Label( void );
		//! @brief fXgN^
		virtual ~Label( void );

		//! @brief eLXgݒ肵܂
		//! @param[in] pText eLXg
		void SetText( const wchar_t* pText );
		//! @brief eLXg擾܂
		//! @return eLXgԂ܂
		const wchar_t* GetText( void ) const;

		//! @brief {[_[\邩ǂݒ肵܂
		//! @param[in] state {[_[\ꍇ True
		void SetBorderEnabled( Boolean state );
		//! @brief {[_[\Ă邩ǂ擾܂
		//! @return {[_[\Ăꍇ True Ԃ܂
		Boolean GetBorderEnabled( void ) const;

	protected:
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args );
		virtual const Mix::RectangleF& GetRectangle( void ) const;

		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args );
	};
}}
