#pragma once

//! @file Utility/UI/Manager.h
//! @brief }l[WNXCN[ht@C

#include <set>
#include <list>

namespace Utility{ namespace UI {

	class Dialog;

	//! @class Manager
	//! @brief }l[WNX
	class Manager
	{
	public:
		//! @enum COLOR_TYPE
		//! @brief J[^Cv񋓒萔
		enum COLOR_TYPE
		{
			C_BORDER					= 0,	//!< {[_[
			C_BACKGROUND				= 1,	//!< obNOEh
			C_TEXT						= 2,	//!< eLXg

			C_SELECTED_BACKGROUND		= 3,	//!< IĂobNOEh
			C_SELECTED_TEXT				= 4,	//!< IĂeLXg

			C_DLG_CAPTION_BACKGROUND	= 5,	//!< _CAÕLvṼobNOEh
			C_DLG_CAPTION_TEXT			= 6,	//!< _CAÕLvṼeLXg

			C_CTRL_BACKGROUND			= 7,	//!< Rg[̃obNOEhP
			C_CTRL_DARK_BACKGROUND		= 8,	//!< Rg[̃obNOEhQ
			C_CTRL_DARK_DARK_BACKGROUND	= 9,	//!< Rg[̃obNOEhR

			COLOR_TYPE_MAX				= 10,	//!< J[^Cv̐
		};

	private:
		typedef std::set<UI::Dialog*> DialogMap;
		typedef std::list<UI::Dialog*> DialogList;

	private:
		Mix::HID::IMouse* m_pMouse;
		Mix::Graphics::Utility::ICanvasRenderer* m_pCanvasRenderer;
		Mix::Graphics::Utility::IFont* m_pFont;

		Mix::Vector4 m_ColorList[Manager::COLOR_TYPE_MAX];

		Manager::DialogMap m_DialogMap;
		Manager::DialogList m_DialogUpdateList;
		Manager::DialogList m_DialogDrawList;

		UI::Dialog* m_pActiveDialog;

	public:
		//! @brief RXgN^
		Manager( void );
		//! @brief fXgN^
		~Manager( void );

	public:
		//! @brief }l[W܂
		//! @param[in] pMosue Ɏgp}EX
		//! @param[in] pCanvasRenderer `ɎgpLoX_[
		//! @param[in] pFont eLXg̕`ɎgptHg
		void Initialize( Mix::HID::IMouse* pMouse, Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer, Mix::Graphics::Utility::IFont* pFont );
		//! @brief }l[WXV܂
		void Update( void );
		//! @brief }l[Wj܂
		//! @note UI::Dialog::OnDisposeAUI::Control::OnDispose Ăяo܂
		void Dispose( void );

		//! @brief J[ݒ肵܂
		//! @param[in] type J[^Cv
		//! @param[in] color ݒ肷J[
		void SetColor( Manager::COLOR_TYPE type, const Mix::Vector4& color );
		//! @brief J[擾܂
		//! @param[in] type J[^Cv
		//! @return J[Ԃ܂
		const Mix::Vector4& GetColor( Manager::COLOR_TYPE type ) const;

	private:
		void AddDialog( UI::Dialog* pDialog );
		void RemoveDialog( UI::Dialog* pDialog );

		friend class Dialog;
	};

}}
