#include "Utility/UI/Slider.h"
#include "Mix/Graphics.h"

namespace Utility{ namespace UI {

////////////////////////////////////////////////////////////////////////////////////////////////////
// SliderI
////////////////////////////////////////////////////////////////////////////////////////////////////

SliderI::SliderI( void )
{
}

SliderI::~SliderI( void )
{
}

void SliderI::OnInitialize( void )
{
	GetParent()->OnSlider_ValueChanged( this );
	OnUpdateDispText();
}

void SliderI::OnValueChanged( void )
{
	UI::Dialog* pDialog = GetParent();

	if( pDialog != NULL )
	{
		pDialog->OnSlider_ValueChanged( this );
	}
}

void SliderI::OnUpdateDispText( void )
{
	if( m_Text.GetNum() > 0 )
	{
		m_DispText.Sprintf( L"%s:%d", m_Text.GetConstPtr(), m_Value );
	}
	else
	{
		m_DispText.Sprintf( L"%d", m_Value );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// SliderF
////////////////////////////////////////////////////////////////////////////////////////////////////

SliderF::SliderF( void )
{
}

SliderF::~SliderF( void )
{
}

void SliderF::OnInitialize( void )
{
	GetParent()->OnSlider_ValueChanged( this );
	OnUpdateDispText();
}

void SliderF::OnValueChanged( void )
{
	UI::Dialog* pDialog = GetParent();

	if( pDialog != NULL )
	{
		pDialog->OnSlider_ValueChanged( this );
	}
}

void SliderF::OnUpdateDispText( void )
{
	if( m_Text.GetNum() > 0 )
	{
		m_DispText.Sprintf( L"%s:%.4f", m_Text.GetConstPtr(), m_Value );
	}
	else
	{
		m_DispText.Sprintf( L"%.4f", m_Value );
	}
}

}}
