#pragma once

//! @file Utility/UniversalCameraHelper.h
//! @brief jo[TJNXCN[ht@C

namespace Utility {

	//! @class UniversalCameraHelper
	//! @brief jo[TJwp[NX
	class UniversalCameraHelper
	{
	private:
		Mix::HID::IKeyboard* m_pKeyboard;
		Mix::HID::IMouse* m_pMouse;
		Float32 m_LinCoiffe;
		Float32 m_RotCoiffe;

		Mix::Vector3 m_PrePos;
		Mix::Vector3 m_Pos;
		Mix::Vector3 m_Dir;
		Mix::Vector3 m_Vel;

		Mix::Vector3 m_At;

	public:
		//! @brief RXgN^
		UniversalCameraHelper( void );
		//! @brief fXgN^
		~UniversalCameraHelper( void );

	public:
		//! @brief ܂
		//! @param[in] pKeyboard L[{[h\ Mix::HID::IKeyboard C^[tF[X̃|C^
		//! @param[in] pMouse }EX\ Mix::HID::IMouse C^[tF[X̃|C^
		//! @param[in] pos ̎_\ Mix::Vector3 NX
		//! @param[in] target ̒_\ Mix::Vector3 NX
		//! @param[in] linCoiffe ړ̒l( 0.0f`̖ )
		//! @param[in] rotCoiffe ]̒l( 0.0f`̖ )
		void Initialize(	Mix::HID::IKeyboard* pKeyboard,
							Mix::HID::IMouse* pMouse,
							const Mix::Vector3& pos,
							const Mix::Vector3& target,
							Float32 linCoiffe = 0.1f,
							Float32 rotCoiffe = 0.01f );

		//! @brief XV܂
		void Update( void );
		//! @brief tbV܂
		//! @param[in] eye _
		//! @note
		//! XVɎ_ύXۂɕKvɂȂ܂B<br>
		//! ʏ͍XV( Update )݂̂Ō\łB
		void Refresh( const Mix::Vector3& eye );

		//! @brief _擾܂
		//! @return _\ Mix::Vector3 NXԂ܂
		const Mix::Vector3& GetEye( void ) const;
		//! @brief _擾܂
		//! @return _\ Mix::Vector3 NXԂ܂
		const Mix::Vector3& GetAt( void ) const;
		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		const Mix::Vector3& GetUp( void ) const;
		//! @brief x擾܂
		//! @return x\ Mix::Vector3 NXԂ܂
		const Mix::Vector3& GetVelocity( void ) const;

		//! @brief ɓnꂽC^[tF[X܂
		void Dispose( void );

	private:
		static const Mix::Vector3 UP_VEC;
	};
}
