#pragma once

//! @file Utility/ViewCameraHelper.h
//! @brief r[Jwp[NXCN[ht@C

namespace Utility {

	//! @class ViewCameraHelper
	//! @brief r[Jwp[NX
	class ViewCameraHelper
	{
	private:
		Mix::HID::IMouse* m_pMouse;
		Mix::HID::IKeyboard* m_pKeyboard;

		Float32 m_AtCoiffe;
		Float32 m_RotCoiffe;
		Float32 m_CtrlDistCoiffe;
		Float32 m_WheelDistCoiffe;

		Mix::Vector3 m_At;
		Mix::Quaternion m_Rot;
		Float32 m_Dist;

	public:
		//! @brief RXgN^
		ViewCameraHelper( void );
		//! @brief fXgN^
		~ViewCameraHelper( void );

	public:
		//! @brief ܂
		//! @param[in] pMouse }EX
		//! @param[in] pKeyboard L[{[h
		//! @param[in] at ̒_
		//! @param[in] rot ̉]
		//! @param[in] dist ̋
		//! @param[in] atCoiffe _̈ړɉe钲l
		//! @param[in] rotCoiffe ]ɉe钲l
		//! @param[in] ctrlDistCoiffe ̕ύXɉe钲l( Rg[L[ )
		//! @param[in] wheelDistCoiffe ̕ύXɉe钲l( zC[ )
		void Initialize(	Mix::HID::IMouse* pMouse, Mix::HID::IKeyboard* pKeyboard,
							const Mix::Vector3& at, const Mix::Vector2& rot, Float32 dist,
							Float32 atCoiffe = 0.01f, Float32 rotCoiffe = 0.01f, Float32 ctrlDistCoiffe = 0.1f, Float32 wheelDistCoiffe = 0.4f );

		//! @brief XV܂
		void Update( void );

		//! @brief j܂
		//! @note }EXAL[{[h܂
		void Dispose( void );

		//! @brief _擾܂
		//! @return _Ԃ܂
		const Mix::Vector3& GetAt( void ) const;
		//! @brief ]擾܂
		//! @return ]Ԃ܂
		const Mix::Quaternion& GetRotation( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		Float32 GetDistance( void ) const;
	};
}
