#pragma once

//! @file Mix/Dynamics/IBallJoint.h
//! @brief {[WCgC^[tF[XCN[ht@C

#include "Mix/Dynamics/IJoint.h"

namespace Mix{ namespace Dynamics{

	//! @class IBallJoint
	//! @brief {[WCgC^[tF[X
	//! @note
	//! u_ڑvu~̉ғ͈́vuЂ˂̊pxvōS܂B
	class IBallJoint : public Mix::Dynamics::IJoint
	{
	protected:
		//! @brief fXgN^
		virtual ~IBallJoint( void ){}

	public:
		//! @brief cCXg̎擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetTwistAxis( void ) const = 0;
		//! @brief cCXg̎ݒ肵܂
		//! @param[in] axis \ Mix::Vector3 NX
		virtual void SetTwistAxis( const Mix::Vector3& axis ) = 0;

		//! @brief cCXg̍őpx擾܂
		//! @return őpxԂ܂
		virtual Float32 GetTwistLimit( void ) const = 0;
		//! @brief cCXg̍őpxݒ肵܂
		//! @param[in] limit őpx( WAP )
		virtual void SetTwistLimit( Float32 limit ) = 0;

		//! @brief XCO̎擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetSwingAxis( void ) const = 0;
		//! @brief XCO̎ݒ肵܂
		//! @param[in] axis \ Mix::Vector3 NX
		virtual void SetSwingAxis( const Mix::Vector3& axis ) = 0;

		//! @brief XCOP̍őpx擾܂
		//! @return őpxԂ܂
		virtual Float32 GetSwingLimit1( void ) const = 0;
		//! @brief XCO1̍őpxݒ肵܂
		//! @param[in] limit őpx(WAP)
		virtual void SetSwingLimit1( Float32 limit ) = 0;

		//! @brief XCOQ̍őpx擾܂
		//! @return őpxԂ܂
		virtual Float32 GetSwingLimit2( void ) const = 0;
		//! @brief XCOQ̍őpxݒ肵܂
		//! @param[in] limit őpx(WAP)
		virtual void SetSwingLimit2( Float32 limit ) = 0;

		//! @brief ^̌lݒ肵܂
		//! @param[in] damping ^̌l( 0.0f`1.0f )
		virtual void SetDamping( Float32 damping ) = 0;
		//! @brief ^̌l擾܂
		//! @return ^̌lԂ܂
		virtual Float32 GetDamping( void ) const = 0;

		//! @brief s{bg̃XvÔ炩擾܂
		//! @return 炩Ԃ܂
		virtual Float32 GetPivotSpring( void ) const = 0;
		//! @brief s{bg̃XvÔ炩ݒ肵܂
		//! @param[in] spring 炩( 0.0f`1.0f )
		virtual void SetPivotSpring( Float32 spring ) = 0;

		//! @brief s{bg̃_p[̌͂擾܂
		//! @return ͂Ԃ܂
		virtual Float32 GetPivotDamper( void ) const = 0;
		//! @brief s{bg̃_p[̌͂ݒ肵܂
		//! @param[in] damper ( 0.2f`0.8f )
		virtual void SetPivotDamper( Float32 damper ) = 0;

		//! @brief ~bg̃XvÔ炩擾܂
		//! @return 炩Ԃ܂
		virtual Float32 GetLimitSpring( void ) const = 0;
		//! @brief ~bg̃XvÔ炩ݒ肵܂
		//! @param[in] spring 炩( 0.0f`1.0f )
		virtual void SetLimitSpring( Float32 spring ) = 0;

		//! @brief ~bg̃_p[̌͂擾܂
		//! @return ͂Ԃ܂
		virtual Float32 GetLimitDamper( void ) const = 0;
		//! @brief ~bg̃_p[̌͂ݒ肵܂
		//! @param[in] damper ( 0.2f`0.8f )
		virtual void SetLimitDamper( Float32 damper ) = 0;
	};

}}
