#pragma once

//! @file Mix/Dynamics/IManager.h
//! @brief _Ci~NX}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Dynamics{

	//! @class IManager
	//! @brief _Ci~NX}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief XtBAVFCv쐬܂
		//! @param[in] radius a( radius > 0.0f )
		//! @param[out] ppSphereShape 쐬ꂽXtBAVFCv\ Mix::Dynamics::ISphereShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateSphereShape(	Float32 radius,
											Mix::Dynamics::ISphereShape** ppSphereShape,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief {bNXVFCv쐬܂
		//! @param[in] x X̃TCY( x > 0.0f )
		//! @param[in] y ỸTCY( y > 0.0f )
		//! @param[in] z Z̃TCY( z > 0.0f )
		//! @param[out] ppBoxShape 쐬ꂽ{bNXVFCv\ Mix::Dynamics::IBoxShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBoxShape(	Float32 x, Float32 y, Float32 z,
										Mix::Dynamics::IBoxShape** ppBoxShape,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief {bNXVFCv쐬܂
		//! @param[in] halfExtents TCY( halfExtents.x > 0.0f halfExtents.y > 0.0f halfExtents.z > 0.0f )
		//! @param[out] ppBoxShape 쐬ꂽ{bNXVFCv\ Mix::Dynamics::IBoxShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBoxShape(	const Mix::Vector3& halfExtents,
										Mix::Dynamics::IBoxShape** ppBoxShape,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief R[VFCv쐬܂
		//! @param[in] axis \ Mix::Dynamics::AXIS_TYPE 񋓒萔
		//! @param[in] height 
		//! @param[in] radius a
		//! @param[out] ppConeShape 쐬ꂽR[VFCv\ Mix::Dynamics::IConeShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateConeShape(	Mix::Dynamics::AXIS_TYPE axis,
											Float32 height, 
											Float32 radius,
											Mix::Dynamics::IConeShape** ppConeShape,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief JvZVFCv쐬܂
		//! @param[in] axis JvZ̎\ Mix::Dynamics::AXIS_TYPE 񋓒萔
		//! @param[in] height ̕܂ލ( length >= 0.0f )
		//! @param[in] radius a( radius > 0.0f )
		//! @param[out] ppCapsuleShape 쐬ꂽJvZVFCv\ Mix::Dynamics::ICapsuleShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateCapsuleShape(	Mix::Dynamics::AXIS_TYPE axis,
											Float32 height,
											Float32 radius,
											Mix::Dynamics::ICapsuleShape** ppCapsuleShape,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief V_[VFCv쐬܂
		//! @param[in] axis V_[̎\ Mix::Dynamics::AXIS_TYPE 񋓒萔
		//! @param[in] height 
		//! @param[in] radius a
		//! @param[out] ppCylinderShape 쐬ꂽV_[VFCv\ Mix::Dynamics::ICylinderShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateCylinderShape(	Mix::Dynamics::AXIS_TYPE axis,
												Float32 height,
												Float32 radius,
												Mix::Dynamics::ICylinderShape** ppCylinderShape,
												const wchar_t* pDebugName = NULL ) = 0;

		//! @brief RxbNXnVFCv쐬܂
		//! @param[in] mesh bV\ Mix::Dynamics::MESH \
		//! @param[out] ppConvexHullShape 쐬ꂽRxbNXtVFCv\ Mix::Dynamics::IConvexHullShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateConvexHullShape(	const Mix::Dynamics::MESH& mesh,
												Mix::Dynamics::IConvexHullShape** ppConvexHullShape,
												const wchar_t* pDebugName = NULL ) = 0;

		//! @brief RpEhVFCv쐬܂
		//! @param[out] ppCompoundShape 쐬ꂽRpEhVFCv\ Mix::Dynamics::ICompoundShape C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateCompoundShape(	Mix::Dynamics::ICompoundShape** ppCompoundShape,
												const wchar_t* pDebugName = NULL ) = 0;

		//! @brief |CgWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppPointJoint 쐬ꂽWCg\  Mix::Dynamics::IPointJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`̎QƃJE^ +1 ܂
		virtual Boolean CreatePointJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											const Mix::Vector3& pivotA,
											Mix::Dynamics::IPointJoint** ppPointJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief |CgWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pRigidBodyB S郊Wbh{fBa\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[in] pivotB Wbh{fBaSʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppPointJoint 쐬ꂽWCg\  Mix::Dynamics::IPointJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`ƃWbh{fBa̎QƃJE^ +1 ܂
		virtual Boolean CreatePointJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											Mix::Dynamics::IRigidBody* pRigidBodyB,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& pivotB,
											Mix::Dynamics::IPointJoint** ppPointJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief qWWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[in] axis ]\ Mix::Vector3 NX
		//! @param[out] ppHingeJoint 쐬ꂽWCg\ Mix::Dynamics::IHingeJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`̎QƃJE^ +1 ܂
		virtual Boolean CreateHingeJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& axis,
											Mix::Dynamics::IHingeJoint** ppHingeJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief qWWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pRigidBodyB S郊Wbh{fBa\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[in] pivotB Wbh{fBaSʒu( [J )\ Mix::Vector3 NX
		//! @param[in] axis ]\ Mix::Vector3 NX
		//! @param[out] ppHingeJoint 쐬ꂽWCg\ Mix::Dynamics::IHingeJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`ƃWbh{fBa̎QƃJE^ +1 ܂
		virtual Boolean CreateHingeJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											Mix::Dynamics::IRigidBody* pRigidBodyB,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& pivotB,
											const Mix::Vector3& axis,
											Mix::Dynamics::IHingeJoint** ppHingeJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief XC_[WCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] rotA Wbh{fB`Sʒuł̉]\ Mix::Vector3 NX
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppSliderJoint 쐬ꂽWCg\ Mix::Dynamics::ISliderJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`̎QƃJE^ +1 ܂
		virtual Boolean CreateSliderJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											const Mix::Quaternion& rotA,
											const Mix::Vector3& pivotA,
											Mix::Dynamics::ISliderJoint** ppSliderJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief XC_[WCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pRigidBodyB S郊Wbh{fBa\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] rotA Wbh{fB`Sʒuł̉]\ Mix::Vector3 NX
		//! @param[in] rotB Wbh{fBaSʒuł̉]\ Mix::Vector3 NX
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[in] pivotB Wbh{fBaSʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppSliderJoint 쐬ꂽWCg\ Mix::Dynamics::ISliderJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`ƃWbh{fBa̎QƃJE^ +1 ܂
		virtual Boolean CreateSliderJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											Mix::Dynamics::IRigidBody* pRigidBodyB,
											const Mix::Quaternion& rotA,
											const Mix::Quaternion& rotB,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& pivotB,
											Mix::Dynamics::ISliderJoint** ppSliderJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief DOFWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] rotA Wbh{fB`Sʒuł̉]\ Mix::Vector3 NX
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppDofJoint 쐬ꂽWCg\ Mix::Dynamics::IDofJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`̎QƃJE^ +1 ܂
		virtual Boolean CreateDofJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
										const Mix::Quaternion& rotA,
										const Mix::Vector3& pivotA,
										Mix::Dynamics::IDofJoint** ppDofJoint,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief DOFWCg쐬܂
		//! @param[in] pRigidBodyA S郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pRigidBodyB S郊Wbh{fBa\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] rotA Wbh{fB`Sʒuł̉]\ Mix::Vector3 NX
		//! @param[in] rotB Wbh{fBaSʒuł̉]\ Mix::Vector3 NX
		//! @param[in] pivotA Wbh{fB`Sʒu( [J )\ Mix::Vector3 NX
		//! @param[in] pivotB Wbh{fBaSʒu( [J )\ Mix::Vector3 NX
		//! @param[out] ppDofJoint 쐬ꂽWCg\ Mix::Dynamics::IDofJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`ƃWbh{fBa̎QƃJE^ +1 ܂
		virtual Boolean CreateDofJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
										Mix::Dynamics::IRigidBody* pRigidBodyB,
										const Mix::Quaternion& rotA,
										const Mix::Quaternion& rotB,
										const Mix::Vector3& pivotA,
										const Mix::Vector3& pivotB,
										Mix::Dynamics::IDofJoint** ppDofJoint,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief {[WCg쐬܂
		//! @param[in] pRigidBodyA ڍ郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`̐ڍʒu( [J )\ Mix::Vector3 NX
		//! @param[in] twistAxis cCXg̎\ Mix::Vector3 NX
		//! @param[in] swingAxis XCO̎\ Mix::Vector3 NX
		//! @param[out] ppBallJoint 쐬ꂽWCgn Mix::Dynamics::IBallJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`̎QƃJE^ +1 ܂
		virtual Boolean CreateBallJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& twistAxis,
											const Mix::Vector3& swingAxis,
											Mix::Dynamics::IBallJoint** ppBallJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief {[WCg쐬܂
		//! @param[in] pRigidBodyA ڍ郊Wbh{fB`\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pRigidBodyB ڍ郊Wbh{fBa\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^
		//! @param[in] pivotA Wbh{fB`̐ڍʒu( [J )\ Mix::Vector3 NX
		//! @param[in] pivotB Wbh{fBa̐ڍʒu( [J )\ Mix::Vector3 NX
		//! @param[in] twistAxis cCXg̎\ Mix::Vector3 NX
		//! @param[in] swingAxis XCO̎\ Mix::Vector3 NX
		//! @param[out] ppBallJoint 쐬ꂽWCgn Mix::Dynamics::IBallJoint C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAWbh{fB`ƃWbh{fBa̎QƃJE^ +1 ܂
		virtual Boolean CreateBallJoint(	Mix::Dynamics::IRigidBody* pRigidBodyA,
											Mix::Dynamics::IRigidBody* pRigidBodyB,
											const Mix::Vector3& pivotA,
											const Mix::Vector3& pivotB,
											const Mix::Vector3& twistAxis,
											const Mix::Vector3& swingAxis,
											Mix::Dynamics::IBallJoint** ppBallJoint,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief [h쐬܂
		//! @param[in] config [h̐ݒ\ Mix::Dynamics::WORLD_CONFIG \
		//! @param[out] ppWorld 쐬[h\ Mix::Dynamics::IWorld C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateWorld( const Mix::Dynamics::WORLD_CONFIG& config, Mix::Dynamics::IWorld** ppWorld, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief X^eBbNv[쐬܂
		//! @param[in] normal ʂ̖@
		//! @param[in] constant ʂ̖@ւ̃ItZbg
		//! @param[out] ppStaticPlane 쐬X^eBbNv[n Mix::Dynamics::IStaticPlane C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateStaticPlane(	const Mix::Vector3& normal,
											Float32 constant,
											Mix::Dynamics::IStaticPlane** ppStaticPlane,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief X^eBbNbV쐬܂
		//! @param[in] meshes bV\ Mix::Dynamics::MESH \̂̔z
		//! @param[in] meshNum bV
		//! @param[in] materialNum }eA
		//! @param[out] ppStaticMesh 쐬X^eBbNbVn Mix::Dynamics::IStaticMesh C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateStaticMesh(	const Mix::Dynamics::MESH* meshes,
											UInt32 meshNum,
											UInt32 materialNum,
											Mix::Dynamics::IStaticMesh** ppStaticMesh,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief X^eBbNbV쐬܂
		//! @param[in] pBuffer ̃t@C\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[in] materialNum }eA
		//! @param[out] ppStaticMesh 쐬X^eBbNbVn Mix::Dynamics::IStaticMesh C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note pBuffer ̓e btBvhTriangleMeshShape VACŶɂȂ܂B
		virtual Boolean CreateStaticMesh(	Mix::Memory::IBuffer* pBuffer,
											UInt32 materialNum,
											Mix::Dynamics::IStaticMesh** ppStaticMesh,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief Wbh{fB쐬܂
		//! @param[in] mass 
		//! @param[in] pShape Wbh{fB̌` Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[out] ppRigidBody 쐬ꂽWbh{fB\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAVFCv̎QƃJE^ +1 ܂
		virtual Boolean CreateRigidBody(	Float32 mass,
											Mix::Dynamics::IShape* pShape,
											Mix::Dynamics::IRigidBody** ppRigidBody,
											const wchar_t* pDebugName = NULL ) = 0;

		//! @brief ZT[쐬܂
		//! @param[in] pShape `\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[out] ppSensor 쐬ꂽZT[n Mix::Dynamics::ISensor C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇAVFCv̎QƃJE^ +1 ܂
		virtual Boolean CreateSensor(	Mix::Dynamics::IShape* pShape,
										Mix::Dynamics::ISensor** ppSensor,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief Ll}eBbNLN^[쐬܂
		//! @param[in] height g
		//! @param[in] radius a
		//! @param[in] stepHeight 邱Ƃłi̍
		//! @param[out] ppKinematicCharacter 쐬ꂽLl}eBbNLN^[n Mix::Dynamics::IKinematicCharacter C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateKinematicCharacter(	Float32 height,
													Float32 radius,
													Float32 stepHeight,
													Mix::Dynamics::IKinematicCharacter** ppKinematicCharacter,
													const wchar_t* pDebugName = NULL ) = 0;

		//! @brief rnCN쐬܂
		//! @param[in] mass ( mass > 0.0f )
		//! @param[in] pShape ԑ̂̌`\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[in] wheels zC[\ Mix::Dynamics::VEHICLE_WHEEL_DESC \̂̔z
		//! @param[in] wheelNum zC[̐
		//! @param[out] ppVehicle 쐬rnCN\ Mix::Dynamics::IVehicle C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateVehicle(	Float32 mass,
										Mix::Dynamics::IShape* pShape,
										const Mix::Dynamics::VEHICLE_WHEEL_DESC* wheels,
										UInt32 wheelNum,
										Mix::Dynamics::IVehicle** ppVehicle,
										const wchar_t* pDebugName = NULL ) = 0;

		//! @brief IuWFNghbK[쐬܂
		//! @param[in] pWorld hbOɎgp郏[h\ Mix::Dynamics::IWorld C^[tF[X̃|C^
		//! @param[out] ppObjectDragger 쐬IuWFNghbK[n Mix::Dynamics::IObjectPicker C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇ [h̎QƃJE^ +1 ܂
		virtual Boolean CreateObjectDragger(	Mix::Dynamics::IWorld* pWorld,
												Mix::Dynamics::IObjectDragger** ppObjectDragger,
												const wchar_t* pDebugName = NULL ) = 0;

	public:
		//! @brief fobO`̐F擾܂
		//! @param[in] type 擾F̃^Cv\ Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE 񋓒萔
		//! @return 擾F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& Debug_GetDrawColor( Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE type ) const = 0;
		//! @brief fobO`̐Fݒ肵܂
		//! @param[in] type ݒ肷F̃^Cv\ Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE 񋓒萔
		//! @param[in] color ݒ肷F\ Mix::Vector4 NXԂ܂
		virtual void Debug_SetDrawColor( Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE type, const Mix::Vector4& color ) = 0;
	};

}}
