#pragma once

//! @file Mix/Dynamics/IRigidBody.h
//! @brief Wbh{fBC^[tF[XCN[ht@C

#include "Mix/Dynamics/IObject.h"

namespace Mix{ namespace Dynamics{

	//! @class IRigidBody
	//! @brief Wbh{fBC^[tF[X
	//! @note
	//! Wbh{fBƂ̓[hɔzu邱ƂłIuWFNgłAނɂĉe̎dς܂B<br>
	//! <br>
	//! <b>_Ci~bN( Mix::Dynamics::RIGIDBODY_TYPE_DYNAMIC )</b><br>
	//! ʂAt[ƂɎpXV܂B<br>
	//! <br>
	//! <b>X^eBbN( Mix::Dynamics::RIGIDBODY_TYPE_STATIC )</b><br>
	//! ʂ 0 łAՓ˂͂܂AƂ͂܂B<br>
	//! <br>
	//! <b>Ll}eBbN( Mix::Dynamics::RIGIDBODY_TYPE_KINEMATIC )</b><br>
	//! ʂ 0 łA_Ci~bNWbh{fB肷邱Ƃ͂ł܂A<br>
	//! ̃_Ci~bNWbh{fB̉e󂯂邱Ƃ͂܂B( ꂽ肷邱Ƃ͂Ȃ )<br>
	//! <br>
	//! <b>gK[( Mix::Dynamics::RIGIDBODY_TYPE_TRIGGER )</b><br>
	//! ʂ 0 łÃWbh{fBƏՓ˂邱Ƃ͂܂B<br>
	//! <br>
	//! ̂uX^eBbNvuLl}eBbNvugK[vł͈ȉ̃\bh͋@\܂B<br>
	//! <br>
	//! SetAlwaysActive
	//! Activate<br>
	//! SetGravityAcceleration<br>
	//! SetLinearDamping<br>
	//! SetAngularDamping<br>
	//! SetLinearVelocity<br>
	//! SetAngularVelocity<br>
	//! ApplyCentralForce<br>
	//! ApplyForce<br>
	//! ApplyTorque<br>
	//! ApplyCentralImpulse<br>
	//! ApplyTorqueImpulse<br>
	//! ApplyImpulse<br>
	//! ClearForces<br>
	//! <br>
	//! ͎ʂ 0 ł邱ƂAʕ̂ƂĈA̗͂ĂȂƂƂӖ܂B
	class IRigidBody : public Mix::Dynamics::IObject
	{
	public:
		//! @enum STATUS
		//! @brief Xe[^X񋓒萔
		enum STATUS
		{
			//! @brief ftHg
			//! @note uՓˁvuvsAʂ̂\܂B
			DEFAULT		= 0,

			//! @brief X^eBbN
			//! @note uՓˁv݂̂sAƂłȂʂȂ̂\܂B
			STATIC		= 1,

			//! @brief Ll}eBbN
			//! @note uՓˁv݂̂sAƂł鎿ʂȂ̂\܂B
			KINEMATIC	= 2,
		};

	protected:
		//! @brief fXgN^
		virtual ~IRigidBody( void ){}

	public:
		//! @brief V~[VLǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsSimulationEnabled( void ) const = 0;
		//! @brief V~[VLɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetSimulationEnabled( Boolean state ) = 0;

		//! @brief ʂ擾܂
		//! @return ʂ擾܂
		virtual Float32 GetMass( void ) const = 0;
		//! @brief ʂݒ肵܂
		//! @param[in] mass ( mass >= 0.0f )
		//! @note
		//! SetStatus  Mix::Dynamics::RIGIDBODY_DEFAULT ɐݒ肳Ăꍇ 0.0f ȉ̒lݒ肷ƁA<br>
		//! I Mix::Dynamics::RIGIDBODY_STATIC ɐ؂ւ܂B<br>
		//! ܂ Mix::Dynamics::RIGIDBODY_STATIC ɐݒ肳Ăꍇ 0.0f 傫lݒ肳ƁA
		//! Mix::Dynamics::RIGIDBODY_DEFAULT ɐ؂ւ܂B<br>
		//! <br>
		//! Mix::Dynamics::RIGIDBODY_KINEMATIC ɐݒ肳ĂꍇA<br>
		//! GetMass ͐ݒ肳ꂽlԂ܂AIɂ͖ʕ( =0 )̂܂܂ɂȂ܂B<br>
		//! SetType  Mix::Dynamics::RIGIDBODY_DEFAULT ݒ肵ȂAʕ̂ɂ͂Ȃ܂B
		virtual void SetMass( Float32 mass ) = 0;

		//! @brief Ԃ擾܂
		//! @return Ԃ\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔Ԃ܂
		virtual Mix::Dynamics::IRigidBody::STATUS GetStatus( void ) const = 0;
		//! @brief Ԃݒ肵܂
		//! @param[in] status Ԃ\ Mix::Dynamics::IRigidBody::STATUS 񋓒萔
		//! @return ꍇ True Ԃ܂
		//! @note ʂȌԂŃXe[^XftHgɐݒ肵悤ƂꍇÃ\bh False Ԃ܂
		virtual Boolean SetStatus( Mix::Dynamics::IRigidBody::STATUS status ) = 0;

		//! @brief ݒ擾܂
		//! @return ɊԂɐݒ肳Ăꍇ True Ԃ܂
		virtual Boolean IsAlwaysActive( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] state ɊԂɂꍇ True
		//! @return ꍇ True Ԃ܂
		//! @note Xe[^XuX^eBbNv̏ꍇÃ\bh False Ԃ܂
		virtual Boolean SetAlwaysActive( Boolean state ) = 0;

		//! @brief Ԃ擾܂
		//! @return Ԃ̏ꍇ True Ԃ܂
		virtual Boolean IsActive( void ) const = 0;
		//! @brief Ԃɂ܂
		//! @return ꍇ True Ԃ܂
		//! @note Xe[^XuX^eBbNv̏ꍇÃ\bh False Ԃ܂
		virtual Boolean Activate( void ) = 0;
		//! @brief 񊈓Ԃɂ܂
		//! @param[in] bFroce Iɔ񊈓Ԃɂꍇ True
		//! @return ꍇ True Ԃ܂
		//! @note Xe[^XuX^eBbNvuLl}eBbNv̏ꍇÃ\bh False Ԃ܂
		virtual Boolean Deactivate( Boolean bFroce = False ) = 0;

		//! @brief ړ̃t@N^ݒ肵܂
		//! @return ړ̃t@N^\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetLinearFactor( void ) const = 0;
		//! @brief ړ̃t@N^ݒ肵܂
		//! @param[in] factor ړ̃t@N^\ Mix::Vector3 NX
		//! @note Mix::Vector3( 0.0f, 0.0f, 0.0f ) w肷ƈړȂȂ܂
		virtual void SetLinearFactor( const Mix::Vector3& factor ) = 0;

		//! @brief ړ̌l擾܂
		//! @return ړ̌lԂ܂
		virtual Float32 GetLinearDamping( void ) const = 0;
		//! @brief ړ̌lݒ肵܂
		//! @param[in] damping ړɂ錸l( 0.0f <= damping < 1.0f )
		virtual void SetLinearDamping( Float32 damping ) = 0;

		//! @brief ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetLinearVelocity( void ) = 0;
		//! @brief ړxݒ肵܂
		//! @param[in] velocity `x\ Mix::Vector3 NX
		virtual Boolean SetLinearVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief ړ~鑬x擾܂
		//! @return ړ~鑬xԂ܂
		virtual Float32 GetLinearSleepingThresholds( void ) const = 0;
		//! @brief ړ~鑬xݒ肵܂
		//! @param[in] thresholds ړ~鑬x
		virtual void SetLinearSleepingThresholds( Float32 thresholds ) = 0;

		//! @brief ]̃t@N^ݒ肵܂
		//! @return ]̃t@N^\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetAngularFactor( void ) const = 0;
		//! @brief ]̃t@N^ݒ肵܂
		//! @param[in] factor ]̃t@N^\ Mix::Vector3 NX
		//! @note Mix::Vector3( 0.0f, 0.0f, 0.0f ) ݒ肷Ɖ]ȂȂ܂
		virtual void SetAngularFactor( const Mix::Vector3& factor ) = 0;

		//! @brief ]̌l擾܂
		//! @return ]̌lԂ܂
		virtual Float32 GetAngularDamping( void ) const = 0;
		//! @brief ]̌lݒ肵܂
		//! @param[in] damping ]^ɂ錸l( 0.0f <= damping < 1.0f )
		virtual void SetAngularDamping( Float32 damping ) = 0;

		//! @brief ]x擾܂
		//! @return ]x\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetAngularVelocity( void ) = 0;
		//! @brief ]xݒ肵܂
		//! @param[in] velocity ]x\ Mix::Vector3 NX
		virtual Boolean SetAngularVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief ]~鑬x擾܂
		//! @return ]~鑬xԂ܂
		virtual Float32 GetAngularSleepingThresholds( void ) const = 0;
		//! @brief ]~鑬xݒ肵܂
		//! @param[in] thresholds ]~鑬x
		virtual void SetAngularSleepingThresholds( Float32 thresholds ) = 0;

		//! @brief ړɌ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		virtual Boolean ApplyLinearImpulse( const Mix::Vector3& impulse ) = 0;
		//! @brief ]Ɍ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		virtual Boolean ApplyAngularImpulse( const Mix::Vector3& impulse ) = 0;
		//! @brief w肵ʒuɌ͂Kp܂
		//! @param[in] impulse Kp錂͂\ Mix::Vector3 NX
		//! @param[in] pos ͂Kpʒu\ Mix::Vector3 NX
		virtual Boolean ApplyImpulse( const Mix::Vector3& impulse, const Mix::Vector3& pos ) = 0;

		//! @brief ړɓKpĂ͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetTotalLinearForce( void ) = 0;
		//! @brief ]ɓKpĂ͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetTotalAngularForce( void ) = 0;
		//! @brief ړɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		virtual Boolean ApplyLinearForce( const Mix::Vector3& force ) = 0;
		//! @brief ]ɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		virtual Boolean ApplyAngularForce( const Mix::Vector3& force ) = 0;
		//! @brief w肵ʒuɗ͂Kp܂
		//! @param[in] force Kp͂\ Mix::Vector3 NX
		//! @param[in] pos ͂Kpʒu\ Mix::Vector3 NX
		virtual Boolean ApplyForce( const Mix::Vector3& force, const Mix::Vector3& pos ) = 0;
		//! @brief KpĂ͂NA܂
		virtual void ClearForce( void ) = 0;

		//! @brief [VNA܂
		//! @note SĂ̑xASẴtH[XAԗpp[^NA܂
		virtual void ClearMotion( void ) = 0;
		//! @brief [VNA܂
		//! @param[in] rot NẢ]\ Mix::Quaternion NX
		//! @param[in] pos NÄʒu\ Mix::Vector3 NX
		virtual void ClearMotion( const Mix::Quaternion& rot, const Mix::Vector3& pos ) = 0;

		//! @brief e\XV܂
		//! @return ꍇ True Ԃ܂
		//! @note
		//! `󂪕ωVFCvAɃRpEhVFCv( Mix::Dynamics::ICompoundShape ) ɎqǉۂɎgp܂B<br>
		//! ܂ GetStatus ŕԂl Mix::Dynamics::RIGIDBODY_STATIC   Mix::Dynamics::RIGIDBODY_KINEMATIC ̏ꍇ́A False Ԃ܂B<br>
		virtual Boolean UpdateLocalInertia( void ) = 0;
	};

}}
