#pragma once

//! @file Mix/Graphics/IManager.h
//! @brief OtBbNX}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class IManager
	//! @brief OtBbNX}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief OtBbNXfoCX擾܂
		//! @param[out] ppDevice 擾OtBbNXfoCXn Mix::Graphics::IDevice C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetDevice( Mix::Graphics::IDevice** ppDevice ) = 0;

		//! @brief ^[QbgeNX``FC쐬܂
		//! @param[in] width ^[QbgeNX`̕
		//! @param[in] height ^[QbgeNX`̍
		//! @param[in] format ^[QbgeNX`̃tH[}bg
		//! @param[out] ppTargetTextureChain 쐬^[QbgeNX``FCn Mix::Graphics::Utility::ITargetTextureChain C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTargetTextureChain(	UInt32 width,
													UInt32 height,
													Mix::Graphics::FORMAT format,
													Mix::Graphics::Utility::ITargetTextureChain** ppTargetTextureChain,
													const wchar_t* pDebugName = NULL ) = 0;

		//! @brief tHgt@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppFont 쐬tHgn Mix::Graphics::Utility::IFont C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFontFromFile( const wchar_t* pFilePath, Mix::Graphics::Utility::IFont** ppFont ) = 0;
		//! @brief tHg̃t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[in] pBuffer ̃t@C\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppFont 쐬tHgn Mix::Graphics::Utility::IFont C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇApBuffer ̎QƃJE^ +1 ܂
		virtual Boolean CreateFontFromMemory( const wchar_t* pFilePath, Mix::Memory::IBuffer* pBuffer, Mix::Graphics::Utility::IFont** ppFont ) = 0;

		//! @brief LoX_[쐬܂
		//! @param[out] ppCanvasRenderer 쐬LoX_[n Mix::Graphics::Utility::ICanvasRenderer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateCanvasRenderer( Mix::Graphics::Utility::ICanvasRenderer** ppCanvasRenderer, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief p[XyNeBu_[쐬܂
		//! @param[out] ppPerspectiveRenderer 쐬p[XyNeBu_[n Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePerspectiveRenderer( Mix::Graphics::Utility::IPerspectiveRenderer** ppPerspectiveRenderer, const wchar_t* pDebugName = NULL ) = 0;
	};

}}
