#pragma once

//! @file Mix/HID/IManager.h
//! @brief Cvbg}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace HID{

	//! @class IManager
	//! @brief Cvbg}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief L[{[h擾܂
		//! @param[out] ppKeyboard 擾L[{[hn Mix::HID::IKeyboard C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetKeyboard( Mix::HID::IKeyboard** ppKeyboard ) = 0;

		//! @brief }EX擾܂
		//! @param[out] ppMouse 擾}EXn Mix::HID::IMouse C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetMouse( Mix::HID::IMouse** ppMouse ) = 0;

		//! @brief Q[pbh擾܂
		//! @param[in] port Q[pbh̃|[g( Mix::HID::GAMEPAD_PORT )
		//! @param[out] ppGamepad 擾Q[pbh\ Mix::HID::IGamepad C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetGamepad( UInt32 port, Mix::HID::IGamepad** ppGamepad ) = 0;
		//! @brief p\ȃQ[pbh擾܂
		//! @param[in] api D悷Q[pbhAPI
		//! @param[out] ppGamepad 擾Q[pbh\ Mix::HID::IGamepad C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note api  Mix::HID::GAMEPAD_UNKNOWN w肵ꍇ XInput D悵܂
		virtual Boolean FindGamepad( Mix::HID::GAMEPAD_API api, Mix::HID::IGamepad** ppGamepad ) = 0;
	};

}}
