#pragma once

//! @file Mix/Quaternion.h
//! @brief NH[^jINXCN[ht@C

namespace Mix{

	//! @class Quaternion
	//! @brief NH[^jINX
	class _MIX_DLL_API Quaternion
	{
	public:
		union
		{
			Float32 data[4];	//!< z

			struct
			{
				Float32 x;	//!< X
				Float32 y;	//!< Y
				Float32 z;	//!< Z
				Float32 w;	//!< W
			};
		};

	public:
		//! @brief RXgN^
		Quaternion( void );
		//! @brief Rs[RXgN^
		//! @param[in] q NH[^jI
		Quaternion( const Quaternion& q );
		//! @brief RXgN^
		//! @param[in] qx w
		//! @param[in] qy x
		//! @param[in] qz y
		//! @param[in] qw v
		Quaternion( Float32 qx, Float32 qy, Float32 qz, Float32 qw );
		//! @brief RXgN^
		//! @param[in] axis 
		//! @param[in] angle ]̊px(WAP)
		Quaternion( const Mix::Vector3& axis, Float32 angle );
		//! @brief fXgN^
		~Quaternion( void );

	public:
		//! @brief Cӂ̎ł̉]ݒ肵܂
		//! @param[in] axis 
		//! @param[in] angle ]̊px(WAP)
		void SetRotationAxis( const Mix::Vector3& axis, Float32 angle );
		//! @brief Cӂ̎ŉ]܂
		//! @param[in] axis 
		//! @param[in] angle ]̊px(WAP)
		void RotationAxis( const Mix::Vector3& axis, Float32 angle );

		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		Mix::Vector3 GetAxis( void ) const;
		//! @brief px(WAP)擾܂
		//! @return pxԂ܂
		Float32 GetAngle( void ) const;

		//! @brief K܂
		void Normalize( void );
		//! @brief KNH[^jI擾܂
		//! @return KNH[^jI
		Quaternion ToNormalize( void ) const;

		//! @brief ]܂
		void Inverse( void );
		//! @brief ]NH[^jI擾܂
		//! @return ]NH[^jI
		Quaternion ToInverse( void ) const;

	public:
		//! @brief r
		//! @param[in] q rNH[^jI
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( const Quaternion& q ) const;
		//! @brief r
		//! @param[in] q rNH[^jI
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( const Quaternion& q ) const;

		//! @brief 
		//! @param[in] q l
		//! @return ꂽl
		Quaternion& operator = ( const Quaternion& q );
		//! @brief Z
		//! @param[in] q Zl
		//! @return Zꂽl
		Quaternion& operator += ( const Quaternion& q );
		//! @brief Z
		//! @param[in] q Zl
		//! @return Zꂽl
		Quaternion& operator -= ( const Quaternion& q );
		//! @brief Z
		//! @param[in] q Zl
		//! @return Zꂽl
		Quaternion& operator *= ( const Quaternion& q );
		//! @brief Z
		//! @param[in] v Zl
		//! @return Zꂽl
		Quaternion& operator *= ( Float32 v );

		//! @brief Z
		//! @param[in] q Zl
		//! @return 
		Quaternion operator + ( const Quaternion& q ) const;
		//! @brief Z
		//! @param[in] q Zl
		//! @return 
		Quaternion operator - ( const Quaternion& q ) const;
		//! @brief Z
		//! @param[in] q Zl
		//! @return 
		Quaternion operator * ( const Quaternion& q ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return 
		Quaternion operator * ( Float32 v ) const;

		//! @brief 𔽓]܂
		//! @return 𔽓]NH[^jIԂ܂
		Quaternion operator -( void ) const;

	public:
		//! @brief ̃NH[^jI̓ς߂܂
		//! @param[in] l NH[^jIA
		//! @param[in] r NH[^jIB
		//! @return ςԂ܂
		static Float32 Dot( const Mix::Quaternion& l, const Mix::Quaternion& r );
		//! @brief ̃NH[^jI̊Oς߂܂
		//! @param[in] l NH[^jIA
		//! @param[in] r NH[^jIB
		//! @return OςԂ܂
		static Mix::Quaternion Cross( const Mix::Quaternion& l, const Mix::Quaternion& r );

		//! @brief ̃NH[^jI̍߂܂
		//! @param[in] from NH[^jIA
		//! @param[in] to NH[^jIB
		//! @return Ԃ܂
		static Mix::Quaternion Difference( const Mix::Quaternion& from, const Mix::Quaternion& to );

		//! @brief ʐ`
		//! @param[in] qs ԂJnNH[^jI\ Mix::Quaternion NX
		//! @param[in] qd ԂINH[^jI\ Mix::Quaternion NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! return ԂꂽNH[^jI\ Mix::Quaternion NXԂ܂
		static Quaternion Slerp( const Mix::Quaternion& qs, const Mix::Quaternion& qd, Float32 t );

	public:
		//! @brief l( 0.0f, 0.0f, 0.0f, 1.0f )擾܂
		//! @return l\ Mix::Quaternion NXԂ܂
		static const Mix::Quaternion& Identity( void )
		{
			static const Mix::Quaternion identity( 0.0f, 0.0f, 0.0f, 1.0f );

			return identity;
		}
	};

}
