#pragma once

//! @file "Mix/Scene/IActorListener.h"
//! @brief AN^[XiC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IActorListener
	//! @brief AN^[Xi[C^[tF[X
	class IActorListener : public Mix::Reference
	{
	public:
		//! @struct RT_SPACE_EVENT_ARGS
		//! @brief [ggXtH[ : ԃCxgf[^\
		struct RT_SPACE_EVENT_ARGS
		{
			Mix::Quaternion pose; //!< OĂp\ Mix::Quaternion NX
		};

		//! @struct RT_APPLY_EVENT_ARGS
		//! @brief [ggXtH[ : KpCxgf[^\
		struct RT_APPLY_EVENT_ARGS
		{
			Mix::Quaternion angularVelocity;	//!< ]x\ Mix::Quaternion NX
			Mix::Vector3 linearVelocity;		//!< ړx\ Mix::Vector3 NX
		};

	public:
		//! @brief fXgN^
		virtual ~IActorListener( void ) {}

	public:
		//! @brief [ggXtH[̋Ԃ₢킹ۂɌĂяo܂
		//! @param[in] pOwner ̃nhĂяoAN^[f\ Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @param[in] args 񋟂ꂽf[^\ Mix::Scene::IActorListener::RT_SPACE_EVENT_ARGS \
		virtual void OnRTQuerySpace( Mix::Scene::IActorModel* pOwner, Mix::Scene::IActorListener::RT_SPACE_EVENT_ARGS& args ) = 0;

		//! @brief [ggXtH[KpOɌĂяo܂
		//! @param[in] pOwner ̃nhĂяoAN^[f\ Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @param[in] args 񋟂ꂽf[^\ Mix::Scene::IActorListener::RT_APPLY_EVENT_ARGS \
		virtual void OnRTPreApply( Mix::Scene::IActorModel* pOwner, Mix::Scene::IActorListener::RT_APPLY_EVENT_ARGS& args ) = 0;
	};

}}
