#pragma once

//! @file Mix/Scene/IAtmosphereScatter.h
//! @brief CXLb^[C^[tF[XCN[ht@C

#include "Mix/Scene/IRendererObject.h"

namespace Mix{ namespace Scene{

	//! @class IAtmosphereScatter
	//! @brief CXLb^[C^[tF[X
	class IAtmosphereScatter : public Mix::Scene::IRendererObject
	{
	public:
		//! @struct DAY_SETTINGS
		//! @brief ZbeBO\
		struct DAY_SETTINGS
		{
			Float32 sunIntensity;		//!< z̋x( 0.0f`̖ )
			Float32 sunTurbidity;		//!< z̏œx( 0.0f`4.0f )
			Float32 henyeyGreenstein;	//!< HenyeyGreensteinW( 0.0f`1.0f ) 
			Float32 rayleigh;			//!< RayleighW( 0.0f`̖ ) 
			Float32 mie;				//!< MieW( 0.0f`̖ )

			//! @brief LinW( 0.0f`̖ )
			//! @note
			//! zCʉ߂ĂʂӖ܂B<br>
			//! l傫قǖ邭AقǈÂȂ܂B 
			Float32 lin;

			//! @brief FexW( 0.0f`1.0f )
			//! @note
			//! z󂯂n\˂RGBӖ܂B<br>
			//! <br>
			//! fex.xyz : RGB̔˗<br>
			//! fex.w : RGB̔{( fex.xyz * fex.w )
			Mix::Vector4 fex;
		};

		//! @struct NIGHT_SETTINGS
		//! @brief ZbeBO\
		struct NIGHT_SETTINGS
		{
			Mix::Vector4 color;	//!< ̐F
			Float32 threshold;	//!< ւƕωn߂px( COSl )
			Float32 offset;		//!< ɕωI threshold ̃ItZbg( 0.0f ȏ )
		};

	protected:
		//! @brief fXgN^
		virtual ~IAtmosphereScatter( void ) {}

	public:
		//! @brief ̐ݒ擾܂
		//! @return ݒ\ Mix::Scene::IAtmosphereScatter::DAY_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::IAtmosphereScatter::DAY_SETTINGS& GetDaySettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::IAtmosphereScatter::DAY_SETTINGS \
		virtual void SetDaySettings( const Mix::Scene::IAtmosphereScatter::DAY_SETTINGS& settings ) = 0;

		//! @brief ̐ݒ擾܂
		//! @return ݒ\ Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS& GetNightSettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS \
		virtual void SetNightSettings( const Mix::Scene::IAtmosphereScatter::NIGHT_SETTINGS& settings ) = 0;

		//! @brief z̐F擾܂
		//! @return F\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetSunColor( void ) const = 0;
		//! @brief zɂƖ̐F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		//! @note
		//! ԂF͈ȉ̂悤ɂċ߂Ă܂B<br>
		//! <br>
		//! RGB=GetSunColor();<br>
		//! A=GetSunColor().GetLength();<br>
		virtual const Mix::Vector4& GetSunLightColor( void ) const = 0;
	};

}}
