#pragma once

//! @file Mix/Scene/IBillboardParticleSystem.h"
//! @brief r{[hp[eBNVXeC^[tF[XCN[ht@C

#include "Mix/Scene/ISimpleParticleSystem.h"

namespace Mix{ namespace Scene{

	//! @class IBillboardParticleSystem
	//! @brief r{[hp[eBNVXeC^[tF[X
	//! @note
	//! ɃJ̕p[eBN𐶐A܂B<br>
	//! ̂߃BeBO͍s( @AڐA]@͖ )Aݒ肳}eA͏ɃVF[hXłKv܂B
	class IBillboardParticleSystem : public Mix::Scene::ISimpleParticleSystem
	{
	protected:
		//! @brief fXgN^
		virtual ~IBillboardParticleSystem( void ) {}

	public:
		//! @brief ]̍ŏ͂擾܂
		//! @return ]̍ŏ͂Ԃ܂
		virtual Float32 GetMinAngularImpulse( void ) const = 0;
		//! @brief ]̍ő匂͂擾܂
		//! @return ]̍ő匂͂Ԃ܂
		virtual Float32 GetMaxAngularImpulse( void ) const = 0;
		//! @brief ]̌͂ݒ肵܂
		//! @param[in] minImpulse ŏ
		//! @param[in] maxImpulse ő匂
		//! @note ]̏ɉe܂
		virtual void SetAngularImpulse( Float32 minImpulse, Float32 maxImpulse ) = 0;

		//! @brief ]̍ŏx擾܂
		//! @return ŏx\ Mix::Vector3 NXԂ܂
		virtual Float32 GetMinAngularAcceleration( void ) const = 0;
		//! @brief ]̍őx擾܂
		//! @return őx\ Mix::Vector3 NXԂ܂
		virtual Float32 GetMaxAngularAcceleration( void ) const = 0;
		//! @brief ]̉xݒ肵܂
		//! @param[in] minAcc ŏx
		//! @param[in] maxAcc őx
		virtual void SetAngularAcceleration( Float32 minAcc, Float32 maxAcc ) = 0;
	};

}}
