#pragma once

//! @file Mix/Scene/ICamera.h
//! @brief JC^[tF[XCN[ht@C

#include "Mix/Scene/IRendererObject.h"
#include "Mix/Geometry/Frustum.h"

namespace Mix{ namespace Scene{

	//! @class ICamera
	//! @brief JC^[tF[XCN[ht@C
	class ICamera : public Mix::Scene::IRendererObject
	{
	public:
		//! @struct VISIBILITY_SETTINGS
		//! @brief Eݒ\
		struct VISIBILITY_SETTINGS
		{
			//! @brief [JCgɂ郉CeBǑE( 0.0f`̖ )
			Float32 loLimitDistance;
			//! @brief [JCgɂ郉CeBOEɒBÕtH[Itɗv鋗( 0.0f`̖ )
			Float32 loFalloffAmount;

			//! @brief v^[̕`E( 0.0f`̖ )
			Float32 plLimitDistance;
			//! @brief v^[̕`EɒBÕtH[Itɗv鋗( 0.0f`̖ )
			Float32 plFalloffAmount;
			//! @brief v^[̃tH[It̕~( 0.0f`1.0f )
			//! @note
			//! v^[̓tH[ItJn鋗( plLimitDistance - plFalloffDistance )𒴂ۂɁA<br>
			//! ( plLimitDistance - plFalloffDistance * plFalloffThreshold )~ƂAőQiKɕă|S炵Ă܂B
			Float32 plFalloffThreshold;

			//! @brief p[eBN̕`E( 0.0f`̖ )
			Float32 paLimitDistance;
			//! @brief p[eBN̕`EɒBÕtH[ItJn͈͂̑傫( 0.0f`paLimitDistance ) <b>݋@\܂</b>
			//! @note ͈ = ( paLimitDistance - paFalloffAmount ) ` paLimitDistance
			Float32 paFalloffAmount;
			//! @brief p[eBÑtH[Itɗv鎞( bP ) <b>݋@\܂</b>
			Float32 paFalloffDuration;

			//! @brief AN^[f̕`E( 0.0f`̖ )
			Float32 amLimitDistance;
			//! @brief AN^[f̕`EɒBÕtH[ItJn͈͂̑傫( 0.0f`amLimitDistance ) <b>݋@\܂</b>
			//! @note ͈ = ( amLimitDistance - amFalloffAmount ) ` amLimitDistance
			Float32 amFalloffAmount;
			//! @brief AN^[f̃tH[Itɗv鎞( bP ) <b>݋@\܂</b>
			Float32 amFalloffDuration;

			//! @brief e̕`E( 0.0f`̖ )
			Float32 sdwLimitDistance;
			//! @brief e̕`EɒBÕtH[Itɗv鋗( 0.0f`̖ )
			Float32 sdwFalloffAmount;
		};

		//! @struct AMBIENT_OCCLUSION_SETTINGS
		//! @brief ArGgIN[Wݒ\
		struct AMBIENT_OCCLUSION_SETTINGS
		{
			Float32 radius;			//!< Ւf͈͂̔a( 0.0f`̖ )
			Float32 threshold;		//!< ՒfĂƔf[x臒l( 0.0f`̖ )
			Float32 dist;			//!< ՒfĂƔf[x̋( 0.0f`̖ )
			Float32 intensity;		//!< x( 0.0f`̖ )
			Mix::Scene::BLUR blur;	//!< X[WɎgpu[
		};

		//! @enum SHADOW_MAPPING_PCF_SIZE
		//! @brief VhE}bsOobeTCY񋓒萔
		enum SHADOW_MAPPING_PCF_SIZE
		{
			SMPS_3 = 0,	//!< 3x3Tv
			SMPS_5 = 1,	//!< 5x5Tv
			SMPS_7 = 2,	//!< 7x7Tv
		};

		//! @struct SHADOW_MAPPING_SETTINGS
		//! @brief VhE}bsOݒ\
		struct SHADOW_MAPPING_SETTINGS
		{
			Float32 depthBias;			//!< [xoCAX
			Float32 depthSlopeScale;	//!< [xX΂̃XP[( 0.0f`1.0f )
			Float32 depthBiasClamp;		//!< [xoCAX̏( 0.0f`1.0f )

			Mix::Scene::ICamera::SHADOW_MAPPING_PCF_SIZE pcfSize; //!< X[WOsẻ({[_[)̑

			Mix::Scene::BLUR blur;		//!< X[WOɎgpu[
			Float32 tint;				//!< ZW( 0.0f`1.0f )
		};

		//! @enum LUMINOSITY_FLAG
		//! @brief ~mVeBtO񋓒萔
		enum LUMINOSITY_FLAG
		{
			//! @brief g[}bsO
			LUM_TONE_MAPPING			= 0x00000001,

			//! @brief u[Vtg
			//! @note
			//! ̃tOݒ肵ꍇAŜɐ݂ɂȂ܂B<br>
			//! Ȃǂ̎ԑтÈłɑ΂ėLȐݒłB
			LUM_BLUE_SHIFT			= 0x00000002,

			//! @brief X^eBbN~hOC
			//! @note ̃tOݒ肵ꍇ́AԂ̖邳( LUMINANCE_OPERATION_SETTINGS::middleGray ) ̒lݒ肷Kv܂B
			LUM_STATIC_MIDDLE_GRAY	= 0x00000004,
		};

		//! @struct LUMINOSITY_SETTINGS
		//! @brief ~mVeBݒ\
		struct LUMINOSITY_SETTINGS
		{
			UInt32 flags;	//!< Mix::Scene::ICamera::LUMINOSITY_FLAG 񋓒萔̑gݍ킹

			Float32 minLum;	//!< łŒPx( maxLum >= ( 0.0f <= minLum <= 2.0f ) )
			Float32 maxLum;	//!< łőPx( minLum <= ( minLum <= maxLum <= 2.0f ) )

			//! @brief ̑( 0.0f`1.0f )
			//! @note ̒lقǁAɗv鎞ԂZȂAÏɗv鎞ԂȂ܂B
			Float32 rods;
			//! @brief ̑( 0.0f`1.0f )
			//! @note ̒lقǁAɗv鎞ԂZȂ܂B
			Float32 cones;

			//! @brief Ԃ̖邳( 0.0f`̖ )
			//! @note flags  LUM_OP_STATIC_MIDDLE_GRAY ݒ肳Ăꍇɒlݒ肷Kv܂B
			Float32 middleGray;
			//! @brief \閾邳( 0.0f`̖ )
			Float32 white;
		};

		//! @struct BLOOM_OVERFLOW
		//! @brief u[I[o[tE\
		struct BLOOM_OVERFLOW
		{
			Mix::Scene::BLUR blur;					//!< u[
			Float32 intensity;						//!< x( 0.0f`̖ )
		};

		//! @struct BLOOM_SETTINGS
		//! @brief u[ݒ\
		struct BLOOM_SETTINGS
		{
			Mix::Scene::BRIGHT_PASS brightPass;		//!< uCgpX
			Mix::Graphics::BLEND_TYPE blendType;	//!< uh^Cv
			Float32 intensity;						//!< x( 0.0f`̖ )
		};

		//! @enum LIGHT_SHAFTS_SAMPLES
		//! @brief CgVtgTv񋓒萔
		enum LIGHT_SHAFTS_SAMPLES
		{
			LS_32,	//!< 32Tv
			LS_64,	//!< 64Tv
			LS_128,	//!< 128Tv
		};

		//! @struct LIGHT_SHAFTS_SETTINGS
		//! @brief CgVtgݒ\
		struct LIGHT_SHAFTS_SETTINGS
		{
			Mix::Scene::BRIGHT_PASS brightPass;	//!< uCgpX

			Float32 whiteness; //!< ( 0.0f`1.0f )

			//! @brief TvO
			//! @note ̒lύXꍇ́AZx( density )𒲐Kv܂B
			Mix::Scene::ICamera::LIGHT_SHAFTS_SAMPLES samples;

			//! @brief Zx( 0.0f`1.0f )
			//! @note TvOۂ̃XebvʂɈˑ܂
			Float32 density;
			Float32 decay;		//!< ( 0.0f`1.0f )
			Float32 exposure;	//!< I( 0.0f`̖ )

			Float32 start;		//!< tF[hCJn鋗( 0.0f`̖ )
			Float32 end;		//!< tF[hCI鋗( start`̖ )
		};

		//! @struct LENS_FLARE_SETTINGS
		//! @brief YtAݒ\
		struct LENS_FLARE_SETTINGS
		{
			Mix::Scene::BRIGHT_PASS brightPass;	//!< uCgpX

			UInt32 ghostNum;		//!< c̐( 1`32 )
			Float32 ghostWeight;	//!< c̃EFCg( 1.0f`̖ )
			Float32 ghostDispersal;	//!< ĉ΂( 0.0f ` 1.0f )

			Float32 haloWeight;	//!< ւ̃EFCg( 1.0f`̖ )
			Float32 haloWidth;	//!< ւ͑傫( 0.0f ` 1.0f )

			Float32 distortion;	//!< F̋( 0.0f`̖ )

			Float32 brustSharpness;	//!< ː̑N( 1.0f`̖ )
			Float32 brustIntensity;	//!< ː̋( 0.0f`̖ )

			Float32 dirtSharpness;	//!< ̑N( 1.0f`̖ )
			Float32 dirtIntensity;	//!< ̋( 0.0f`̖ )

			Mix::Scene::BLUR blur;	//!< u[

			Float32 intensity;	//!< x( 0.0f`̖ )
		};

		//! @enum LENS_FLARE_TEXTURE_TYPE
		//! @brief YtA : eNX`񋓒萔
		enum LENS_FLARE_TEXTURE_TYPE
		{
			LFT_COLOR	= 0,	//!< J[eNX`( c̐F )
			LFT_BRUST	= 1,	//!< uXgeNX`( ւ̕ )
			LFT_DIRT	= 2,	//!< _[geNX`( Ỷ )
		};

		//! @enum FILMIC_TYPE
		//! @brief tB~bN^Cv񋓒萔
		enum FILMIC_TYPE
		{
			FI_NONE		= 0,	//!< 
			FI_HEJL		= 1,	//!< Jim Hejl
			FI_HABLE	= 2,	//!< John Hable
		};

		//! @struct FILMIC_HABLE_SETTINGS
		//! @brief tB~bN HABLE p[^\
		struct FILMIC_HABLE_SETTINGS
		{
			Float32 exposureBias;
			Float32 shoulderStrength;
			Float32 linearStrength;
			Float32 linearAngle;
			Float32 toeStrength;
			Float32 toeNumerator;
			Float32 toeDenominator;
			Float32 linearWhitePointValue;
		};

		//! @enum MOTION_BLUR_QUALITY
		//! @brief [Vu[i񋓒萔
		enum MOTION_BLUR_QUALITY
		{
			MBQ_LOW		= 0,	//!< Œi( 8Tv )
			MBQ_MIDDLE	= 1,	//!< ʏi( 16Tv )
			MBQ_HIGH	= 2,	//!< ōi( 24Tv )
		};

		//! @struct MOTION_BLUR_SETTINGS
		//! @brief [Vu[ݒ\
		struct MOTION_BLUR_SETTINGS
		{
			Float32 minAngularVelocity;	//!< ԂɂȂŏ]x( 0.0f( 0x )`1.0f( 180x ) )
			Float32 maxAngularVelocity;	//!< ԂɂȂő]x( minAngularVelocity`1.0f( 180x ) )
			Float32 minLinearVelocity;	//!< ԂɂȂŏړx( 0.0f`̖ )
			Float32 maxLinearVelocity;	//!< ԂɂȂőړx( minLinearVelocity`̖ )

			UInt32 amount;	//!< Ԃێt[( 1`4 )
			Float32 echoTimeLength;	//!< 񊈓ԂɈڍsۂ̎c̃tF[hAEg( bP )

			Mix::Scene::ICamera::MOTION_BLUR_QUALITY quality;	//!< i

			Float32 dist;		//!< c`悷[x̉ւ̋e͈( 0.0f`̖ )
			Float32 damping;	//!< u[̌l( 0.0f`1.0f )
			Float32 scale;		//!< u[̃XP[( 0.0f`1.0f )
			Float32 intensity;	//!< u[̋( 0.0f`̖ )
		};

		//! @struct DISTORTION_SETTINGS
		//! @brief cȃp[^\
		struct DISTORTION_SETTINGS
		{
			Float32 k;		//!< l( -1.0f ` +1.0f )
			Float32 kCube;	//!< Ԓl( -1.0f ` +1.0f )
			Float32 scale;	//!< XP[( 0.0f ȏ )
		};

		//! @struct CHROMATISM_SETTINGS
		//! @brief Fݒ\
		struct CHROMATISM_SETTINGS
		{
			DISTORTION_SETTINGS distortion;	//!< cȃp[^
			Mix::Vector4 colorFactor;		//!< Ft@N^

			Mix::Scene::BLUR blur;			//!< u[

			//! @brief EFCg( 1.0f ȏ )
			//! @note ̒lقǁAʂOɂȂ܂B
			Float32 weight;
			Float32 fiStartZ;				//!< ʂJn鋗
			Float32 fiEndZ;					//!< ʂőɂȂ鋗
		};

		//! @struct DOF_SETTINGS
		//! @brief ʊE[xݒ\
		struct DOF_SETTINGS
		{
			Float32 nearZ;				//!< ʔ͈͂\Öʒu( 0.0f < nearZ )
			Float32 nearDist;			//!< ʂőɂȂԂւ̋( nearZ >= nearDist )

			Float32 farZ;				//!< ʔ͈͂\̈ʒu( nearZ < farZ )
			Float32 farDist;			//!< ʂőɂȂ鉜ւ̋( 0.0f <= farDist )

			Mix::Scene::BLUR blur1;		//!< u[1
			Mix::Scene::BLUR blur2;		//!< u[2
			Float32 blurThreshold;		//!< u[12()臒l( 0.0f`1.0f )
		};

		//! @struct VIGNETTE_SETTINGS
		//! @brief Blbgݒ\
		struct VIGNETTE_SETTINGS
		{
			Float32 start;		//!< Jnʒu( 0.0f`1.0f )
			Float32 end;		//!< Iʒu( start`1.0f )
			Mix::Vector4 color;	//!< F
		};

		//! @enum ANTIALIASING_TYPE
		//! @brief A`GCAVO^Cv񋓒萔
		enum ANTIALIASING_TYPE
		{
			AA_NONE	= 0,	//!< 
			AA_FXAA	= 1,	//!< FXAA
		};

		//! @struct DEBUG_DRAW_FILIMIC_SETTINGS
		//! @brief fobO : tB~bN`ݒ\
		struct DEBUG_DRAW_FILIMIC_SETTINGS
		{
			Mix::Rectangle rect;	//!< Ot`悷`
			Int32 padding;			//!< Ot̃pfBO

			Float32 valueMax;		//!< ől
			Float32 valueStep;		//!< l̃Xebv

			Int32 memNum;			//!< ̐

			Float32 errValue;		//!< G[l
		};

	protected:
		//! @brief fXgN^
		virtual ~ICamera( void ){}

	public:
		//! @name {
		//! @{

		//! @brief ʎq擾܂
		//! @return ʎqԂ܂
		//! @note
		//! ʎq 0`16 ͈̔͂ɂȂ܂B<br>
		//! ܂AɔjĂꍇ̒l 0xFFFFFFFF ɂȂ܂B
		virtual UInt32 GetID( void ) const = 0;

		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::CAMERA_CONFIG \̂Ԃ܂
		virtual const Mix::Scene::CAMERA_CONFIG& GetConfig( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] config ݒ\ const Mix::Scene::CAMERA_CONFIG \
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetConfig( const Mix::Scene::CAMERA_CONFIG& config ) = 0;

		//! @brief ̉p擾܂
		//! @return ̉p( WAP )
		virtual Float32 GetFovY( void ) const = 0;
		//! @brief ftHg̃AXyNg擾܂
		//! @return AXyNg
		virtual Float32 GetDefaultAspect( void ) const = 0;
		//! @brief AXyNg擾܂
		//! @return AXyNg
		virtual Float32 GetAspect( void ) const = 0;
		//! @brief ÕNbvl擾܂
		//! @return ÕNbvl
		virtual Float32 GetNearZ( void ) const = 0;
		//! @brief ̃Nbvl擾܂
		//! @return ̃Nbvl
		virtual Float32 GetFarZ( void ) const = 0;
		//! @brief ˉes擾܂
		//! @return ˉes\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetProjectionMatrix( void ) const = 0;
		//! @brief vWFNVݒ肵܂
		//! @param[in] fovY ̐̉p( WAP )
		//! @param[in] nearZ Ԃ̃Nbvl
		//! @param[in] farZ ̃Nbvl
		virtual void SetProjection( Float32 fovY, Float32 nearZ, Float32 farZ ) = 0;
		//! @brief vWFNVݒ肵܂
		//! @param[in] fovY ̐̉p( WAP )
		//! @param[in] aspect AXyNg
		//! @param[in] nearZ Ԃ̃Nbvl
		//! @param[in] farZ ̃Nbvl
		virtual void SetProjection( Float32 fovY, Float32 aspect, Float32 nearZ, Float32 farZ ) = 0;
		//! @brief ˉesݒ肵܂
		//! @param[in] fovY ̐̉p( WAP )
		//! @param[in] width ʂ̕
		//! @param[in] height ʂ̍
		//! @param[in] nearZ Ԃ̃Nbvl
		//! @param[in] farZ ̃Nbvl
		virtual void SetProjection( Float32 fovY, UInt32 width, UInt32 height, Float32 nearZ, Float32 farZ ) = 0;

		//! @brief XV܂
		//! @param[in] dt f^^C
		//! @note [Vu[gpȂꍇ́Af^^Cw肷Kv͂܂B
		virtual void Update( Float32 dt = 0.016f ) = 0;

		//! @brief _擾܂
		//! @return _̍W\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetEye( void ) const = 0;
		//! @brief _擾܂
		//! @return _̍W\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAt( void ) const = 0;
		//! @brief r[̃xNg(KĂȂ)擾܂
		//! @return r[̃xNg\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetViewVector( void ) const = 0;
		//! @brief r[̑O(KĂ)擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetViewForward( void ) const = 0;
		//! @brief r[̏(KĂ)擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetViewUpward( void ) const = 0;
		//! @brief r[̉(KĂ)擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetViewCrossDirection( void ) const = 0;
		//! @brief r[s擾܂
		//! @return r[s\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetViewMatrix( void ) const = 0;

		//! @brief tX^擾܂
		//! @return tX^\ Mix::Geometry::Frustum NX
		virtual const Mix::Geometry::Frustum& GetFrustum( void ) const = 0;

		//! @brief ϊs擾܂
		//! @return ϊs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetViewProjectionMatrix( void ) const = 0;
		//! @brief tϊs擾܂
		//! @return tϊs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetInvViewProjectionMatrix( void ) const = 0;

		//! @brief r{[hs擾܂
		//! @return r{[hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetBillboardMatrix( void ) const = 0;
		//! @brief YŒ̃r{[hs擾܂
		//! @return YŒ̃r{[hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetBillboardMatrixY( void ) const = 0;

		//! @brief [hWXN[W֕ϊ܂
		//! @param[in] pos [hW\ Mix::Vector3 NX
		//! @return XN[W\ Mix::Point NXԂ܂
		virtual Mix::Point Project( const Mix::Vector3& pos ) const = 0;
		//! @brief [hWXN[W֕ϊ܂
		//! @param[in] viewPos r[|[g̍̍W\ Mix::Point NX
		//! @param[in] pos [hW\ Mix::Vector3 NX
		//! @return XN[W\ Mix::Point NXԂ܂
		virtual Mix::Point Project( const Mix::Point& viewPos, const Mix::Vector3& pos ) const = 0;
		//! @brief [hWXN[W֕ϊ܂
		//! @param[in] viewRect r[|[g̋`\ Mix::Rectangle NX
		//! @param[in] pos [hW\ Mix::Vector3 NX
		//! @return XN[W\ Mix::Point NXԂ܂
		virtual Mix::Point Project( const Mix::Rectangle& viewRect, const Mix::Vector3& pos ) const = 0;

		//! @brief XN[W[hW֕ϊ܂
		//! @param[in] pos XN[̍W\ Mix::Point NX
		//! @param[in] z [x( 0.0f`1.0f );
		//! @return [hW\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 Unproject( const Mix::Point& pos, Float32 z ) const = 0;
		//! @brief XN[W[hW֕ϊ܂
		//! @param[in] viewPos r[|[g̍̍W\ Mix::Point NX
		//! @param[in] pos XN[̍W\ Mix::Point NX
		//! @param[in] z [x( 0.0f`1.0f );
		//! @return [hW\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 Unproject( const Mix::Point& viewPos, const Mix::Point& pos, Float32 z ) const = 0;
		//! @brief XN[W[hW֕ϊ܂
		//! @param[in] viewRect r[|[g̋`\ Mix::Rectangle NX
		//! @param[in] pos XN[̍W\ Mix::Point NX
		//! @param[in] z [x( 0.0f`1.0f );
		//! @return [hW\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 Unproject( const Mix::Rectangle& viewRect, const Mix::Point& pos, Float32 z ) const = 0;

		//! @brief V[̃IuWFNghbO܂
		//! @param[in] pos XN[̈ʒu\ Mix::Point NX
		//! @return hbOɐꍇ True Ԃ܂
		//! @note ݃hbOł̂̓RC_[(Wbh{fBftHg)Ă̂Ɍ肳܂
		virtual Boolean DragObject( const Mix::Point& pos ) = 0;
		//! @brief V[̃IuWFNghbO܂
		//! @param[in] screenPos XN[̍̈ʒu\ Mix::Point NX
		//! @param[in] pos XN[̈ʒu\ Mix::Point NX
		//! @return hbOɐꍇ True Ԃ܂
		//! @note ݃hbOł̂̓RC_[(Wbh{fBftHg)Ă̂Ɍ肳܂
		virtual Boolean DragObject( const Mix::Point& screenPos, const Mix::Point& pos ) = 0;
		//! @brief V[̃IuWFNghbO܂
		//! @param[in] screenRect XN[̋`\ Mix::Rectangle NX
		//! @param[in] pos XN[̈ʒu\ Mix::Point NX
		//! @return hbOɐꍇ True Ԃ܂
		//! @note ݃hbOł̂̓RC_[(Wbh{fBftHg)Ă̂Ɍ肳܂
		virtual Boolean DragObject( const Mix::Rectangle& screenRect, const Mix::Point& pos ) = 0;

		//! @brief obNOEhJ[擾܂
		//! @return J[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetBackgroundColor( void ) const = 0;
		//! @brief obNOEhJ[ݒ肵܂
		//! @param[in] color J[\ Mix::Vector4 NX
		virtual void SetBackgroundColor( const Mix::Vector4& color ) = 0;

		//! @brief tB^[̃^Cv擾܂
		//! @return ^Cv\ Mix::Graphics::TEXTURE_FILTER_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::TEXTURE_FILTER_TYPE GetFilterType( void ) const = 0;
		//! @brief tB^[̃^Cvݒ肵܂
		//! @param[in] type ^Cv\ Mix::Graphics::TEXTURE_FILTER_TYPE 񋓒萔
		virtual void SetFilterType( Mix::Graphics::TEXTURE_FILTER_TYPE type ) = 0;

		//! @brief `悵܂
		//! @return ꍇ True Ԃ܂
		virtual Boolean Draw( void ) = 0;

		//! @brief ɂ邩ǂmF܂
		//! @return ɂꍇ True Ԃ܂
		//! @note ɂ邩ǂ̔ Draw ōs܂B
		virtual Boolean IsUnderWater( void ) const = 0;

		//! @}

		//! @name E
		//! @{

		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::VISIBILITY_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::VISIBILITY_SETTINGS& GetVisiblitySettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::VISIBILITY_SETTINGS \
		virtual void SetVisiblitySettings( const Mix::Scene::ICamera::VISIBILITY_SETTINGS& settings ) = 0;

		//! @}

		//! @name ArGgIN[W
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsAmbientOcclusionEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetAmbientOcclusionEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& GetAmbientOcclusionSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS \
		virtual void SetAmbientOcclusionSettings( const Mix::Scene::ICamera::AMBIENT_OCCLUSION_SETTINGS& settings ) = 0;
		//! @brief eNX`擾܂B
		//! @param[out] ppTex 擾eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂B
		virtual Boolean GetAmbientOcclusionTexture( Mix::Graphics::ITexture** ppTex ) = 0;
		//! @brief eNX`ݒ肵܂B
		//! @param[in] pTex ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @note
		//! Őݒ肳eNX`́AՒf𔻒肷ۂ̌𗐔 ( reflect ) 邽߂Ɏgp܂B<br>
		//! RGB ɖ@܂ꂽAoveNX`pӂĂB
		virtual void SetAmbientOcclusionTexture( Mix::Graphics::ITexture* pTex ) = 0;

		//! @}

		//! @name VhE}bsO
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsShadowMappingEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetShadowMappingEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& GetShadowMappingSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS \
		virtual void SetShadowMappingSettings( const Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS& settings ) = 0;

		//! @}

		//! @name ~mVeB
		//! @{

		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::LUMINOSITY_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& GetLuminositySettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::LUMINOSITY_ADAPTATION_SETTINGS \
		virtual void SetLuminositySettings( const Mix::Scene::ICamera::LUMINOSITY_SETTINGS& settings ) = 0;
		//! @brief Px̃TXyhJEgP炵܂
		//! @return ̃\bhĂяoÕTXyhJEgԂ܂
		virtual UInt32 ResumeLuminosityAdaptation( void ) = 0;
		//! @brief Px̃TXyhJEgP₵܂
		//! @return ̃\bhĂяoÕTXyhJEgԂ܂
		virtual UInt32 SusupendLuminosityAdaptation( void ) = 0;
		//! @brief Px̃TXyhJEg擾܂
		//! @return TXyhJEgԂ܂
		virtual UInt32 GetLuminosityAdaptationSuspendCount( void ) const = 0;
		//! @brief IɌ݂̋Pxɏ܂
		virtual void ForceLuminosityAdaptation( void ) = 0;
		//! @brief w肵Pxɏ܂
		//! @param[in] lum Px( 0.0f`1.0f )
		virtual void SetLuminosityAdaptation( Float32 lum ) = 0;

		//! @}

		//! @name u[
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsBloomEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetBloomEnabled( Boolean state ) = 0;
		//! @brief I[o[t[̐擾܂
		//! @return Ԃ܂
		virtual UInt32 GetBloomOverflowNum( void ) const = 0;
		//! @brief I[o[t[擾܂
		//! @param[in] index 擾I[o[t[̃CfbNX
		//! @return I[o[t[\ Mix::Scene::ICamera::BLOOM_OVERFLOW \
		virtual const Mix::Scene::ICamera::BLOOM_OVERFLOW& GetBloomOverflow( UInt32 index ) const = 0;
		//! @brief I[o[t[ݒ肵܂
		//! @param[in] index ݒ肷I[o[t[̃CfbNX
		//! @param[in] overflow I[o[t[\ Mix::Scene::ICamera::BLOOM_OVERFLOW \
		virtual void SetBloomOverflow( UInt32 index, const Mix::Scene::ICamera::BLOOM_OVERFLOW& overflow ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::BLOOM_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::BLOOM_SETTINGS& GetBloomSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::BLOOM_SETTINGS \
		virtual void SetBloomSettings( const Mix::Scene::ICamera::BLOOM_SETTINGS& settings ) = 0;

		//! @}

		//! @name CgVtg
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsLightShaftsEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetLightShaftsEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& GetLightShaftsSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS \
		virtual void SetLightShaftsSettings( const Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS& settings ) = 0;
		//! @brief eNX`擾܂B
		//! @param[out] ppTex 擾eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂B
		virtual Boolean GetLightShaftsTexture( Mix::Graphics::ITexture** ppTex ) = 0;
		//! @brief eNX`ݒ肵܂B
		//! @param[in] pTex ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @note
		//! Őݒ肳eNX`́ACgVtg(  )ɋ؂AsɌ邽߂Ɏgp܂B<br>
		//! RGB ɃmÑmCY܂ꂽeNX`pӂĂB<br>
		virtual void SetLightShaftsTexture( Mix::Graphics::ITexture* pTex ) = 0;

		//! @}

		//! @name YtA
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsLensFlareEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetLensFlareEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::LENS_FLARE_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& GetLensFlareSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::LENS_FLARE_SETTINGS \
		virtual void SetLensFlareSettings( const Mix::Scene::ICamera::LENS_FLARE_SETTINGS& settings ) = 0;
		//! @brief eNX`擾܂
		//! @param[in] type eNX`̃^Cv\ Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE 񋓒萔
		//! @param[in] ppTexture 擾eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief eNX`ݒ肵܂
		//! @param[in] type eNX`̃^Cv\ Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE 񋓒萔
		//! @param[in] pTexture ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^( NULL w\ )
		virtual void SetLensFlareTexture( Mix::Scene::ICamera::LENS_FLARE_TEXTURE_TYPE type, Mix::Graphics::ITexture* pTexture ) = 0;

		//! @}

		//! @name tB~bN
		//! @{

		//! @brief LǂmF܂B
		//! @return Lȏꍇ True Ԃ܂B
		virtual Boolean IsFilmicEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂B
		//! @param[in] state Lɂꍇ True
		virtual void SetFilmicEnabled( Boolean state ) = 0;
		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Scene::ICamera::FILMIC_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::ICamera::FILMIC_TYPE GetFilmicType( void ) const = 0;
		//! @brief p[^擾܂
		//! @param[in] pSettings ݒ̃Rs[̃|C^
		//! @param[in] size ݒ̃Rs[̃TCY
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetFilmicSettings( void* pSettings, UInt32 size ) const = 0;
		//! @brief ^Cvݒ肵܂
		//! @param[in] type ^Cv\ Mix::Scene::ICamera::FILMIC_TYPE 񋓒萔
		//! @param[in] pSettings ݒ̃|C^
		//! @param[in] size ݒ̃TCY( oCgP )
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ^Cv FI_HABLE ̏ꍇ́Ap[^ݒ肷邱Ƃł܂B<br>
		//! p[^̐ݒɎgp\̂ Mix::Scene::ICamera::FILMIC_HABLE_SETTINGS ɂȂ܂B<br>
		//! ܂ pSettings = NULLAparamSize = 0 ̏ꍇ́AftHglݒ肳܂B<br>
		//! <br>
		//! exposureBias = 2.0f<br>
		//! shoulderStrength = 0.22f<br>
		//! linearStrength = 0.3f<br>
		//! linearAngle = 0.1f<br>
		//! toeStrength = 0.2f<br>
		//! toeNumerator = 0.01f<br>
		//! toeDenominator = 0.3f<br>
		//! linearWhitePointValue = 11.2f<br>
		virtual Boolean SetFilmicType( Mix::Scene::ICamera::FILMIC_TYPE type, const void* pSettings = NULL, UInt32 size = 0 ) = 0;

		//! @}

		//! @name K}
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsGammaEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetGammaEnabled( Boolean state ) = 0;
		//! @brief l擾܂
		//! @return l\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetGammaValue( void ) const = 0;
		//! @brief lݒ肵܂
		//! @param[in] value l( 0.0fȏ )\ Mix::Vector3 NX
		virtual void SetGammaValue( const Mix::Vector3& value ) = 0;
		//! @brief lݒ肵܂
		//! @param[in] value l( 0.0fȏ )
		virtual void SetGammaValue( Float32 value ) = 0;

		//! @}

		//! @name [Vu[
		//! @{

		//! @brief LǂmF܂
		//! @return FDȏꍇ True Ԃ܂
		virtual Boolean IsMotionBlurEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetMotionBlurEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::MOTION_BLUR_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::MOTION_BLUR_SETTINGS& GetMotionBlurSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::MOTION_BLUR_SETTINGS \
		virtual void SetMotionBlurSettings( const Mix::Scene::ICamera::MOTION_BLUR_SETTINGS& settings ) = 0;
		//! @brief ԂǂmF܂
		//! @return Ԃ̏ꍇ True Ԃ܂
		//! @note ԂƂ̓[Vu[̏sĂԂ̂Ƃ\܂B
		virtual Boolean IsMotionBlurActivated( void ) const = 0;
		//! @brief ݕێĂԂ̐擾܂
		//! @return ێĂԂ̐Ԃ܂
		virtual UInt32 GetMotionBlurCurrentAmount( void ) const = 0;

		//! @}

		//! @name F
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsChromatismEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetChromatismEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::CHROMATISM_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::CHROMATISM_SETTINGS& GetChromatismSettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::CHROMATISM_SETTINGS \
		virtual void SetChromatismSettings( const Mix::Scene::ICamera::CHROMATISM_SETTINGS& settings ) = 0;

		//! @}

		//! @name ʊE[x
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsDofEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetDofEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::DOF_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::DOF_SETTINGS& GetDofSettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::DOF_SETTINGS \
		virtual void SetDofSettings( const Mix::Scene::ICamera::DOF_SETTINGS& settings ) = 0;

		//! @}

		//! @name cȎ
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsLensDistortionEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetLensDistortionEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::DISTORTION_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::DISTORTION_SETTINGS& GetLendDistortionSettings( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::DISTORTION_SETTINGS \
		virtual void SetLendDistortionSettings( const Mix::Scene::ICamera::DISTORTION_SETTINGS& settings ) = 0;

		//! @}

		//! @name Blbg
		//! @{

		//! @brief LǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsVignetteEnabled( void ) const = 0;
		//! @brief Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetVignetteEnabled( Boolean state ) = 0;
		//! @brief ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::VIGNETTE_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::VIGNETTE_SETTINGS& GetVignetteSettings( void ) const = 0;
		//! @brief ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::VIGNETTE_SETTINGS \
		virtual void SetVignetteSettings( const Mix::Scene::ICamera::VIGNETTE_SETTINGS& settings ) = 0;

		//! @}

		//! @name A`GCAVO
		//! @{

		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Scene::ICamera::ANTIALIASING_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::ICamera::ANTIALIASING_TYPE GetAntiAliasingType( void ) const = 0;
		//! @brief ^Cvݒ肵܂
		//! @param[in] type ^Cv\ Mix::Scene::ICamera::ANTIALIASING_TYPE 񋓒萔
		virtual void SetAntiAliasingType( Mix::Scene::ICamera::ANTIALIASING_TYPE type ) = 0;

		//! @}

		//! @name fobO
		//! @{

		//! @brief tB^Cvݒ肵܂
		//! @param[in] type tB^Cv\ Mix::Graphics::FILL_TYPE 񋓒萔
		virtual void Debug_SetFillType( Mix::Graphics::FILL_TYPE type ) = 0;
		//! @brief tB^Cv擾܂
		//! @return tB^Cv\ Mix::Graphics::FILL_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::FILL_TYPE Debug_GetFillType( void ) const = 0;

		//! @brief `惁\bhݒ肵܂
		//! @param[in] method `惁\bh\ Mix::Scene:::DEBUG_DRAW_METHOD 񋓒萔
		virtual void Debug_SetDrawMethod( Mix::Scene::DEBUG_DRAW_METHOD method ) = 0;
		//! @brief `惁\bh擾܂
		//! @return `惁\bh\ Mix::Scene::DEBUG_DRAW_METHOD 񋓒萔Ԃ܂
		virtual Mix::Scene::DEBUG_DRAW_METHOD Debug_GetDrawMethod( void ) const = 0;

		//! @brief `tOݒ肵܂
		//! @param[in] flags `tO\ Mix::Scene::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹
		virtual void Debug_SetDrawFlags( UInt32 flags ) = 0;
		//! @brief `tO擾܂
		//! @return `tO\ Mix::Scene::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹Ԃ܂
		virtual UInt32 Debug_GetDrawFlags( void ) const = 0;

		//! @brief tB~bN̕`ݒ擾܂
		//! @return ݒ\ Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& Debug_GetDrawFilmicSettings( void ) const = 0;
		//! @brief tB~bN̕`ݒ܂
		//! @param[in] settings ݒ\ Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS \
		virtual void Debug_SetDrawFilmicSettings( const Mix::Scene::ICamera::DEBUG_DRAW_FILIMIC_SETTINGS& settings ) = 0;

		//! @brief vt@C擾܂
		//! @param[in] type ^Cv\ Mix::Scene::DEBUG_PROFILE_TYPE 񋓒萔
		//! @param[out] pProf vt@C̃Rs[̃|C^
		//! @param[in] size vt@C̃Rs[̃TCY
		//! @return Rs[TCYԂ܂
		//! @note
		//! vt@C̃^CvƃRs[ɂȂ\̂̑gݍ킹͈ȉ̂悤ɂȂ܂B<br>
		//! <table>
		//!   <tr>
		//!     <th>^Cv</th>
		//!     <th>\</th>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_GENERAL</td>
		//!     <td>DEBUG_PROFILE_CAMERA_GENERAL</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_OCTREE</td>
		//!     <td>DEBUG_PROFILE_CAMERA_OCTREE</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_LIGHT</td>
		//!     <td>DEBUG_PROFILE_CAMERA_LIGHT</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_WATER_POOL</td>
		//!     <td>DEBUG_PROFILE_CAMERA_WATER_POOL</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_WIDGET</td>
		//!     <td>DEBUG_PROFILE_CAMERA_WIDGET</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_ACTOR_MODEL</td>
		//!     <td>DEBUG_PROFILE_CAMERA_MODEL</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_TERRAIN_MODEL</td>
		//!     <td>DEBUG_PROFILE_CAMERA_MODEL</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_PROJ_SHADOW</td>
		//!     <td>DEBUG_PROFILE_CAMERA_PROJ_SHADOW</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_DRAW_OPACITY</td>
		//!     <td>DEBUG_PROFILE_CAMERA_DRAW_OPACITY</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_DRAW_NEUTRALITY</td>
		//!     <td>DEBUG_PROFILE_CAMERA_DRAW_NEUTRALITY</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_DRAW_REFRACT</td>
		//!     <td>DEBUG_PROFILE_CAMERA_DRAW_REFRACT</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_DRAW_TRANSPARENCY</td>
		//!     <td>DEBUG_PROFILE_CAMERA_DRAW_TRANSPARENCY</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_POST_PROCESS</td>
		//!     <td>DEBUG_PROFILE_CAMERA_POST_PROCESS</td>
		//!   </tr>
		//! </table>
		virtual UInt32 Debug_GetProfile( UInt32 type, void* pProf, UInt32 size ) const = 0;

		//! @brief C[W̐擾܂
		//! @param[in] type ^Cv\ Mix::Scene::DEBUG_IMAGE_TYPE 񋓒萔
		//! @return Ԃ܂
		virtual UInt32 Debug_GetImageNum( UInt32 type ) const = 0;
		//! @brief C[W擾܂
		//! @param[in] type ^Cv\ Mix::Scene::DEBUG_IMAGE_TYPE 񋓒萔
		//! @param[in] index CfbNX( 0`Debug_GetImageNum( type ) - 1 )
		//! @param[out] ppTexture 擾C[Wn Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean Debug_GetImage( UInt32 type, UInt32 index, Mix::Graphics::ITexture** ppTexture ) = 0;

		//! @}
	};

}}
