#pragma once

//! @file Mix/Scene/IHemisphereLight.h
//! @brief CgC^[tF[XCN[ht@C

#include "Mix/Scene/ILight.h"

namespace Mix{ namespace Scene{

	//! @class IHemisphereLight
	//! @brief CgC^[tF[X
	class IHemisphereLight : public Mix::Scene::ILight
	{
	protected:
		//! @brief fXgN^
		virtual ~IHemisphereLight( void ) {}

	public:
		//! @brief ( ւ̕ )擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAxis( void ) const = 0;
		//! @brief ( ւ̕ )ݒ肵܂
		//! @param[in] axis \ Mix::Vector3 NX
		virtual void SetAxis( const Mix::Vector3& axis ) = 0;

		//! @brief nォ甭F擾܂
		//! @return nォ甭F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetGroundColor( void ) const = 0;
		//! @brief nォ甭Fݒ肵܂
		//! @param[in] color nォ甭F\ Mix::Vector4 NX
		virtual void SetGroundColor( const Mix::Vector4& color ) = 0;

		//! @brief 󂩂甭F擾܂
		//! @return 󂩂甭F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetSkyColor( void ) const = 0;
		//! @brief 󂩂甭Fݒ肵܂
		//! @param[in] color 󂩂甭F\ Mix::Vector4 NX
		virtual void SetSkyColor( const Mix::Vector4& color ) = 0;
	};

}}
