#pragma once

//! @file Mix/Scene/IMotion.h
//! @brief [VC^[tF[XCN|ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IMotion
	//! @brief [VC^[tF[X
	class IMotion : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IMotion( void ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief bԂ̃t[擾܂
		//! @return bԂ̃t[Ԃ܂
		virtual Float32 GetFramesPerSec( void ) const = 0;

		//! @brief Ō̃t[擾܂
		//! @return Ō̃t[Ԃ܂
		virtual Float32 GetLastFrame( void ) const = 0;

		//! @brief [v̊Jnt[擾܂
		//! @return Jnt[Ԃ܂
		virtual Float32 GetLoopStartFrame( void ) const = 0;
		//! @brief [v̏It[擾܂
		//! @return It[Ԃ܂
		virtual Float32 GetLoopEndFrame( void ) const = 0;

		//! @brief Xs[hݒ肵܂
		//! @param[in] speed Xs[h( 0.0f`̖ )
		virtual void SetSpeed( Float32 speed ) = 0;
		//! @brief Xs[h擾܂
		//! @return Xs[hԂ܂
		virtual Float32 GetSpeed( void ) const = 0;

		//! @brief uhݒ肵܂
		//! @param[in] ratio uh( 0.0f`1.0f )
		virtual void SetBlendRatio( Float32 ratio ) = 0;
		//! @brief uh擾܂
		//! @return uhԂ܂
		virtual Float32 GetBlendRatio( void ) const = 0;

		//! @brief Gg[ݒ肵܂
		//! @param[in] entries Gg[\ Mix::Scene::MOTION_ENTRY_DESC \̂̔z
		//! @param[in] count Gg[̐
		//! @note entries(NULL) count(0) Ƃꍇ́Aݒ肳ĂGg[j܂
		virtual void SetEntry( const Mix::Scene::MOTION_ENTRY_DESC* entries, UInt32 count ) = 0;
		//! @brief Gg[̃|C^擾܂
		//! @param[in] index 擾Gg[̃CfbNX
		//! @return Gg[\ Mix::Scene::MOTION_ENTRY_DESC \̂̃|C^Ԃ܂B<br>
		//! index ͈͂𒴂Ăꍇ NULL Ԃ܂B
		//! @note Gg[͎nɃ\[g邽߁ASetEntry Őݒ肵ƈقȂꍇ܂B
		virtual const Mix::Scene::MOTION_ENTRY_DESC* GetEntryPtr( UInt32 index ) const = 0;
		//! @brief ݒ肳ĂGg[̐擾܂
		//! @return Gg[̐Ԃ܂
		virtual UInt32 GetEntryCount( void ) const = 0;

		//! @brief g̃N[쐬܂
		//! @param[out] ppMotion g̃N[n Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @param[in] bDuplicateEntries Gg[𕡐ꍇ True
		//! @return ꍇ True Ԃ܂
		virtual Boolean Clone( Mix::Scene::IMotion** ppMotion, Boolean bDuplicateEntries = False ) = 0;
	};

}}
