#pragma once

//! @file Mix/Scene/IParticleProcessor.h
//! @brief p[eBNvZbT[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IParticleProcessor
	//! @brief p[eBNvZbT[C^[tF[X
	class IParticleProcessor : public Mix::Reference
	{
	public:
		//! @struct FACE
		//! @brief tFCX\
		//! @note
		//! @AڐA]@̓r{[hł͎gp܂B<br>
		//! ܂AftHg̏ꍇ̓}eAɂĒlݒ肷邩ǂ͕ω܂B<br>
		//! BeBOL( VF[hXł͂Ȃ )ȏꍇ́A@̒lݒ肵܂B<br>
		//! ovLȏꍇ́A̖@ɉAڐA]@̒lݒ肷Kv܂B
		struct FACE
		{
			Mix::Vector3 pos;				//!< ʒu
			Mix::Vector4 color;				//!< F
			Mix::Vector3 localPoints[4];	//!< `̂S_̈ʒũ[JW( E )
			Mix::Vector3 normal;			//!< @
			Mix::Vector3 tangent;			//!< ڐ
			Mix::Vector3 binormal;			//!< ]@
			Mix::Vector2 texCoords[4];		//!< `̂S_̃eNX`W( E )
		};

	protected:
		//! @brief fXgN^
		virtual ~IParticleProcessor( void ) {}

	public:
		//! @brief Ă鐔擾܂
		//! @return Ԃ܂
		virtual UInt32 Internal_GetCount( void ) const = 0;

		//! @brief NA܂
		//! @note Mix::IParticle::Terminate( True ) ŌĂяo܂B
		virtual void Internal_Clear( void ) = 0;
		//! @brief ǉ܂
		//! @param[in] pGenerator WFl[^[\ Mix::Scene::IParticleGenerator ̃|C^
		//! @param[in] genCount 鐔
		//! @return Ԃ܂
		virtual UInt32 Internal_Add( Mix::Scene::IParticleGenerator* pGenerator, UInt32 genCount ) = 0;
		//! @brief ǉ܂
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		//! @param[in] pGenerator WFl[^[\ Mix::Scene::IParticleGenerator ̃|C^
		//! @param[in] genCount 鐔
		//! @return Ԃ܂
		virtual UInt32 Internal_Add( const Mix::Matrix4x4& worldMat, Mix::Scene::IParticleGenerator* pGenerator, UInt32 genCount ) = 0;

		//! @brief XV܂
		//! @param[in] dt f^^C( bP )
		//! @return XVꍇ True Ԃ܂
		//! @note ̃\bhɂAGetFaceNum GetFaces ŕԂlXV܂B
		virtual Boolean Internal_Update( Float32 dt ) = 0;

		//! @brief g̕쐬܂
		//! @param[out] ppProcessor gn Mix::Scene::IParticleProcessor C^tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ̃\bh Mix::Scene::IParticle::Clone ̃tO Mix::Scene::IParticle::C_DUPLICATE_PROCESSOR w肳ĂꍇɌĂяo܂B<br>
		//! ܂̃\bhŃvZbT[Ƃ̓Ԃ𕡐ĂB
		virtual Boolean Internal_Duplicate( Mix::Scene::IParticleProcessor** ppProcessor, const wchar_t* pDebugName ) = 0;

		//! @brief tFCX̐擾܂
		//! @return tFCX̐Ԃ܂
		virtual UInt32 Internal_GetFaceNum( void ) const = 0;
		//! @brief tFCX̔z擾܂
		//! @return tFCX\ Mix::Scene::IParticleRenderer::FACE \̂̔zԂ܂B
		virtual const Mix::Scene::IParticleProcessor::FACE* Internal_GetFaces( void ) const = 0;

#ifdef _DEBUG
		//! @brief fobO`܂
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		//! @param[in] pPerspectiveRenderer `Ɏgpp[XyNeBu_[\ Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^
		virtual void Debug_Draw( const Mix::Matrix4x4& worldMat, Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer ) = 0;
#endif //_DEBUG
	};

}}
