#pragma once

//! @file Mix/Scene/ITerrainModel.h
//! @brief eCfC^[tF[XCN[ht@C

#include "Mix/Scene/IModel.h"

namespace Mix{ namespace Scene{

	//! @class ITerrainModel
	//! @brief eCfC^[tF[X
	class ITerrainModel : public Mix::Scene::IModel
	{
	public:
		//! @enum CLONE_FLAGS
		//! @brief N[tO񋓒萔
		enum CLONE_FLAGS
		{
			C_SHARED_MATERIAL			= 0x00000001,	//!< }eAL

			C_ALL						= ( C_SHARED_MATERIAL ),	//!< S
		};

	protected:
		//! @brief fXgN^
		virtual ~ITerrainModel( void ){}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief ʒuݒ肵܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @note
		//! ʒuݒ肵ꍇASẴm[hAABB(E{[)XVKv邽߁A<br>
		//! sKvɂ̃\bhĂяoƂ͂ȂłB
		virtual void SetWorldPosition( const Mix::Vector3& pos ) = 0;
		//! @brief ʒu擾܂
		//! @return ʒu\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetWorldPosition( void ) const = 0;

		//! @brief RC_[݂邩ǂmF܂
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ExistsCollider( void ) const = 0;
		//! @brief RC_[擾܂
		//! @param[out] ppCollider 擾RC_[n Mix::Scene::ITerrainCollider C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾ɐꍇ́ARC_[̎QƃJE^ +1 ܂
		virtual Boolean GetCollider( Mix::Scene::ITerrainCollider** ppCollider ) = 0;

		//! @brief g̃N[쐬܂
		//! @param[out] ppMapModel g̃N[n Mix::Scene::IMapModel C^[tF[X̃|C^̃AhX
		//! @param[in] flags N[̃tO\ Mix::Scene::IActorModel::CLONE_FLAGS 񋓒萔̑gݍ킹
		//! @return ꍇ True Ԃ܂
		virtual Boolean Clone( Mix::Scene::ITerrainModel** ppMapModel, UInt32 flags = Mix::Scene::ITerrainModel::C_ALL ) = 0;
	};

}}
