#pragma once

//! @file Mix/Sound/IManager.h
//! @brief TEh}l[W[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Sound{

	//! @class IManager
	//! @brief TEh}l[W[C^[tF[X
	//! @note
	//! <ul>
	//! <li>Vv</li><br>
	//! fR[hꂽ̃TEht@CĐ܂B<br>
	//! ʉȂǂ̒ZԂ̂̂Đ̂ɓKĂ܂B<br>
	//! ܂ARg[[AG~b^[ƂɃN[쐬邱Ƃł܂B<br>
	//! <li>Xg[~O</li><br>
	//! TEht@CfR[hȂAĐ܂B<br>
	//! ȂȂǂ̒Ԃ̂̂Đ̂ɓKĂ܂B<br>
	//! ܂AXg[~Oɂ̓TEht@C𒼐ڃfR[h@ƁÃTEht@C( kĂ )fR[hA̕@A
	//! ҂̓Rg[[AG~b^[ƂɃN[쐬邱Ƃł܂B<br>
	//!  O҂̓N[쐬邱Ƃ͂ł܂
	//! </ul>
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @name 2D TEh
		//! @{

		//! @brief VvRg[[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppController 쐬VvRg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateSimpleController( const wchar_t* pFilePath, Mix::Sound::IController** ppController ) = 0;
		//! @brief VvRg[[쐬܂
		//! @param[in] pReader Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppController 쐬VvRg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VvRg[[̍쐬ɐꍇApReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateSimpleController( Mix::IO::IReader* pReader, Mix::Sound::IController** ppController ) = 0;

		//! @brief Xg[~ORg[[쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[in] bBuffered t@CɊi[čĐꍇ True
		//! @param[out] ppController 쐬Xg[~ORg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateStreamingController( const wchar_t* pFilePath, Boolean bBuffered, Mix::Sound::IController** ppController ) = 0;
		//! @brief Xg[~ORg[[쐬܂
		//! @param[in] pReader Mix::IO::IReader C^[tF[X̃|C^
		//! @param[out] ppController Xg[~ORg[[n Mix::Sound::IController C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[~ORg[[̍쐬ɐꍇApReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamingController( Mix::IO::IReader* pReader, Mix::Sound::IController** ppController ) = 0;

		//! @}

		//! @name 3D TEh
		//! @{

		//! @brief Xi[쐬܂
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppListener 쐬Xi[n Mix::Sound::IListener C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return 쐬ɐꍇ True Ԃ܂
		virtual Boolean CreateListener( const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IListener** ppListener, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief VvG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬VvG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VvG~b^[̍쐬ɐꍇApListener ̎QƃJE^ +1 ܂
		virtual Boolean CreateSimpleEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;
		//! @brief VvG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pReader Mix::IO::IReader C^[tF[X̃|C^
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬VvG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VvG~b^[̍쐬ɐꍇApListener pReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateSimpleEmitter( Mix::Sound::IListener* pListener, Mix::IO::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;

		//! @brief Xg[~OG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pFilePath t@CpX
		//! @param[in] bBuffered t@CɊi[čĐꍇ True
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬Xg[~OG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[~OG~b^[̍쐬ɐꍇApListener ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamingEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, Boolean bBuffered, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;
		//! @brief Xg[~OG~b^[쐬܂
		//! @param[in] pListener Xi[\ Mix::Sound::IListener C^[tF[X̃|C^
		//! @param[in] pReader Mix::IO::IReader C^[tF[X̃|C^
		//! @param[in] localFront [J̑O\ Mix::Vector3 NX
		//! @param[in] localUp [J̏\ Mix::Vector3 NX
		//! @param[out] ppEmitter 쐬Xg[~OG~b^[n Mix::Sound::IEmitter C^[tF[Xւ̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note Xg[~OG~b^[̍쐬ɐꍇApListener pReader ̎QƃJE^ +1 ܂
		virtual Boolean CreateStreamingEmitter( Mix::Sound::IListener* pListener, Mix::IO::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter ) = 0;

		//! @}
	};

}}
