#pragma once

//! @file Mix/Standard.h
//! @brief X^_[hCN[ht@C

/*!
@mainpage Mainpage
^C̃Cy[WłB<br>
͂߂Ă̕ @subpage intro_page 炨ǂ݂B<br>
܂ACugpăAvP[V쐬ۂ̃qgƂ @subpage tips_page B<br>
<ul>
	<li>Mix</li><br>
	[g<br>
	<li>Mix::Dynamics</li><br>
	V~[V<br>
	<li>Mix::IO</li><br>
	t@CȂǂ̓o<br>
	<li>Mix::Geometry</li><br>
	AʁA( OBB AABB )AȂǂ̊ȈՌ`<br>
	<li>Mix::Graphics</li><br>
	DirectGraphics ̃bp[<br>
	<li>Mix::HID</li><br>
	L[{[hA}EXAQ[pbhȂǂ̃q[}C^[tF[XfoCX<br>
	<li>Mix::Memory</li><br>
	̑<br>
	<li>Mix::Parallel</li><br>
	񏈗<br>
	<li>Mix::Scene</li><br>
	_Ci~NXAOtBbNX𓝍RcV[̍쐬<br>
	<li>Mix::Sound</li><br>
	TEh̍Đ<br>
</ul>
*/

/*!
@page intro_page Introduction

@section creProj_sec Create a project

@subsection creProj_hello_subsec ͂߂
Microsoft Visual Studio Community 2013 gƂOƂĂ܂B<br>
̑Jł͈قȂꍇ܂̂ŁAӂB<br>

@subsection creProj_app_subsec AvP[V̐ݒ
Cj[́ut@CvuVK쐬vuvWFNgvIA_CAOJĂB<br>
uWin32 R\[AvP[VvIAuWindows AvP[Vv쐬܂B<br>
u\[VGNXv[[ṽvWFNgENbNAReLXgj[́uvpeBvIA<br>
u\vpeBv̈ȉ̍ڂݒ肵ĂB<br>

@par uC/C++v
uSʁv́uǉ̃CN[hfBNgv "Mix\Engine\Include" ǉ܂B<br>

@par uJv
uSʁv́uǉ̃CufBNgv "Mix\Engine\Lib\VS2013\$(PlatformTarget)\$(Configuration)" ǉ܂B<br>
úv́uǉ̈ˑt@Cv "Mix.lib" ǉ܂B<br>

@par urhCxgv
^C ( "*.dll" ) ̓AvP[V ( "*.exe" ) ƓfBNgɑ݂ĂKv邽߁A<br>
urhCxgv́uR}hCvɃ^CRs[R}h͂܂B<br>
xcopy "Mix\Engine\Bin\VS2013\$(PlatformTarget)\$(Configuration)\Mix.dll" "$(TargetDir)" /D/ /C /R /Y

@subsection newProj_run_subsec GW̏
ŏɎs WinMain ֐ƁA{IȃR[hLq܂B<br>

@code
#include "Mix/Standard.h"

int APIENTRY _tWinMain( HINSTANCE, HINSTANCE, LPTSTR, int )
{
    Mix::ENGINE_CONFIG engineConfig;

    if( Mix::Initialize( engineConfig ) == True )
    {
        Mix::IEngine* pEngine = Mix::GetEnginePtr();

        while( pEngine->Update() == True )
        {
            ;
        }

        Mix::Finalize();
    }

    return 0;
}
@endcode

@par  : Mix::Initialize
Mix::ENGINE_CONFIG \̂̐ݒ( ͋KlgpĂ܂ )gpAs܂B<br>
܂Aȍ~ Mix ̊eC^[tF[Xgpł悤ɂȂ܂B<br>

@parC[v : Mix::IEngine::Update
EBhẼbZ[WAt[[g̐Ae}l[W̍XVsĂ܂B<br>
܂ Mix::IEngine::Update  True ԂĂԂ͍XVpKv܂B<br>

@par  : Mix::Finalize
Mix::IEngine::Update  False ԂAC[v𔲂͉s܂B<br>
܂A擾A쐬C^[tF[X́AOɉĂB<br>
*/

/*!
@page tips_page Tips
<ul>
	<li>@subpage memory_page " - Memory"</li>
	<li>@subpage graphics_page "OtBbNX - Graphics"</li>
	<li>@subpage hid_page "Cvbg - Input"</li>
	<li>@subpage scene_page "V[ - Scene"</li>
</ul>
*/

/*!
@page memory_page Memory

@section memory_buffer ̊蓖
<ul>
	<li>m</li>
	<ul>
		<li>MIX_MALLOC</li><br>
		TCY( oCgP )w肵ămۂ܂B<br>
		<li>MIX_MALLOC_T</li><br>
		^Ɨvf̐w肵āAmۂ܂B<br>
		<li>MIX_ALIGNED_MALLOC</li><br>
		ACgATCY( oCgP )w肵ămۂ܂B<br>
		<li>MIX_ALIGNED_MALLOC_T</li><br>
		ACgA^Avf̐w肵ămۂ܂B<br>
	</ul>
	<br>
	<li>Ċm</li><br>
	<ul>
		<li>MIX_REALLOC</li><br>
		Ċmۂobt@̃̃|C^ATCY( oCgP )w肵ăĊmۂ܂B<br>
		<li>MIX_REALLOC_T</li><br>
		Ċmۂobt@̃̃|C^A^Avf̐w肵ăĊmۂ܂B<br>
	</ul>
	<br>
	<li></li>
	<ul>
		<li>MIX_FREE</li>
	</ul>
</ul>
@code
UInt8* pBuff = NULL;
UInt8* pTemp = NULL;

// ʏ̃̊mہA
pBuff = ( UInt8* )MIX_MALLOC( sizeof( UInt8 ) * 32 );
MIX_FREE( pBuff );

// ACgw肵̊mہA
pBuff = ( UInt8* )MIX_ALIGNED_MALLOC( 16, sizeof( UInt8 ) * 32 );
MIX_FREE( pBuff );

// ^w肵̊mہA
pBuff = MIX_MALLOC_T( UInt8, 32 );
MIX_FREE( pBuff );

// ACgA^w肵̊mہA
pBuff = MIX_ALIGNED_MALLOC_T( 16, UInt8, 32 );
MIX_FREE( pBuff );

// ̍Ċm
pBuff = MIX_MALLOC_T( UInt8, 32 );
pTemp = MIX_REALLOC_T( pBuff, UInt8, 64 );
MIX_ASSERT( pTemp != NULL );
pBuff = pTemp;
MIX_FREE( pBuff );
@endcode

@section memory_class NX̃CX^X
<ul>
	<li>NX̃CX^X쐬</li>
	<ul>
		<li>MIX_NEW_T</li><br>
		^ARXgN^̈w肵ăNX̃CX^X쐬܂B<br>
		<li>MIX_ALIGNED_NEW_T</li><br>
		ACgA^ARXgN^̈w肵ăNX̃CX^X쐬܂B<br>
	</ul>
	<li>NX̃CX^X</li>
	<ul>
		<li>MIX_DELETE_T</li><br>
		^w肵ăNX̃CX^X܂B<br>
		<li>MIX_DELETE_THIS_T</li><br>
		^w肵ăNX̎CX^X܂B( delete this )<br>
	</ul>
</ul>
<ul>
	<li>NX̃CX^Xz쐬</li>
	<ul>
		<li>MIX_NEW_ARRAY_T<br>
		^w肵ăNX̃CX^Xz쐬܂B<br>
		<li>MIX_ALIGNED_NEW_ARRAY_T<br>
		ACgA^w肵ăNX̃CX^Xz쐬܂B<br>
	</ul>
	<li>NX̃CX^Xz</li>
	<ul>
		<li>MIX_DELETE_ARRAY_T</li><br>
		^w肵ăNX̃CX^Xz܂B<br>
		<li>MIX_DELETE_PTR_ARRAY_T</li><br>
		^w肵ăNX̃CX^X̃|C^z܂B<br>
	</ul>
</ul>
̃}Ngpɂ́ANX <b>MIX_DECLARE_ALLOCATOR</b> LqKv܂B<br>
@code
class Hoge
{
public:
	MIX_DECLARE_ALLOCATOR();

public:
	Hoge( void );
	~Hoge( void );
};

Hoge* pHoge = NULL;
Hoge* pHogeArray = NULL;
Hoge* pHogePtrArray = NULL;

// ʏ̃CX^X̍쐬A
pHoge = MIX_NEW_T( Hoge );
MIX_DELETE_T( Hoge, pHoge );

// ACgw肵CX^X̍쐬A
pHoge = MIX_ALIGNED_NEW_T( 16, Hoge );
MIX_DELETE_T( Hoge, pHoge );

// ʏ̃CX^Xz̍쐬A
pHogeArray = MIX_NEW_ARRAY_T( Hoge, 8 );
MIX_DELETE_ARRAY_T( Hoge, pHogeArray );

// ACgw肵̃CX^Xz̍쐬A
pHogeArray = MIX_ALIGNED_NEW_ARRAY_T( 16, Hoge, 8 );
MIX_DELETE_ARRAY_T( Hoge, pHogeArray );

// CX^X|C^z̍쐬A
pHogePtrArray = MIX_NEW_ARRAY_T( Hoge*, 8 );
MIX_DELETE_PTR_ARRAY_T( Hoge, pHogePtrArray );

@endcode
܂Aʏ͎gp܂񂪁A̗R Windows W̃AP[^gpꍇ́Aȉ̃}NgpĂB<br>
<ul>
	<li>CX^X̍쐬</li><br>
	<ul>
		<li>MIX_NEW ( new )</li>
	</ul>
	<li>CX^X̔j</li><br>
	<ul>
		<li>MIX_DELETE ( delete )</li>
		<li>MIX_DELETE_THIS ( delete this )</li>
		<li>MIX_DELETE_ARRAY ( delete [] )</li>
	</ul>
</ul>
*/

/*!
@page graphics_page Graphics

@section graphics_shaderModel_sec VF[_[f
Mix ͕̃VF[_[fT|[gĂ܂B<br>
܂AGW̍쐬Ɏw肷VF[_[fɂĎgp DirectX ̃o[WA@\xقȂ܂B<br>
<table>
	<tr>
		<td></td>
		<th>DirectX ̃o[W</th>
		<th>@\x</th>
	</tr>
	<tr>
		<th align="left">VF[_[f3 1</th>
		<td align="center">DirectX9</td>
		<td align="center"></td>
	</tr>
	<tr>
		<th align="left">VF[_[f4 2</th>
		<td align="center">DirectX11</td>
		<td align="center">10.0</td>
	</tr>
	<tr>
		<th align="left">VF[_[f5 2</th>
		<td align="center">DirectX11</td>
		<td align="center">11.0</td>
	</tr>
</table>
<b>1 DirectX9 ɋ@\x͂܂</b><br>
<b>2 Windows Vista ͍XVvO( KB971644 )KpĂȂꍇ͓삵܂</b><br>
*/

/*! 
@page hid_page HID

@section input_keyboard L[{[h
SẴL[{[hɑΉꍇ́ANUMpbhȂǂ̈ˑL[͔̓͂ĂB<br>

@section input_mouse_subsec }EX
ꕔ̃}EX(|CeBOfoCX)͓͂󂯕tȂ\܂B<br>
ݓ͂󂯂̂ƂĈȉ̂̂܂B<br>
<ul>
	<li>fXNgbvł̑΍WԂfoCX</li><br>
	}EXȂǁB<br>
	<li>zfXNgbvł̐΍WԂfoCX</li><br>
	y^ubgȂǁB<br>
</ul>

@section input_gamepad_subsec Q[pbh
U@\͑ΉĂ܂B<br>
*/

/*!
@page scene_page Scene

@section scene_lighting_subsec CeBO
Mix ł fBNViCgACgȂǂ̃V[Ŝɑ΂ăCeBOsCĝƂ<b>O[oCg</b>A<br>
|CgCgAX|bgCgȂǂ̕IɃCeBOsCĝƂ<b>[JCg</b>Ƒ̂Ă܂B<br>
<ul>
	<li>[JCgɂ</li><br>
	[JCg͕IȃCeBOs߁AV[ɔzuĂIuWFNgɑ΂Čʔ͈͂ɂ͂Ă邩ǂ𔻒肵܂B<br>
	܂[JCgɂ郉CeBO̓RXgAIuWFNgɑ΂ĂS{܂łKp邱ƂłȂ߁A<br>
	KvȂꍇ Mix::Scene::IEntity::SetLocalLighting \bh False ݒ肷邱Ƃ߂܂B<br>
</ul>

@section scene_refraction_subsec ܌
EH[^[^Cṽ}eAŃEF[uAj[V<b>܌</b>ɂĂꍇɋ@\܂B<br>
܂A܌ʂ͎_ɂ邩ǂ𔻒肵Ăs邽߁AV[ EH[^[v[ ( Mix::Scene::IWaterPool ) ǉA<br>
Mix::Scene::IWaterPool::SetRefraction \bh True ݒ肷Kv܂B<br>
<ul>
	<li>ʂ̃bVɂ</li>
	܂͓ȏł邽߁Aʂ̃bV( v[ł邱Ƃ]܂ ) XZ ɐɂȂ悤ɂĂB<br>
	XZʂɑ΂āAȂ̂͋܏삵܂̂ŒӂĂB<br>
	<li>IuWFNgzuۂ̒ӓ_</li><br>
	ÓIȃIuWFNg̏ꍇ Mix::Scene::IEntity::SetDefaultWaterContainsResult ŋܖʂƂ̈ʒu֌W炩ߐݒ肵ĂĂB<br>
	邱ƂɂĖt[AܖʂƂ̌sƂȂȂ邽߁AptH[}X悭Ȃ܂B<br>
	܂Aw̃}eݒ肳Ă郂fAEBWFbg͂ȂׂzuȂ悤ɂĂB<br>
	|S͓̊֌Wŋܖʂ̌ƑOɂQɕĕ`悷Kv邽ߎOAptH[}Xቺ܂B<br>
	܂AܖʂƏdȂĂꍇAܖʂ艺Aܖʂ̔|Š܌ʂ͍s܂A<br>
	ܖʂƏdȂĂ镔֐؂̂悤ɂȂrWAIɂ悭܂̂ŁAȂׂ̂悤Ȕzu͔ĂB<br>
</ul>
@section scene_optimizeWidget_subsec EBWFbg̍œK
EBWFbgɂ<b>v^[</b>A<b>p[eBN</b>ƕ܂A_[ł͓̂ƂĈďĂ܂B<br>
܂t[ v~eBu𐶐邽߁A|CgCg X|bgCgɂ郉CeBOA}eA̐ݒAp[eBN̔ʂɂƂȂp[tH[}Xɑ傫eyڂ܂B<br>
<ul>
	<li>v^[ɂ</li><br>
	}eA͐[x݂̏Ȃ ( Mix::Scene::IDefaultMaterial::IsZWrite() == False ) 悤ɂA<br>
	ꊇ` ( Mix::Scene::IMaterial::GetTransparencyMethod() == Mix::Scene::IMaterial::TM_LUMP )ɂ܂B<br>
	܂A[x̏݁Aꊇ`̐ݒ fGfB^[ Őݒ肷邱Ƃł܂B<br>
	<br>
	<li>p[eBNɂ</li><br>
	}eA<b>uh</b><b>Z</b>̏ꍇ́A[x݂̏Ȃ悤ɂAꊇ`ɂ܂B<br>
	ȊȌꍇ͒ʏ <b>|SPʂŕ`</b> ɂ܂B<br>
	܂p[eBÑXvCg͔ɕł邽߁AڂɂقǉeȂ悤łA<b>ꊇ`</b>𐄏܂B<br>
	<br>
	<li>X|bgCgA|CgCgɂ郉CeBOɂ</li><br>
	{Iɂ͍sȂ悤ɂ邱ƂƂœKłB<br>
	p[eBÑXvCg̓uh̊֌W牜OɌĕ`悳邽߁A<br>
	CeBÖقȂ̂ǂqɂȂ؂ւꍇA<b>啝ȃptH[}X̒ቺ</b>ɂȂ\܂B<br>
	܂_[ɂ͂̏Ԃɘa邽߂<b>CeBO[h</b>Ƃ@\Ă܂B<br>
	<br>
	<ul>
		<li>Default</li><br>
		fBNViCgACgɂ<b>O[oCeBO</b>݂̂ŁA<br>
		X|bgCgA|CgCgɂ<b>[JCeBO</b>͍s܂B<br>
		<li>Everyone</li><br>
		EɓĂSẴEBWFbgЂƂ܂Ƃ߂ɂA[JCeBOs܂B<br>
		܂A[JCeBOɎgpAX|bgCgA|CgCg̍v͂SɌ肳܂B<br>
		<li>Detailed</li><br>
		EBWFbgPʂŃ[JCeBOs܂B<br>
		[JCgɂ郉CeBO͉\Ȍ萳s܂AptH[}X͍ňłB<br>
	</ul>
</ul>

@section scene_posteffect_subsec |XgGtFNg
<ul>
	<li>ArGgIN[W</li><br>
	̂ɂՒfĂꏊɉe𗎂Ƃ܂B<br>
	܂AIuWFNg ( EBWFbg܂ ) ɑ΂Ďs邱Ƃ͂ł܂B<br>
	<li>VhE}bsO</li><br>
	̂̉e`ʂ܂B<br>
	܂Ap[eBN̉e͕`悷邱Ƃł܂B<br>
	<li>~mVeB</li><br>
	V[̋PxɂK␳s܂B<br>
	܂AÏɂAK␳ω܂B<br>
	<li>u[</li><br>
	V[̖邢Ǝv镔ɑ΂APAĂ邩̂悤Ȍʂ܂B<br>
	<li>CgVtg</li><br>
	̂̌Ԃ炳AؘR̂悤Ȍʂ܂B<br>
	܂ASbhCA䊂ƂĂ΂Ă܂B<br>
	<li>YtA</li><br>
	邢( zȂ )YɌēĂĂۂɔ˂JԂĂł̎ʂ肱݂\܂B<br>
	<li>tB~bN</li><br>
	ɁAPx( ~mVeB )ɂK␳ꂽV[( RGB̗vf 1.0 𒴂Ă )̐F𒲐邽߂̂̂łB<br>
	܂AKvɉ<b>K}␳</b>sKv܂B<br>
	<li>K}␳</li><br>
	V[̖邳𒲐܂B<br>
	<li>[Vu[</li><br>
	J̓ɂău[܂B<br>
	܂AJ傫ۂɂނ̂悤Ȗ͗loĂ܂ꍇ́A<br>
	邩 Mix::Scene::ICamera::MOTION_BLUR_SETTINGS \̂ XP[( scale )Al( damping )𒲐ĂB<br>
	<li>F</li><br>
	Yʉ߂ۂ̕Uɂ蔭F\܂B<br>
	܂Ǎʂ͉ʂ̎͂Ɍ܂B<br>
	<li>ʊE[x</li><br>
	œ_͈͂ɂAV[̎OƉɌďXɂڂʂ܂B<br>
	<li>cȎ</li><br>
	Ỷeɂʂcތʂ܂B<br>
	<li>Blbg</li><br>
	gCJŎBlȉʂ̎͂ރgȌʂ܂B<br>
	<li>A`GCAVO</li><br>
	WM[y܂B<br>
</ul>
*/

#include "Mix/Common.h"
#include "Mix/IEngine.h"
