#pragma once

//! @file Mix/String.h
//! @brief NXCN[ht@C

#include <vector>

namespace Mix
{
	//! @class StringW
	//! @brief NX( jR[h )
	class _MIX_DLL_API StringW
	{
	private:
		enum { VA_TEMP_NUM = 2048 };
		static wchar_t empty;

	private:
		wchar_t*	m_pStr;			//
		UIntT		m_Num;			//
		UIntT		m_Size;			//NULL܂ޕ̃TCY(oCgP)
		UIntT		m_AllocateSize;	//NULL܂܂Ȃ̃TCY(oCgP)
		UIntT		m_Capacity;		//LpVeB(oCgP)

	private:
		void Allocate( UIntT num );
		void Copy( const wchar_t* pStr );
		void Copy( const wchar_t* pStr, UIntT num );
		void Convert( const char* pStr );
		void Add( const wchar_t* pStr );

	public:
		//! @brief RXgN^
		StringW( void );
		//! @brief Rs[RXgN^
		//! @param[in] pStr }`oCgւ̃|C^
		StringW( const char* pStr );
		//! @brief Rs[RXgN^
		//! @param[in] pStr jR[hւ̃|C^
		StringW( const wchar_t* pStr );
		//! @brief Rs[RXgN^
		//! @param[in] pStr jR[hւ̃|C^
		//! @param[in] sizeInWords 
		StringW( const wchar_t* pStr, UIntT sizeInWords );
		//! @brief Rs[RXgN^
		//! @param[in] str 
		StringW( const StringW& str );
		//! @brief fXgN^
		~StringW( void );

		//! @brief vf擾܂
		//! @param[in] index 擾vf̃CfbNX
		//! @return vf
		wchar_t& operator [] ( UIntT index );
		//! @brief r( == )܂
		//! @param[in] str 
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( const StringW& str ) const;
		//! @brief r( == )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( const wchar_t* pStr ) const;
		//! @brief r( == )܂
		//! @param[in] code R[h
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( wchar_t code ) const;
		//! @brief r( == )܂
		//! @param[in] nullValue NULL̂݉\
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( UIntT nullValue ) const;
		//! @brief r( != )܂
		//! @param[in] str 
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( const StringW& str ) const;
		//! @brief r( != )܂
		//! @param[in] pStr ւ̃|C^
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( const wchar_t* pStr ) const;
		//! @brief r( != )܂
		//! @param[in] nullValue NULL̂ݎw\
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( UIntT nullValue ) const;
		//! @brief ( = )܂
		//! @param[in] str 
		//! @return ̕
		StringW& operator = ( const StringW& str );
		//! @brief ( = )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ̕
		StringW& operator = ( const wchar_t* pStr );
		//! @brief ( = )܂
		//! @param[in] pStr }`oCgւ̃|C^
		//! @return ̕
		StringW& operator = ( const char* pStr );
		//! @brief ( = )܂
		//! @param[in] code R[h
		//! @return ̕
		StringW& operator = ( const wchar_t code );
		//! @brief NA܂
		//! @param[in] nullValue NULL ̂ݎw\
		//! @return 
		StringW& operator = ( UIntT nullValue );
		//! @brief ǉ( += )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ǉ̕
		StringW& operator += ( const wchar_t* pStr );
		//! @brief ǉ( += )܂
		//! @param[in] str 
		//! @return ǉ̕
		StringW& operator += ( const StringW& str );
		//! @brief ǉ( += )܂
		//! @param[in] code R[h
		//! @return ǉ̕
		StringW& operator += ( const wchar_t code );
		//! @brief ( + )܂
		//! @param[in] str 
		//! @return ̕
		StringW operator + ( const StringW& str );
		//! @brief ( + )܂
		//! @param[in] ls 敶
		//! @param[in] rs 
		//! @return ̕
		friend const StringW operator + ( const wchar_t* ls, const StringW& rs )
		{
			StringW tmp( ls );
			tmp.Add( rs.m_pStr );

			return tmp;
		}

		//! @brief r( l < r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l < r ꍇ true
		friend bool operator < ( const StringW& l, const StringW& r )
		{
			return ( ::wcscmp( l.m_pStr, r.m_pStr ) < 0 );
		}
		//! @brief r( l > r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l > r ꍇ true
		friend bool operator > ( const StringW& l, const StringW& r )
		{
			return ( ::wcscmp( l.m_pStr, r.m_pStr ) > 0 );
		}
		//! @brief r( l <= r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l <= r ꍇ true
		friend bool operator <= ( const StringW& l, const StringW& r )
		{
			return ( ::wcscmp( l.m_pStr, r.m_pStr ) <= 0 );
		}
		//! @brief r( l >= r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l >= r ꍇ true
		friend bool operator >= ( const StringW& l, const StringW& r )
		{
			return ( ::wcscmp( l.m_pStr, r.m_pStr ) >= 0 );
		}

		//! @brief Float64^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Float64 ToDouble( Boolean* pbRet = NULL ) const;
		//! @brief Float32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Float32 ToFloat( Boolean* pbRet = NULL ) const;
		//! @brief Int32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Int32 ToInt( Boolean* pbRet = NULL ) const;
		//! @brief unsigned Int32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		UInt32 ToUInt( Boolean* pbRet = NULL ) const;

		//! @brief g̃Rs[啶ɕϊĕԂ܂
		//! @return 啶ɕϊ
		StringW ToUpper( void );
		//! @brief g̃Rs[ɕϊĕԂ܂
		//! @return ɕϊ
		StringW ToLower( void );

		//! @brief g啶ɕϊ܂
		void Upper( void );
		//! @brief gɕϊ܂
		void Lower( void );

		//! @brief wtH[}bgŕ쐬܂
		//! @param[in] format tH[}bg
		//! @param[in] ... l
		//! @return 
		wchar_t* Sprintf( const wchar_t* format, ... );

		//! @brief [w肵擾܂
		//! @param[in] sizeInWords 
		//! @return 
		StringW Left( UIntT sizeInWords );
		//! @brief E[w肵擾܂
		//! @param[in] sizeInWords 
		//! @return 
		StringW Right( UIntT sizeInWords );
		//! @brief w肵ʒuƕ擾܂
		//! @param[in] startPos oJnʒu
		//! @param[in] sizeInWords o
		//! @return 
		StringW Mid( UIntT startPos, UIntT sizeInWords );

		//! @brief w肵ōŏɌʒũCfbNX擾܂
		//! @param[in] value 
		//! @return ꍇ͕̃CfbNXAȂꍇ SIZE_MAX Ԃ܂
		UIntT IndexOf( wchar_t value );
		//! @brief w肵ōŌɌʒũCfbNX擾܂
		//! @param[in] value 
		//! @return ꍇ͕̃CfbNXAȂꍇ SIZE_MAX Ԃ܂
		UIntT LastIndexOf( wchar_t value );

		//! @brief w肵Zp[^ŕ𕪊܂
		//! @param[in] pSeparator 𕪊邽߂̋؂蕶ƂĎgp镶z
		//! @param[out] list i[xN^[NX
		template<Mix::Memory::SECTION_TYPE ST>
		void Split( const wchar_t* pSeparator, std::vector<Mix::StringW, std::vector<Mix::StringW, Mix::Memory::STLAllocator<ST, Mix::StringW>>>& list )
		{
			MIX_ASSERT( pSeparator != NULL );

			Mix::StringW tmpStr( m_pStr );

			wchar_t* pCtx = NULL;
			wchar_t* pPart = wcstok_s( tmpStr.m_pStr, pSeparator, &pCtx );

			while( pt != NULL )
			{
				list.push_back( Mix::StringW( pPart ) );
				pPart = wcstok_s( NULL, pSeparator, &pCtx );
			}
		}

		//! @brief ̃|C^擾܂
		//! @return ̃|C^
		wchar_t* GetPtr( void ) const;
		//! @brief ̃|C^擾܂( CONST )
		//! @return ̃|C^
		const wchar_t* GetConstPtr( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		UIntT GetNum( void ) const;
		//! @brief TCY(oCgP)擾܂
		//! @return TCYԂ܂
		UIntT GetSize( void ) const;
		//! @brief mۂ̃TCY(oCgP)擾܂
		//! @return TCYԂ܂
		UIntT GetAllocateSize( void ) const;
		//! @brief LpVeB(oCgP)擾܂
		//! @return LpVeBԂ܂
		UIntT GetCapacity( void ) const;
	};


	//! @class StringA
	//! @brief NX( }`oCg )
	class _MIX_DLL_API StringA
	{
	private:
		enum { VA_TEMP_NUM = 2048 };
		static char empty;

	private:
		char* m_pStr;
		UIntT m_Num;
		UIntT m_Size;
		UIntT m_AllocateSize;
		UIntT m_Capacity;

	private:
		void Allocate( UIntT num );
		void Copy( const char* pStr );
		void Copy( const char* pStr, UIntT num );
		void Convert( const wchar_t* pStr );
		void Add( const char* pStr );
		UIntT CalcStrNum( const char* pStr );

	public:
		//! @brief RXgN^
		StringA( void );
		//! @brief Rs[RXgN^
		//! @param[in] pStr jR[hւ̃|C^
		StringA( const wchar_t* pStr );
		//! @brief Rs[RXgN^
		//! @param[in] pStr }`oCgւ̃|C^
		StringA( const char* pStr );
		//! @brief Rs[RXgN^
		//! @param[in] pStr ւ̃|C^
		//! @param[in] size ̃TCY
		StringA( const char* pStr, UIntT size );
		//! @brief Rs[RXgN^
		//! @param[in] str 
		StringA( const StringA& str );
		//! @brief fXgN^
		~StringA( void );

		//! @brief vf擾܂
		//! @param[in] index 擾vf̃CfbNX
		//! @return vf
		char& operator [] ( UIntT index );
		//! @brief r( == )܂
		//! @param[in] str 
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( const StringA& str ) const;
		//! @brief r( == )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( const char* pStr ) const;
		//! @brief r( == )܂
		//! @param[in] code R[h
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( char code ) const;
		//! @brief r( == )܂
		//! @param[in] nullValue NULL̂݉\
		//! @return ꍇ True Ԃ܂
		Boolean operator == ( UIntT nullValue ) const;
		//! @brief r( != )܂
		//! @param[in] str 
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( const StringA& str ) const;
		//! @brief r( != )܂
		//! @param[in] pStr ւ̃|C^
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( const char* pStr ) const;
		//! @brief r( != )܂
		//! @param[in] nullValue NULL̂ݎw\
		//! @return Ȃꍇ True Ԃ܂
		Boolean operator != ( UIntT nullValue ) const;
		//! @brief ( = )܂
		//! @param[in] str 
		//! @return ̕
		StringA& operator = ( const StringA& str );
		//! @brief ( = )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ̕
		StringA& operator = ( const char* pStr );
		//! @brief ( = )܂
		//! @param[in] pStr }`oCgւ̃|C^
		//! @return ̕
		StringA& operator = ( const wchar_t* pStr );
		//! @brief ( = )܂
		//! @param[in] code R[h
		//! @return ̕
		StringA& operator = ( char code );
		//! @brief ǉ( += )܂
		//! @param[in] pStr ւ̃|C^
		//! @return ǉ̕
		StringA& operator += ( const char* pStr );
		//! @brief ǉ( += )܂
		//! @param[in] str 
		//! @return ǉ̕
		StringA& operator += ( const StringA& str );
		//! @brief ǉ( += )܂
		//! @param[in] code R[h
		//! @return ǉ̕
		StringA& operator += ( char code );
		//! @brief ( + )܂
		//! @param[in] str 
		//! @return ̕
		StringA operator + ( const StringA& str );
		//! @brief ( + )܂
		//! @param[in] ls 敶
		//! @param[in] rs 
		//! @return ̕
		friend const StringA operator + ( const char* ls, const StringA& rs )
		{
			StringA tmp( ls );
			tmp.Add( rs.m_pStr );

			return tmp;
		}

		//! @brief r( l < r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l < r ꍇ true
		friend bool operator < ( const StringA& l, const StringA& r )
		{
			return ( ::strcmp( l.m_pStr, r.m_pStr ) < 0 );
		}
		//! @brief r( l > r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l > r ꍇ true
		friend bool operator > ( const StringA& l, const StringA& r )
		{
			return ( ::strcmp( l.m_pStr, r.m_pStr ) > 0 );
		}
		//! @brief r( l <= r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l <= r ꍇ true
		friend bool operator <= ( const StringA& l, const StringA& r )
		{
			return ( ::strcmp( l.m_pStr, r.m_pStr ) <= 0 );
		}
		//! @brief r( l >= r )܂
		//! @param[in] l r镶1
		//! @param[in] r r镶2
		//! @return l >= r ꍇ true
		friend bool operator >= ( const StringA& l, const StringA& r )
		{
			return ( ::strcmp( l.m_pStr, r.m_pStr ) >= 0 );
		}

		//! @brief Float64^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Float64 ToDouble( Boolean* pbRet = NULL ) const;
		//! @brief Float32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Float32 ToFloat( Boolean* pbRet = NULL ) const;
		//! @brief Int32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		Int32 ToInt( Boolean* pbRet = NULL ) const;
		//! @brief unsigned Int32^֕ϊ܂
		//! @param[in] pbRet Ԃl\n
		//! True \n
		//! False s
		//! @return l
		UInt32 ToUInt( Boolean* pbRet = NULL ) const;

		//! @brief g̃Rs[啶ɕϊĕԂ܂
		//! @return 啶ɕϊ
		StringA ToUpper( void );
		//! @brief g̃Rs[ɕϊĕԂ܂
		//! @return ɕϊ
		StringA ToLower( void );

		//! @brief g啶ɕϊ܂
		void Upper( void );
		//! @brief gɕϊ܂
		void Lower( void );

		//! @brief wtH[}bgŕ쐬܂
		//! @param[in] format tH[}bg
		//! @param[in] ... l
		//! @return 
		char* Sprintf( const char* format, ... );
		//! @brief [w肵擾܂
		//! @param[in] size oTCY
		//! @return 
		StringA Left( UIntT size );
		//! @brief E[w肵擾܂
		//! @param[in] size oTCY
		//! @return 
		StringA Right( UIntT size );
		//! @brief w肵ʒuƕ擾܂
		//! @param[in] startPos oJnʒu
		//! @param[in] size oTCY
		//! @return 
		StringA Mid( UIntT startPos, UIntT size );

		//! @brief w肵ōŏɌʒũCfbNX擾܂
		//! @param[in] value 
		//! @return ꍇ͕̃CfbNXAȂꍇ -1 Ԃ܂
		UIntT IndexOf( char value );
		//! @brief w肵ōŌɌʒũCfbNX擾܂
		//! @param[in] value 
		//! @return ꍇ͕̃CfbNXAȂꍇ -1 Ԃ܂
		UIntT LastIndexOf( char value );

		//! @brief w肵Zp[^ŕ𕪊܂
		//! @param[in] pSeparator 𕪊邽߂̋؂蕶ƂĎgp镶z
		//! @param[out] list i[xN^[NX
		template<Mix::Memory::SECTION_TYPE ST>
		void Split( const char* pSeparator, std::vector<Mix::StringA, std::vector<Mix::StringA, Mix::Memory::STLAllocator<ST, Mix::StringA>>>& list )
		{
			MIX_ASSERT( pSeparator != NULL );

			Mix::StringA tmpStr( m_pStr );

			char* pCtx = NULL;
			char* pPart = strtok_s( tmpStr.m_pStr, pSeparator, &pCtx );

			while( pPart != NULL )
			{
				list.push_back( Mix::StringA( pPart ) );
				pPart = strtok_s( NULL, pSeparator, &pCtx );
			}
		}

		//! @brief ̃|C^擾܂
		//! @return ̃|C^
		char* GetPtr( void ) const;
		//! @brief ̃|C^擾܂( CONST )
		//! @return ̃|C^
		const char* GetConstPtr( void ) const;
		//! @brief 擾܂
		//! @return 
		UIntT GetNum( void ) const;
		//! @brief TCY擾܂
		//! @return ̃TCY
		UIntT GetSize( void ) const;
		//! @brief mۂ̃TCY擾܂
		//! @return mۂ̃TCY
		UIntT GetAllocateSize( void ) const;
		//! @brief LpVeB(oCgP)擾܂
		//! @return LpVeBԂ܂
		UIntT GetCapacity( void ) const;
	};

	//! @typedef String
	//! @brief 
	typedef StringW String;

	//! @typedef StringListA
	//! @brief }`oCg񃊃Xg
	typedef std::vector<Mix::StringA, Mix::Memory::STLAllocator<Mix::Memory::SECTION_GENERAL, Mix::StringA>> StringListA;
	//! @typedef StringListW
	//! @brief Ch񃊃Xg
	typedef std::vector<Mix::StringW, Mix::Memory::STLAllocator<Mix::Memory::SECTION_GENERAL, Mix::StringW>> StringListW;

	//! @typedef StringList
	//! @brief 񃊃Xg
	typedef StringListW StringList;
};