#pragma once

//! @file Mix/Thread.h
//! @brief XbhCN[ht@C

#include "Mix/Noncopyable.h"

namespace Mix{

	//! @class Thread
	//! @brief XbhNX
	class _MIX_DLL_API Thread : public Mix::Noncopyable
	{
	private:
		HANDLE m_hThread;
		UInt32 m_ID;
		UInt32 m_SuspendCount;
		void ( *m_pFunc )( void* );
		void* m_pArgument;

	public:
		//! @brief RXgN^
		Thread( void );
		//! @brief fXgN^
		virtual ~Thread( void );

	private:
		static unsigned __stdcall Entry( void* pArg );

	public:
		//! @brief XbhJn܂
		//! @param[in] pFunc Xbh̎sN郋[`̊JnAhX
		//! @param[in] pArgument Xbhɓn
		//! @param[in] bSuspend True w肷ƁAXbhTXyhԂō쐬܂
		//! @return ꍇ True Ԃ܂
		Boolean Start( void( *pFunc )( void* ), void* pArgument, Boolean bSuspend = False );
		//! @brief XbhI܂
		void Join( void );

		//! @brief Xbh̃TXyhJEg 1 炵܂
		void Resume( void );
		//! @brief Xbh̃TXyhJEg 1 ₵܂
		void Suspend( void );
		//! @brief Xbh̃TXyhJEg擾܂
		//! @return Xbh̃TXyhJEg
		UInt32 GetSuspendCount( void ) const;

		//! @brief XbhID擾܂
		//! @return XbhID
		UInt32 GetID( void ) const;
	};

}
