//
//  g++ -static -mwindows -o getBarLength.exe getBarLength.cpp
//  strip getBarLength.exe
//
#include <windows.h>
//#include <Shlwapi.h>
#include <stdio.h>
#include <tchar.h>

BOOL debug = false;

int capture(HWND hWnd, int x1, int y1, int x2, int y2){
	HDC hdc;
	static BITMAPINFO bmpInfo;
	static LPDWORD lpPixel;
	static HBITMAP hBitmap;
	static HDC hMemDC;
	int width, height;

	width  = x2 - x1 + 1;
	height = y2 - y1 + 1;

	bmpInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmpInfo.bmiHeader.biWidth = width;
	bmpInfo.bmiHeader.biHeight = height;
	bmpInfo.bmiHeader.biPlanes = 1;
	bmpInfo.bmiHeader.biBitCount = 32;
	bmpInfo.bmiHeader.biCompression = BI_RGB;

	hdc = GetDC(hWnd);
	hBitmap = CreateDIBSection(hdc, &bmpInfo, DIB_RGB_COLORS, (void**)&lpPixel, NULL, 0);
	hMemDC = CreateCompatibleDC(hdc);
	SelectObject(hMemDC, hBitmap);
	ReleaseDC(hWnd, hdc);

	PrintWindow(hWnd, hMemDC, PW_CLIENTONLY);

	// 1߂̃sNZ𒲂ׂ
	int barLength = 0;
	int candKindNum = 0, candNum = 0;
	int candMax = 30;
	int *barLengthCand, *barLengthCandN;
	barLengthCand  = (int*) malloc(sizeof(int) * candMax);  // sNZۑz
	barLengthCandN = (int*) malloc(sizeof(int) * candMax);  // sNZ̏o񐔂ۑz
	for (int y = 40; y < height; y += 5){
		int x = 88;
		int i = y * width + x;
		if (lpPixel[i] != 0xff40ff && lpPixel[i] != 0x8080ff) continue;
		for (x = 88 + 1; x < width; x += 1){
			i = y * width + x;
			if (lpPixel[i] == 0xff40ff || lpPixel[i] == 0x8080ff) break;
			if (lpPixel[i] != 0x000000 && lpPixel[i] != 0xe0e0e0 && lpPixel[i] != 0xffffff) break;
			//fprintf(stderr, "(%d,%d) %x\n", x, y, lpPixel[y * width + x]);
		}
		if (x < width && (lpPixel[i] == 0xff40ff || lpPixel[i] == 0x8080ff)){
			barLength = x - 88;
			int c;
			for (c = 0; c < candKindNum; c++){
				if (barLengthCand[c] == barLength){	// ɏoƂ̂lȂo𑝂₷
					barLengthCandN[c]++;
					break;
				}
			}
			if (c >= candKindNum){					// oƂ̂Ȃl̏ꍇ
				barLengthCand[candKindNum] = barLength;
				barLengthCandN[candKindNum] = 1;
				candKindNum++;
			}
			// fprintf(stderr, "x=%d, barLength= %d\n", x, barLength);
			candNum++;
			if (candNum >= candMax) break;
		}
	}
	int maxN = 0;
	for (int c = 1; c < candKindNum; c++){
		if (barLengthCandN[c] > barLengthCandN[maxN]) maxN = c;
	}
	barLength = barLengthCand[maxN];	// ƂȏlbarLengthƂĎc
	free(barLengthCand);
	free(barLengthCandN);

	// Lv`摜t@Cۑꍇ
/*	HANDLE hFile = CreateFile(TEXT("result.bmp"), GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile != INVALID_HANDLE_VALUE){
		LONG lHeadSize  = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFO);
		LONG lWidthSize = width * sizeof(DWORD);
		LONG lImageSize = lWidthSize * height;
		DWORD dwSize;

		// wb_
		BITMAPFILEHEADER bmpHead = {0};
		bmpHead.bfType          = 0x4D42;       // ʎq(BM)
		bmpHead.bfSize          = lHeadSize + lImageSize;
		bmpHead.bfReserved1     = 0;
		bmpHead.bfReserved2     = 0;
		bmpHead.bfOffBits       = lHeadSize;

		// t@C
		WriteFile(hFile, &bmpHead, sizeof(BITMAPFILEHEADER), &dwSize, NULL);
		WriteFile(hFile, &bmpInfo, sizeof(BITMAPINFO),       &dwSize, NULL);
		WriteFile(hFile, lpPixel,  lImageSize,               &dwSize, NULL);

		CloseHandle(hFile);
	}
	*/

	DeleteDC(hMemDC);
	DeleteObject(hBitmap);

	return barLength;
}

BOOL CALLBACK EnumWndProc(HWND hWnd, LPARAM lParam){
	char *buf;
	int len;
	len = GetWindowTextLength(hWnd);
	buf = (char*)malloc(sizeof(LPWSTR)*len + 2);
	GetWindowText(hWnd, buf, len);
	//wsprintfA(charbuf, sizeof(TCHAR)==2 ? "%S" : "%s", buf);
	//if(strstr((char*)charbuf, "- ts`t")!=NULL){
	//if (StrStrW(buf, TEXT("- ts`"))!=NULL){
	if (strstr(buf, TEXT("- ts`"))!=NULL){
		(*(HWND*)lParam) = hWnd;//EBhEnhn
    if (debug){
      fprintf(stderr, "buf=%s\n", buf);
    }
	}
	return true;
}

//
// UTAÜꔏ̃sNZo͂
// ܂Ȃꍇ0o͂
//
int _tmain(int argc, _TCHAR* argv[]){
	HWND hWnd;
	RECT rc;
	int x1, y1, x2, y2, barLength = 0;
	hWnd =NULL;

	EnumWindows( EnumWndProc, (LPARAM)&hWnd);

	if(hWnd != NULL){
		GetClientRect(hWnd, &rc);
		x1 = rc.left;
		x2 = rc.right;
		y1 = rc.top;
		y2 = rc.bottom;
		barLength = capture(hWnd, x1, y1, x2, y2);
	}
	if (debug){
		fprintf(stderr, "barLength = %d\n", barLength);
		//getchar();
	}
	printf("%d", barLength);
	return 0;
}

