package personalinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author ishinob
 */
public class PersonalInfo {
    private final static String PATH = "./personal.csv";

    public PersonalInfo() {
        showPersonalDataList(readPersonalDatas(PATH));
    }

    /**
     * CSVファイルの読み込み
     * @param path
     * @return 
     */
    private List<PersonalData> readPersonalDatas(String path) {
        File f = new File(path);
        List<PersonalData> list = new ArrayList<>();

        try (BufferedReader br = new BufferedReader(new FileReader(f))) {
            String line;
            while ((line = br.readLine()) != null) {
                list.add(parsePersonalData(line));
            }
        } catch (FileNotFoundException ex) {
            Logger.getLogger(PersonalInfo.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(PersonalInfo.class.getName()).log(Level.SEVERE, null, ex);
        }

        return list;
    }

    /**
     * データをListに格納
     * @param value
     * @return 
     */
    private PersonalData parsePersonalData(String value) {
        PersonalData pd = new PersonalData();

        String[] data = value.split(",");
        pd.setName(data[0]);
        pd.setAddress(data[1]);
        pd.setTel(data[2]);
        pd.setAge(Integer.parseInt(data[3]));

        return pd;
    }
    
    /**
     * Listをコンソールに表示
     * @param list 
     */
    private void showPersonalDataList(List<PersonalData> list) {
         PersonalData pd;
        for (int i = 0; i < list.size(); i++) {
            pd = list.get(i);
            System.out.println(pd.toString());
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        PersonalInfo pi = new PersonalInfo();
    }

}
