/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.managedbean;

import com.sample.BackingDTO;
import com.sample.FacesContextUtil;
import com.sample.Person;
import com.sample.SessionDTO;
import com.sample.ifacade.BackingBeanFacade15;
import com.sample.ifacade.BackingBeanFacade19;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.inject.Inject;

/**
 *
 * @author konishiyuji
 */
@ManagedBean
@ViewScoped
public class AddPersonConfBean implements Serializable {
    @Inject
    private FacesContextUtil facesContextUtil;
    @Inject
    private SessionDTO sessionDTO;
    @Inject
    private BackingBeanFacade15 backingBeanFacade;
    @Inject
    private BackingBeanFacade19 backingBeanFacade2;
    
    private Person person;

    @PostConstruct
    public void execute(){
        System.err.println("BEGIN: AddPersonConfBean.execute()");

        BackingDTO backingDto = new BackingDTO();
        person = (Person) sessionDTO.get("PERSON");
        backingDto.put("PERSON", person);
        List<String> messages = new ArrayList<String>();
        backingDto.put("MESSAGES", messages);

        // 業務ロジックの呼び出し
        String errorCode = backingBeanFacade.execute(backingDto);
        if (!errorCode.equals("000")){
            // エラー
            sessionDTO.put("MESSAGES", messages);
            facesContextUtil.redirect("addPerson");
            return;
        }
        
        sessionDTO.put("PERSON", person);
        
        System.err.println("END  : AddPersonConfBean.execute()");
        //return errorCode;
    }

    public String action(){
        BackingDTO backingDto = new BackingDTO();
        backingDto.put("PERSON", person);

        // 業務ロジックの呼び出し
        // TODO エラー処理
        String errorCode = backingBeanFacade2.execute(backingDto);

        return "personList";
    }
    
    public String cancel(){
        return "addPerson";
    }    

    /**
     * @return the person
     */
    public Person getPerson() {
        return person;
    }

    /**
     * @param person the person to set
     */
    public void setPerson(Person person) {
        this.person = person;
    }
}
