/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef RPCMSG_H_
#define RPCMSG_H_

#include	"ipcType.h"

#if	__WORDSIZE == 64
#define	MSG_PARAM_DATA_SIZE		(7*4)
#else	/* __WORDSIZE */
#define	MSG_PARAM_DATA_SIZE		(6*4)
#endif	/* __WORDSIZE */

typedef struct {
	uint32_t funcId;
	uint32_t srcPid;
	uint32_t srcQueId;
	uint32_t seqNum;
	uint32_t extData;
	void *extParam;
} ipcMsgParam_t;

typedef struct {
#if	__WORDSIZE == 64
	uint64_t taskId;
	uint32_t padding[5];
#else	/* __WORDSIZE */
	uint32_t taskId;
	uint32_t padding[5];
#endif	/* __WORDSIZE */
} ipcSkltnLclMsgParam_t;

typedef struct {
	union {
		ipcMsgParam_t msgParam;
		ipcSkltnLclMsgParam_t skltnLclMsgParam;
		uint8_t paramData[MSG_PARAM_DATA_SIZE];
	}u;
} RpcMsgParam_t;

typedef enum {
	RPC_MSG_ID_UNKNOWN = 0,
	IPC_MSG_ID_SITE_GLOBAL_START = 0x00000000,
	IPC_MSG_ID_SITE_GLOBAL_END = 0x00FFFFFF,
	IPC_MSG_ID_SITE_LOCAL_START = 0x01000000,
	IPC_MSG_ID_STUB_LOCAL_START = 0x01001000,
	IPC_MSG_ID_STUB_LOCAL_END = 0x01001FFF,
	IPC_MSG_ID_SKELTON_LOCAL_START = 0x01002000,
	IPC_MSG_ID_SKELTON_LOCAL_END = 0x01002FFF,
	IPC_MSG_ID_SITE_LOCAL_END = 0x01FFFFFF,
	IPC_MSG_ID_USER_DEFINED_START = 0x08000000,
		/* DEFINED BY IPC USER */
	IPC_MSG_ID_USER_DEFINED_END = 0x0FFFFFFF,
	IDC_MSG_ID_DEV_GLOBAL_START = 0x10000000,
		/* DEFINED BY IDC MODULE */
	IDC_MSG_ID_DEV_GLOBAL_END = 0x7FFFFFFF,
	IDC_MSG_ID_DEV_LOCAL_START = 0x80000000,
		/* DEFINED BY IDC MODULE */
	IDC_MSG_ID_DEV_LOCAL_END = 0xFFFFFFFF,
	RPC_MSG_ID_MAX = 0xFFFFFFFF
} RpcMsgId_t;

#endif /* RPCMSG_H_ */
