// {sNX

#include <sstream>
#include <cstdlib>
#include "lilib.h"

using namespace std;

// RXgN^
LongMatrix::LongMatrix(){
  m = 1;
  n = 1;

  value = new LongFloat *[1];
  value[0] = new LongFloat[1];
}

// RXgN^
LongMatrix::LongMatrix(int rows, int columns){
  int i;

  m = rows;
  n = columns;

  value = new LongFloat *[m];
  for(i = 0; i < m; i++){
    value[i] = new LongFloat[n];
  }
}

// Rs[RXgN^
LongMatrix::LongMatrix(const LongMatrix &x){
  int i, j;

  m = x.m;
  n = x.n;

  value = new LongFloat *[m];
  for(i = 0; i < m; i++){
    value[i] = new LongFloat[n];

    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }
}

// fXgN^
LongMatrix::~LongMatrix(){
  int i;

  for(i = 0; i < m; i++){
    delete[] value[i];
  }
  delete[] value;
}

////////////////////////////////////////////////////////////////////////////////

// TCY̕ύX
void LongMatrix::resize(int rows, int columns){
  int i;

  if((m != rows) || (n != columns)){

    // ̈̔j
    for(i = 0; i < m; i++){
      delete[] value[i];
    }
    delete[] value;

    m = rows;
    n = columns;

    // ̈̍Ċm
    value = new LongFloat *[m];
    for(i = 0; i < m; i++){
      value[i] = new LongFloat[n];
    }
  }
}

////////////////////////////////////////////////////////////////////////////////

// ւ̕ϊ
string LongMatrix::getString() const{
  ostringstream output;
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      output << value[i][j] << "\t";
    }
    output << endl;
  }

  return output.str();
}

// s̎擾
int LongMatrix::rows() const{
  return m;
}

// 񐔂̎擾
int LongMatrix::columns() const{
  return n;
}

////////////////////////////////////////////////////////////////////////////////

// s̎擾
LongFloat *LongMatrix::operator[](int row) const{
  return value[row];
}

// PZ
////////////////////////////////////////////////////////////////////////////////

// +LongMatrix
LongMatrix LongMatrix::operator +() const{
  return *this;
}

// -LongMatrix
LongMatrix LongMatrix::operator -() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j];
      result.value[i][j].sign = -value[i][j].sign;
    }
  }

  return result;
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// LongMatrix + int
LongMatrix LongMatrix::operator +(int x) const{
  return *this + LongFloat(x);
}

// LongMatrix - int
LongMatrix LongMatrix::operator -(int x) const{
  return *this - LongFloat(x);
}

// LongMatrix * int
LongMatrix LongMatrix::operator *(int x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongMatrix / int
LongMatrix LongMatrix::operator /(int x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongMatrix + LongFloat
LongMatrix LongMatrix::operator +(const LongFloat &x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x;
    }
  }

  return result;
}

// LongMatrix - LongFloat
LongMatrix LongMatrix::operator -(const LongFloat &x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x;
    }
  }

  return result;
}

// LongMatrix * LongFloat
LongMatrix LongMatrix::operator *(const LongFloat &x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongMatrix / LongFloat
LongMatrix LongMatrix::operator /(const LongFloat &x) const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongMatrix + LongInterval
LongIntervalMatrix LongMatrix::operator +(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x;
    }
  }

  return result;
}

// LongMatrix - LongInterval
LongIntervalMatrix LongMatrix::operator -(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x;
    }
  }

  return result;
}

// LongMatrix * LongInterval
LongIntervalMatrix LongMatrix::operator *(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongMatrix / LongInterval
LongIntervalMatrix LongMatrix::operator /(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongMatrix + LongMatrix
LongMatrix LongMatrix::operator +(const LongMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix + LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x.value[i][j];
    }
  }

  return result;
}

// LongMatrix - LongMatrix
LongMatrix LongMatrix::operator -(const LongMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix - LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x.value[i][j];
    }
  }

  return result;
}

// LongMatrix * LongMatrix
LongMatrix LongMatrix::operator *(const LongMatrix &x) const{
  if(n != x.m){
    cerr << "[ERROR] LongMatrix * LongMatrix : Inner matrix dimensions must agree." << endl;
    exit(1);
  }

  LongMatrix result(m, x.n);
  int i, j, k;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = 0;
      for(k = 0; k < n; k++){
        result.value[i][j] += value[i][k] * x.value[k][j];
      }
    }
  }

  return result;
}

// LongMatrix + LongIntervalMatrix
LongIntervalMatrix LongMatrix::operator +(const LongIntervalMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix + LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x.value[i][j];
    }
  }

  return result;
}

// LongMatrix - LongIntervalMatrix
LongIntervalMatrix LongMatrix::operator -(const LongIntervalMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix - LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x.value[i][j];
    }
  }

  return result;
}

// LongMatrix * LongIntervalMatrix
LongIntervalMatrix LongMatrix::operator *(const LongIntervalMatrix &x) const{
  if(n != x.m){
    cerr << "[ERROR] LongMatrix * LongIntervalMatrix : Inner matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, x.n);
  int i, j, k;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = 0;
      for(k = 0; k < n; k++){
        result.value[i][j] += value[i][k] * x.value[k][j];
      }
    }
  }

  return result;
}

// Z
////////////////////////////////////////////////////////////////////////////////

// LongMatrix += int
LongMatrix &LongMatrix::operator +=(int x){
  int i, j;
  LongFloat lx;

  lx = x;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += lx;
    }
  }

  return *this;
}

// LongMatrix -= int
LongMatrix &LongMatrix::operator -=(int x){
  int i, j;
  LongFloat lx;

  lx = x;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= lx;
    }
  }

  return *this;
}

// LongMatrix *= int
LongMatrix &LongMatrix::operator *=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] *= x;
    }
  }

  return *this;
}

// LongMatrix /= int
LongMatrix &LongMatrix::operator /=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] /= x;
    }
  }

  return *this;
}

// LongMatrix += LongFloat
LongMatrix &LongMatrix::operator +=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x;
    }
  }

  return *this;
}

// LongMatrix -= LongFloat
LongMatrix &LongMatrix::operator -=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x;
    }
  }

  return *this;
}

// LongMatrix *= LongFloat
LongMatrix &LongMatrix::operator *=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] *= x;
    }
  }

  return *this;
}

// LongMatrix /= LongFloat
LongMatrix &LongMatrix::operator /=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] /= x;
    }
  }

  return *this;
}

// LongMatrix = LongMatrix
LongMatrix &LongMatrix::operator =(const LongMatrix &x){
  int i, j;

  resize(x.m, x.n);

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }

  return *this;
}

// LongMatrix += LongMatrix
LongMatrix &LongMatrix::operator +=(const LongMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix += LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x.value[i][j];
    }
  }

  return *this;
}

// LongMatrix -= LongMatrix
LongMatrix &LongMatrix::operator -=(const LongMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongMatrix -= LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x.value[i][j];
    }
  }

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int + LongMatrix
LongMatrix operator +(int a, const LongMatrix &b){
  return b + a;
}

// int - LongMatrix
LongMatrix operator -(int a, const LongMatrix &b){
  return LongFloat(a) - b;
}

// int * LongMatrix
LongMatrix operator *(int a, const LongMatrix &b){
  return b * a;
}

// int / LongMatrix
LongMatrix operator /(int a, const LongMatrix &b){
  LongMatrix result(b.m, b.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a / b.value[i][j];
    }
  }

  return result;
}

// th֐
////////////////////////////////////////////////////////////////////////////////

// Βl
LongMatrix abs(const LongMatrix &a){
  LongMatrix result(a.m, a.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a.value[i][j];
      result.value[i][j].sign = 1;
    }
  }

  return result;
}

// 
LongMatrix sqrt(const LongMatrix &a){
  LongMatrix result(a.m, a.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = sqrt(a.value[i][j]);
    }
  }

  return result;
}

// ]us
LongMatrix trans(const LongMatrix &a){
  LongMatrix result(a.n, a.m);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a.value[j][i];
    }
  }

  return result;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << LongMatrix
ostream &operator <<(std::ostream &output, const LongMatrix &x){
  output << x.getString();

  return output;
}

// Svf 0 ̍s
LongMatrix zeros(int rows, int columns){
  LongMatrix result(rows, columns);
  int i, j;

  for(i = 0; i < rows; i++){
    for(j = 0; j < columns; j++){
      result[i][j] = 0;
    }
  }

  return result;
}

// Svf 1 ̍s
LongMatrix ones(int rows, int columns){
  LongMatrix result(rows, columns);
  int i, j;

  for(i = 0; i < rows; i++){
    for(j = 0; j < columns; j++){
      result[i][j] = 1;
    }
  }

  return result;
}

// Pʍs
LongMatrix eye(int size){
  LongMatrix result(size, size);
  int i, j;

  for(i = 0; i < size; i++){
    for(j = 0; j < size; j++){
      if(i == j){
        result[i][j]= 1;
      }
      else{
        result[i][j]= 0;
      }
    }
  }

  return result;
}

// QR 
void qr(LongMatrix &q, LongMatrix &r, const LongMatrix &a){
  int m, n, i, j, k;
  LongMatrix aa, h, hh;
  LongFloat normU;

  m = a.rows();
  n = a.columns();

  q = eye(m);
  r = a;
  aa = a;

  for(k = 0; k < m - 1; k++){
    LongMatrix u(m - k, 1), v;

    for(i = 0; i < m - k; i++){
      u[i][0] = aa[i + k][k];
    }

    normU = 0;
    for(i = 0; i < m - k; i++){
      normU += u[i][0] * u[i][0];
    }
    normU = sqrt(normU);

    if(u[0][0] > 0){
      u[0][0] -= normU;
    }
    else{
      u[0][0] += normU;
    }

    normU = 0;
    for(i = 0; i < m - k; i++){
      normU += u[i][0] * u[i][0];
    }
    normU = sqrt(normU);

    v = u / normU;

    h = eye(m - k) - 2 * v * trans(v);
    hh = eye(m);
    for(i = 0; i < m - k; i++){
      for(j = 0; j < m - k; j++){
        hh[i + k][j + k] = h[i][j];
      }
    }

    aa = hh * aa;
    q = q * trans(hh);
    r = hh * r;
  }

  for(i = 1; i < m; i++){
    for(j = 0; j < n; j++){
      if(i > j){
        r[i][j] = 0;
      }
    }
  }
}
