set TCLDIR=..\..\..\..\tcl8.5.15
set TKDIR=..\..\..\..\tk8.5.15
set VCVERSION=VC9
set INCLUDEOPT=-I ..\..\..\generic\ -I %TCLDIR%\generic -I %TKDIR%\generic -I %TKDIR%\xlib

set EXTRA_LIBS=user32.lib gdi32.lib oldnames.lib advapi32.lib winspool.lib comdlg32.lib

set PACKAGE_NAME=BLT
set PACKAGE_NAME_LETTER=blt
set PACKAGE_VERSION=2.5
set PACKAGE_VERSION3=2.5.3
set PACKAGE_VERSION_NUM=25


if %1==Release goto release
if %1==Debug goto debug

:release
set OPTS=-O2 -DWIN32 -DNDEBUG -MP
set CONFIGURATION=Release
set DLLSURFIX=t
set SLIBSURFIX=ts
goto bitmode

:debug
set OPTS=-Zi -DWIN32 -DDEBUG -MP
set CONFIGURATION=Debug
set DLLSURFIX=tg
set SLIBSURFIX=tsg

:bitmode
if %2==x86 goto x86
if %2==x64 goto x64

:x86
set OUTDIR=%CONFIGURATION%_%VCVERSION%
set INSTALLDIR=..\..\..\inst_x86\
set OPTS=%OPTS% -D_WIN64
goto build

:x64
set OUTDIR=%CONFIGURATION%_AMD64_%VCVERSION%
set INSTALLDIR=..\..\..\inst_x64\


:build
set TCLLIBNAME=tcl85%DLLSURFIX%.lib tclstub85.lib
set TKLIBNAME=tk85%DLLSURFIX%.lib tkstub85.lib

SET N_OBJS=	..\..\..\generic\bltTed.c
SET V3_OBJS=	..\..\..\generic\bltTri.c ^
	..\..\..\generic\bltGrMt.c
	
SET TK_OBJS=	..\..\..\generic\tkButton.c ^
	..\..\..\generic\tkFrame.c ^
	..\..\..\generic\tkScrollbar.c
	
SET GRAPH_OBJS=	..\..\..\generic\bltGrAxis.c ^
	..\..\..\generic\bltGrBar.c ^
	..\..\..\generic\bltGrElem.c ^
	..\..\..\generic\bltGrGrid.c ^
	..\..\..\generic\bltGrHairs.c ^
	..\..\..\generic\bltGrLegd.c ^
	..\..\..\generic\bltGrLine.c ^
	..\..\..\generic\bltGrMarker.c ^
	..\..\..\generic\bltGrMisc.c ^
	..\..\..\generic\bltGrPen.c ^
	..\..\..\generic\bltGrPs.c ^
	..\..\..\generic\bltGraph.c
	
SET TCL_ONLY_OBJS=	..\..\..\generic\bltAlloc.c ^
	..\..\..\generic\bltArrayObj.c ^
	..\..\..\generic\bltBgexec.c ^
	..\..\..\generic\bltChain.c ^
	..\..\..\generic\bltDebug.c ^
	..\..\..\generic\bltHash.c ^
	..\..\..\generic\bltList.c ^
	..\..\..\generic\bltNsUtil.c ^
	..\..\..\generic\bltParse.c ^
	..\..\..\generic\bltPool.c ^
	..\..\..\generic\bltSpline.c ^
	..\..\..\generic\bltSwitch.c ^
	..\..\..\generic\bltTree.c ^
	..\..\..\generic\bltTreeCmd.c ^
	..\..\..\generic\bltUtil.c ^
	..\..\..\generic\bltVecCmd.c ^
	..\..\..\generic\bltVecMath.c ^
	..\..\..\generic\bltVecObjCmd.c ^
	..\..\..\generic\bltVector.c ^
	..\..\..\generic\bltWatch.c  ^
	..\..\..\generic\bltWinPipe.c ^
	..\..\..\generic\bltWinUtil.c ^
	..\..\..\generic\bltWinDde.c
	
SET OBJS=%GRAPH_OBJS% ^
	%TCL_ONLY_OBJS% ^
	..\..\..\generic\bltBeep.c ^
	..\..\..\generic\bltBind.c ^
	..\..\..\generic\bltBitmap.c ^
	..\..\..\generic\bltBusy.c ^
	..\..\..\generic\bltCanvEps.c ^
	..\..\..\generic\bltConfig.c ^
	..\..\..\generic\bltContainer.c ^
	..\..\..\generic\bltDragdrop.c ^
	..\..\..\generic\bltHierbox.c ^
	..\..\..\generic\bltHtext.c ^
	..\..\..\generic\bltImage.c ^
	..\..\..\generic\bltWinImage.c ^
	..\..\..\generic\bltPs.c ^
	..\..\..\generic\bltTable.c ^
	..\..\..\generic\bltTabnotebook.c ^
	..\..\..\generic\bltTabset.c ^
	..\..\..\generic\bltText.c ^
	..\..\..\generic\bltTile.c ^
	..\..\..\generic\bltTreeView.c ^
	..\..\..\generic\bltTreeViewCmd.c ^
	..\..\..\generic\bltTreeViewEdit.c ^
	..\..\..\generic\bltTreeViewColumn.c ^
	..\..\..\generic\bltTreeViewStyle.c ^
	..\..\..\generic\bltWinDraw.c ^
	..\..\..\generic\bltWinPrnt.c ^
	..\..\..\generic\bltWindow.c ^
	..\..\..\generic\bltObjConfig.c ^
	..\..\..\generic\bltWinop.c ^
	%TK_OBJS% %N_OBJS% ^
	..\..\..\generic\bltInit.c


mkdir %OUTDIR%
cd %OUTDIR%

rem === BUILD FROM HERE ===

rem threads,static
mkdir %PACKAGE_NAME_LETTER%_ThreadedStatic
cd %PACKAGE_NAME_LETTER%_ThreadedStatic

cl -DPACKAGE_NAME="\"%PACKAGE_NAME%\"" -DPACKAGE_VERSION="\"%PACKAGE_VERSION%\"" %OPTS% -DSTATIC_BUILD -c %OBJS% %INCLUDEOPT%
lib -OUT:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%%SLIBSURFIX%.lib *.obj
copy *.lib ..
cd ..

rem threads
mkdir %PACKAGE_NAME_LETTER%_ThreadedDynamic
cd %PACKAGE_NAME_LETTER%_ThreadedDynamic
cl -LD -DPACKAGE_NAME="\"%PACKAGE_NAME%\"" -DPACKAGE_VERSION="\"%PACKAGE_VERSION%\"" -DEXTERN=__declspec(dllexport) %OPTS% %OBJS% %INCLUDEOPT% /link /OUT:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%%DLLSURFIX%.dll %EXTRA_LIBS% /IMPLIB:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%%DLLSURFIX%.lib /LIBPATH:%TCLDIR%\win\%OUTDIR%\ %TCLLIBNAME% /LIBPATH:%TKDIR%\win\%OUTDIR%\ %TKLIBNAME%
copy *.dll ..
copy *.lib ..
cd ..

rem === INSTALL FROM HERE ===

mkdir %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%

copy %PACKAGE_NAME_LETTER%_ThreadedStatic\*.lib %INSTALLDIR%\lib
copy %PACKAGE_NAME_LETTER%_ThreadedDynamic\*.lib %INSTALLDIR%\lib
copy %PACKAGE_NAME_LETTER%_ThreadedDynamic\%PACKAGE_NAME%%PACKAGE_VERSION_NUM%%DLLSURFIX%.dll %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%

echo package ifneeded %PACKAGE_NAME% %PACKAGE_VERSION3% [list load [file join $dir %PACKAGE_NAME%%PACKAGE_VERSION_NUM%%DLLSURFIX%.dll] %PACKAGE_NAME%]  > %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%\pkgIndex.tcl

SET SCRIPTS_DIR=..\..\library\

copy %SCRIPTS_DIR%treeview.cur	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%bltCanvEps.pro	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\

copy %SCRIPTS_DIR%bltGraph.pro	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%dnd.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%dragdrop.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%graph.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%hierbox.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tabnotebook.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tabset.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%treeview.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%init.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tclIndex	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\

mkdir %INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\dd_protocols
copy %SCRIPTS_DIR%dd_protocols\*.* %INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\dd_protocols

cd ..
