/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.launcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jp.syuriken.snsw.lib.VersionComparator;

public class ClasspathEntry {
    private final String libraryName;
    private String libraryVersion;
    private URL libraryUrl;

    public ClasspathEntry(File file) {
        String libraryFilename = file.getName();
        int extensionPos = libraryFilename.lastIndexOf(46);
        String libraryIdentifier = extensionPos == -1 ? libraryFilename : libraryFilename.substring(0, extensionPos);
        int len = libraryIdentifier.length();
        int pos = 0;
        String libraryName = null;
        String version = null;
        while ((pos = libraryIdentifier.indexOf(45, pos)) != -1 && pos + 1 < len) {
            char tokenStartChar = libraryIdentifier.charAt(pos + 1);
            if (tokenStartChar < '0' || tokenStartChar > '9') continue;
            libraryName = libraryIdentifier.substring(0, pos);
            version = libraryIdentifier.substring(pos + 1);
            break;
        }
        if (libraryName == null) {
            libraryName = libraryIdentifier;
            version = "0";
        }
        this.libraryName = libraryName;
        this.libraryVersion = version;
        try {
            this.libraryUrl = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public URL getLibraryUrl() {
        return this.libraryUrl;
    }

    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public void update(ClasspathEntry another) {
        if (VersionComparator.compareVersion(this.libraryVersion, another.getLibraryVersion()) < 0) {
            this.libraryVersion = another.getLibraryVersion();
            this.libraryUrl = another.getLibraryUrl();
        }
    }
}

