/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.launcher;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.syuriken.snsw.launcher.ClasspathEntry;

public class TwitterClientLauncher {
    private static FilenameFilter jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private final String[] args;
    private ArrayList<String> classpath = new ArrayList();

    private static void addURL(Map<String, ClasspathEntry> urlMap, File file) {
        if (!file.exists()) {
            System.err.println("[launcher] Specified classpath is not found: " + file.getPath());
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles(jarFilter)) {
                TwitterClientLauncher.addURL(urlMap, childFile);
            }
        } else {
            ClasspathEntry classpathEntry = new ClasspathEntry(file);
            if (urlMap.containsKey(classpathEntry.getLibraryName())) {
                urlMap.get(classpathEntry.getLibraryName()).update(classpathEntry);
            } else {
                urlMap.put(classpathEntry.getLibraryName(), classpathEntry);
            }
        }
    }

    private static void checkEnvironment() {
        if (!Charset.isSupported("UTF-8")) {
            throw new AssertionError((Object)"UTF-8 \u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u3088\u3046\u3067\u3059\u3002UTF-8 \u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u74b0\u5883\u3067\u306f\u3053\u306e\u30bd\u30d5\u30c8\u3092\u52d5\u304b\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002Java VM\u306e\u958b\u767a\u5143\u306b\u554f\u3044\u5408\u308f\u305b\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new AssertionError((Object)"\u304a\u4f7f\u3044\u306eJava VM\u306a\u3044\u3057\u74b0\u5883\u3067\u306fGUI\u51fa\u529b\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u3088\u3046\u3067\u3059\u3002GUI\u30e2\u30fc\u30c9\u306b\u3059\u308b\u304b\u3001Java VM\u306bGUI\u30b5\u30dd\u30fc\u30c8\u3092\u7d44\u307f\u8fbc\u3093\u3067\u304f\u3060\u3055\u3044");
        }
    }

    public static void main(String[] args) {
        TwitterClientLauncher.checkEnvironment();
        System.exit(new TwitterClientLauncher(args).run());
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    private TwitterClientLauncher(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                int indexOf = arg.indexOf(61);
                if (indexOf == -1) {
                    System.clearProperty(arg.substring(2));
                    continue;
                }
                System.getProperties().setProperty(arg.substring(2, indexOf), arg.substring(indexOf + 1));
                continue;
            }
            if (!arg.startsWith("-L")) continue;
            this.classpath.add(arg.substring(2));
        }
        this.args = args;
    }

    private URLClassLoader prepareClassLoader() {
        HashMap<String, ClasspathEntry> libMap = new HashMap<String, ClasspathEntry>();
        for (String classpathEntry : this.classpath) {
            TwitterClientLauncher.addURL(libMap, new File(classpathEntry));
        }
        TwitterClientLauncher.addURL(libMap, new File(System.getProperty("user.home"), ".elnetw/lib"));
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (ClasspathEntry entry : libMap.values()) {
            urlList.add(entry.getLibraryUrl());
        }
        Object[] urls = urlList.toArray(new URL[urlList.size()]);
        System.out.print("[launcher] classpath=");
        System.out.println(Arrays.toString(urls));
        URLClassLoader classLoader = new URLClassLoader((URL[])urls, TwitterClientLauncher.class.getClassLoader());
        return classLoader;
    }

    public int run() {
        URLClassLoader classLoader = this.prepareClassLoader();
        try {
            Class<?> clazz = Class.forName("jp.syuriken.snsw.twclient.TwitterClientMain", false, classLoader);
            Method getInstance = clazz.getMethod("getInstance", String[].class, ClassLoader.class);
            Object instance = getInstance.invoke(null, this.args, classLoader);
            Method method = clazz.getMethod("run", new Class[0]);
            Integer retCode = (Integer)method.invoke(instance, new Object[0]);
            return retCode;
        }
        catch (ClassNotFoundException e) {
            System.err.println("[launcher] \u8d77\u52d5\u306b\u5fc5\u8981\u306a\u30af\u30e9\u30b9\u306e\u6e96\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            e.printStackTrace();
            return 16;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return 1;
        }
        catch (Exception e) {
            System.err.println("[launcher] \u8d77\u52d5\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            e.printStackTrace();
            return 16;
        }
    }
}

