/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jp.syuriken.snsw.twclient.AnimationCanceledImageObserver;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.internal.FetchEventHandler;
import jp.syuriken.snsw.twclient.internal.NetworkSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.User;

public class ImageCacher {
    private final ClientConfiguration configuration;
    public final File cacheDir;
    public final File userIconCacheDir;
    private final Logger logger = LoggerFactory.getLogger(ImageCacher.class);
    private final long cacheExpire;
    private final int flushThreshold;
    private final int flushResetInterval;
    ConcurrentHashMap<String, ImageEntry> cachedImages = new ConcurrentHashMap();

    public ImageCacher(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.cacheExpire = configuration.getConfigProperties().getLong("core.cache.icon.survive_time");
        this.flushThreshold = configuration.getConfigProperties().getInteger("core.cache.icon.flush_threshold");
        this.flushResetInterval = configuration.getConfigProperties().getInteger("core.cache.icon.flush_reset_interval");
        switch (Utility.getOstype()) {
            case WINDOWS: {
                this.cacheDir = new File(System.getProperty("java.io.tmpdir") + "/elnetw/cache");
                break;
            }
            default: {
                this.cacheDir = new File(System.getProperty("user.home") + "/.cache/elnetw");
            }
        }
        this.userIconCacheDir = new File(this.cacheDir, "user");
        this.cleanOldUserIconCache(this.userIconCacheDir);
    }

    private void cleanOldUserIconCache(File directory) {
        File[] listFiles = directory.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File file : listFiles) {
            long lastModified;
            if (file.isDirectory()) {
                this.cleanOldUserIconCache(file);
            }
            if ((lastModified = file.lastModified()) + this.cacheExpire >= System.currentTimeMillis()) continue;
            if (file.delete()) {
                this.logger.debug("clean expired cache: {} (lastModified:{})", (Object)Utility.protectPrivacy(file.getPath()), (Object)lastModified);
                continue;
            }
            this.logger.warn("Failed cleaning cache: {}", (Object)Utility.protectPrivacy(file.getPath()));
        }
    }

    private byte[] fetchContents(ImageEntry entry, URL url) throws InterruptedException {
        return NetworkSupport.fetchContents(url, new FetchEventHandlerImpl(entry, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchImage(ImageEntry entry) throws InterruptedException {
        URL url = entry.url;
        ImageEntry imageEntry = entry;
        synchronized (imageEntry) {
            if (this.cachedImages.containsKey(entry.imageKey)) {
                return;
            }
            byte[] imageData = null;
            if (entry.cacheFile != null && entry.cacheFile.exists()) {
                try {
                    File cacheFile = entry.cacheFile;
                    this.logger.debug("loadCache: file={}", (Object)cacheFile.getPath());
                    URL cacheUrl = cacheFile.toURI().toURL();
                    imageData = this.fetchContents(entry, cacheUrl);
                    if (imageData == null) {
                        entry.url = url;
                        entry.isWritten = true;
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (imageData == null) {
                imageData = this.fetchContents(entry, url);
            }
            entry.rawimage = imageData;
            entry.image = Toolkit.getDefaultToolkit().createImage(entry.rawimage);
            this.cachedImages.put(entry.imageKey, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean flushImage(ImageEntry entry) {
        ImageEntry imageEntry = entry;
        synchronized (imageEntry) {
            if (!entry.isWritten) {
                if (entry.cacheFile == null) {
                    return false;
                }
                FileOutputStream outputStream = null;
                try {
                    File file = entry.cacheFile;
                    File dirName = file.getParentFile();
                    if (!dirName.exists() && !dirName.mkdirs()) {
                        this.logger.warn("{} is not exist and can't mkdir", (Object)Utility.protectPrivacy(dirName.getPath()));
                    }
                    outputStream = new FileOutputStream(file);
                    outputStream.write(entry.rawimage);
                    entry.isWritten = true;
                    this.logger.debug("Flushed: {}", (Object)Utility.protectPrivacy(entry.cacheFile.getPath()));
                }
                catch (IOException e) {
                    this.logger.warn("Failed flushing cache: " + Utility.protectPrivacy(entry.cacheFile.getPath()), (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e3) {
                        this.logger.warn("Failed close file: " + Utility.protectPrivacy(entry.cacheFile.getPath()), (Throwable)e3);
                    }
                }
            }
            return true;
        }
    }

    public Image getImage(User user) {
        String imageKey = this.getImageKey(user);
        String url = user.getProfileImageURL();
        ImageEntry entry = this.cachedImages.get(imageKey);
        if (entry == null) {
            try {
                entry = new ImageEntry(new URL(url), imageKey);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            entry.cacheFile = this.getImageFilename(user);
            this.configuration.addJob(new ImageFetcher(entry, null));
            return null;
        }
        this.incrementAppearCount(entry);
        return entry.image;
    }

    public File getImageFile(URL url) {
        return null;
    }

    public File getImageFile(User user) throws InterruptedException {
        String imageKey = this.getImageKey(user);
        ImageEntry entry = this.cachedImages.get(imageKey);
        if (entry == null) {
            try {
                entry = new ImageEntry(new URL(user.getProfileImageURL()), imageKey);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            entry.cacheFile = this.getImageFilename(user);
            this.fetchImage(entry);
        }
        if (!entry.isWritten) {
            this.flushImage(entry);
        }
        return entry.cacheFile;
    }

    protected File getImageFilename(User user) {
        String fileName = this.getProfileImageName(user);
        long id = user.getId();
        String subdir = Integer.toHexString((int)(id & 0xFFL));
        return new File(this.userIconCacheDir, MessageFormat.format("{0}/{1}-{2}", subdir, Long.toString(id), fileName));
    }

    protected Icon getImageIcon(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        imageIcon.setImageObserver(AnimationCanceledImageObserver.SINGLETON);
        return imageIcon;
    }

    protected String getImageKey(String userId, String profileImageName) {
        return "user://" + userId + "/" + profileImageName;
    }

    protected String getImageKey(User user) {
        return this.getImageKey(String.valueOf(user.getId()), this.getProfileImageName(user));
    }

    protected String getProfileImageName(User user) {
        String url = user.getProfileImageURL();
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        return fileName;
    }

    protected void incrementAppearCount(ImageEntry entry) {
        int appearCount;
        if (entry.isWritten) {
            return;
        }
        if (entry.countEndTime < System.currentTimeMillis()) {
            entry.countEndTime = System.currentTimeMillis() + (long)this.flushResetInterval;
            entry.appearCount = 0;
        }
        if ((appearCount = ++entry.appearCount) > this.flushThreshold) {
            this.configuration.addJob((byte)4, new ImageFlusher(entry));
        }
    }

    public boolean setImageIcon(JLabel label, URL url) {
        String urlString = url.toString();
        ImageEntry entry = this.cachedImages.get(urlString);
        if (entry == null) {
            this.configuration.addJob(new ImageFetcher(new ImageEntry(url, urlString), label));
            return false;
        }
        label.setIcon(this.getImageIcon(entry.image));
        this.incrementAppearCount(entry);
        return true;
    }

    public boolean setImageIcon(JLabel label, User user) {
        String imageKey = this.getImageKey(user);
        String url = user.getProfileImageURL();
        ImageEntry entry = this.cachedImages.get(imageKey);
        if (entry == null) {
            try {
                entry = new ImageEntry(new URL(url), imageKey);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            entry.cacheFile = this.getImageFilename(user);
            this.configuration.addJob(new ImageFetcher(entry, label));
            return false;
        }
        Image image = entry.image;
        if (image != null) {
            label.setIcon(this.getImageIcon(image));
            this.incrementAppearCount(entry);
        }
        return true;
    }

    protected class ImageFlusher
    implements ParallelRunnable {
        private ImageEntry entry;

        public ImageFlusher(ImageEntry entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            ImageCacher.this.flushImage(this.entry);
        }
    }

    protected class ImageFetcher
    implements ParallelRunnable {
        public final ImageEntry entry;
        public final JLabel label;

        public ImageFetcher(ImageEntry entry, JLabel label) {
            this.entry = entry;
            this.label = label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageEntry entry = this.entry;
            if (ImageCacher.this.cachedImages.containsKey(entry.imageKey)) {
                ImageEntry imageEntry = entry;
                synchronized (imageEntry) {
                    Image image = ImageCacher.this.cachedImages.get((Object)entry.imageKey).image;
                    if (image != null) {
                        this.label.setIcon(ImageCacher.this.getImageIcon(image));
                        ImageCacher.this.incrementAppearCount(entry);
                    }
                }
                return;
            }
            try {
                ImageCacher.this.fetchImage(entry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.label != null && entry.image != null) {
                this.label.setIcon(ImageCacher.this.getImageIcon(entry.image));
                ImageCacher.this.incrementAppearCount(entry);
            }
        }
    }

    private class FetchEventHandlerImpl
    implements FetchEventHandler {
        private final Logger logger = LoggerFactory.getLogger(FetchEventHandlerImpl.class);
        private ImageEntry entry;
        private URL url;

        public FetchEventHandlerImpl(ImageEntry entry, URL url) {
            this.entry = entry;
            this.url = url;
        }

        @Override
        public void onContentLength(int contentLength) throws InterruptedException {
        }

        @Override
        public void onException(URLConnection connection, IOException e) {
            block5: {
                if (connection instanceof HttpURLConnection) {
                    try {
                        int responseCode = ((HttpURLConnection)connection).getResponseCode();
                        if (responseCode < 400 || responseCode >= 500) break block5;
                        ImageCacher.this.cachedImages.put(this.entry.imageKey, new ErrorImageEntry(this.url, (HttpURLConnection)connection));
                        if (responseCode == 404) {
                            this.logger.warn("not found: url={}", (Object)this.url);
                            break block5;
                        }
                        this.logger.warn("Error while fetching: url={}, statusCode={}", (Object)this.url, (Object)responseCode);
                    }
                    catch (IOException responseCodeException) {
                        this.logger.warn("Cannot retrieve http status code", (Throwable)responseCodeException);
                    }
                } else {
                    this.logger.warn(MessageFormat.format("Error while fetching: {0}", this.url), (Throwable)e);
                }
            }
        }

        @Override
        public void onLoaded(int imageLen) throws InterruptedException {
        }
    }

    protected static class ImageEntry {
        public final String imageKey;
        public volatile URL url;
        public Image image;
        public File cacheFile;
        public byte[] rawimage;
        protected volatile boolean isWritten = false;
        public volatile int appearCount;
        public volatile long countEndTime;

        public ImageEntry(URL url) {
            this.url = url;
            this.imageKey = url.toString();
        }

        public ImageEntry(URL url, String imageKey) {
            this.url = url;
            this.imageKey = imageKey;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ImageEntry{imageKey=").append(this.imageKey).append(",url=").append(this.url.toString()).append(",cacheFile=").append(this.cacheFile == null ? "null" : this.cacheFile.getPath()).append(",rawimage=byte[").append(this.rawimage == null ? "null" : Integer.valueOf(this.rawimage.length)).append("],isWritten=").append(this.isWritten).append(",appearCount=").append(this.appearCount).append("}");
            return stringBuilder.toString();
        }
    }

    protected static class ErrorImageEntry
    extends ImageEntry {
        public final int responseCode;

        public ErrorImageEntry(URL url, HttpURLConnection connection) throws IOException {
            super(url);
            this.responseCode = connection.getResponseCode();
        }
    }
}

