/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class JobQueue {
    public static final byte PRIORITY_MAX = 15;
    public static final byte PRIORITY_HIGH = 12;
    public static final byte PRIORITY_UI = 10;
    public static final byte PRIORITY_MEDIUM = 8;
    public static final byte PRIORITY_LOW = 4;
    public static final byte PRIORITY_IDLE = 0;
    public static final byte PRIORITY_DEFAULT = 8;
    private final LinkedQueue<Runnable>[] queues;
    private final int[] randomToPriorityTable;
    private final AtomicInteger size = new AtomicInteger();
    private final int priorityRandomMax;
    private Object jobWorkerThreadHolder = null;

    static int binarySearch(int[] table, int needle) {
        int start = 0;
        int end = table.length - 1;
        while (start <= end) {
            int pivot = start + end >>> 1;
            int v = table[pivot];
            if (v == needle) {
                return pivot;
            }
            if (v > needle) {
                end = pivot - 1;
                continue;
            }
            start = pivot + 1;
        }
        return end;
    }

    private static LinkedQueue<Runnable>[] makeLinkedQueueArray() {
        return new LinkedQueue[16];
    }

    public JobQueue() {
        this.queues = JobQueue.makeLinkedQueueArray();
        this.randomToPriorityTable = new int[17];
        for (int i = 0; i <= 15; ++i) {
            this.queues[i] = new LinkedQueue();
            this.randomToPriorityTable[i] = i == 0 ? 0 : 1 << i;
        }
        this.randomToPriorityTable[16] = this.priorityRandomMax = 65536;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(byte priority, Runnable job) {
        if (priority > 15 || priority < 0) {
            throw new IllegalArgumentException("priority must be 0 - 15");
        }
        if (job != null) {
            if (this.jobWorkerThreadHolder == null) {
                job.run();
            } else {
                LinkedQueue<Runnable> queue = this.queues[priority];
                queue.add(job);
                this.size.incrementAndGet();
                Object object = this.jobWorkerThreadHolder;
                synchronized (object) {
                    this.jobWorkerThreadHolder.notify();
                }
            }
        }
    }

    public void addJob(Runnable job) {
        this.addJob((byte)8, job);
    }

    public Runnable getJob() {
        if (this.size.get() == 0) {
            return null;
        }
        int randomInt = ThreadLocalRandom.current().nextInt(this.priorityRandomMax);
        int priorityNumber = JobQueue.binarySearch(this.randomToPriorityTable, randomInt);
        int max = priorityNumber + 15;
        for (int i = priorityNumber; i <= max; ++i) {
            if (this.size.get() == 0) {
                return null;
            }
            Runnable job = this.queues[i % 16].poll();
            if (job == null) continue;
            this.size.decrementAndGet();
            return job;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void setJobWorkerThread(Object threadHolder) {
        this.jobWorkerThreadHolder = threadHolder;
    }

    public int size() {
        return this.size.get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("JobQueue{size=[");
        for (LinkedQueue<Runnable> queue : this.queues) {
            stringBuilder.append(queue.size()).append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length()).append("]}");
        return stringBuilder.toString();
    }

    protected static class Node<E> {
        public final E item;
        public Node<E> next;

        public Node(E element, Node<E> next) {
            this.item = element;
            this.next = next;
        }
    }

    protected static class LinkedQueue<E> {
        private int size;
        private Node<E> first;
        private Node<E> last;

        protected LinkedQueue() {
        }

        public synchronized void add(E value) {
            Node<E> node = new Node<E>(value, null);
            if (this.last == null) {
                this.last = node;
                this.first = this.last;
            } else {
                this.last.next = node;
                this.last = node;
            }
            ++this.size;
        }

        public synchronized boolean isEmpty() {
            return this.size == 0;
        }

        public synchronized E poll() {
            Node<E> node = this.first;
            if (node != null) {
                if (node == this.last) {
                    this.last = null;
                }
                this.first = node.next;
                --this.size;
                return node.item;
            }
            return null;
        }

        public synchronized int size() {
            return this.size;
        }
    }

    public static interface Priority {
        public static final byte HIGH = 12;
        public static final byte MEDIUM = 8;
        public static final byte LOW = 4;
        public static final byte MAX = 15;
        public static final byte UI = 10;
        public static final byte IDLE = 0;
    }
}

