/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.JobQueue;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobWorkerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(JobWorkerThread.class);
    private static final AtomicInteger threadNumber = new AtomicInteger();
    private final Object threadHolder;
    private final JobQueue jobQueue;
    private final ConcurrentLinkedQueue<Runnable> serializeQueue;
    private final AtomicInteger runningChildThreadCount;
    private final boolean isParent;
    private final JobWorkerThread parent;
    private ArrayList<JobWorkerThread> childThreads;

    public JobWorkerThread(JobQueue jobQueue) {
        this(jobQueue, null, new Object());
    }

    private JobWorkerThread(JobQueue jobQueue, JobWorkerThread parent, Object threadHolder) {
        super("jobworker-" + threadNumber.getAndIncrement());
        this.setDaemon(false);
        this.parent = parent;
        this.threadHolder = threadHolder;
        this.jobQueue = jobQueue;
        boolean bl = this.isParent = parent == null;
        if (this.isParent) {
            ClientProperties properties = ClientConfiguration.getInstance().getConfigProperties();
            int threadsCount = properties.getInteger("core.jobqueue.threads");
            this.childThreads = new ArrayList();
            this.serializeQueue = new ConcurrentLinkedQueue();
            this.runningChildThreadCount = new AtomicInteger();
            for (int i = 1; i < threadsCount; ++i) {
                JobWorkerThread workerThread = new JobWorkerThread(jobQueue, this, threadHolder);
                this.childThreads.add(workerThread);
            }
        } else {
            this.serializeQueue = parent.serializeQueue;
            this.runningChildThreadCount = parent.runningChildThreadCount;
        }
    }

    public void cleanUp() {
        this.jobQueue.setJobWorkerThread(null);
        this.interrupt();
        for (JobWorkerThread workerThread : this.childThreads) {
            workerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object job;
        JobQueue jobQueue = this.jobQueue;
        ConcurrentLinkedQueue<Runnable> serializeQueue = this.serializeQueue;
        boolean isParent = this.isParent;
        if (isParent) {
            jobQueue.setJobWorkerThread(this.threadHolder);
            for (JobWorkerThread jobWorkerThread : this.childThreads) {
                jobWorkerThread.start();
            }
        } else {
            this.runningChildThreadCount.incrementAndGet();
        }
        while (true) {
            job = null;
            if (isParent) {
                job = serializeQueue.poll();
            }
            if (job == null) {
                job = jobQueue.getJob();
            }
            if (job == null) {
                Object object = this.threadHolder;
                synchronized (object) {
                    try {
                        logger.trace("{}: Try to wait", (Object)this.getName());
                        if (this.isInterrupted()) {
                            break;
                        }
                        this.threadHolder.wait();
                        logger.trace("{}: Wake up", (Object)this.getName());
                    }
                    catch (InterruptedException e) {
                        logger.trace("{}: Interrupted", (Object)this.getName());
                        break;
                    }
                }
            }
            if (isParent || job instanceof ParallelRunnable) {
                try {
                    job.run();
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("uncaught runtime-exception", (Throwable)runtimeException);
                }
                continue;
            }
            logger.trace("{}: Add to SerializeQueue: {}", (Object)this.getName(), job);
            serializeQueue.add((Runnable)job);
        }
        if (isParent) {
            while (this.runningChildThreadCount.get() != 0) {
                job = this.threadHolder;
                synchronized (job) {
                    try {
                        logger.trace("{}: Wait for child destroyed", (Object)this.getName());
                        if (!this.isInterrupted()) {
                            this.threadHolder.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            while (!serializeQueue.isEmpty()) {
                job = serializeQueue.poll();
                job.run();
            }
        } else {
            this.runningChildThreadCount.decrementAndGet();
            this.parent.interrupt();
        }
        logger.debug("{}: Exiting", (Object)this.getName());
    }
}

