/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.RequestToken;

public class OAuthHelper {
    private static final Logger logger = LoggerFactory.getLogger(OAuthHelper.class);
    private final ClientConfiguration configuration;

    public OAuthHelper(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public Twitter show() throws CancellationException, TwitterException {
        String message = null;
        while (true) {
            Twitter twitter = new TwitterFactory(this.configuration.getTwitterConfigurationBuilder().build()).getInstance();
            RequestToken requestToken = null;
            try {
                requestToken = twitter.getOAuthRequestToken();
            }
            catch (TwitterException e) {
                logger.warn("Could not retrieve requestToken", (Throwable)e);
                JOptionPane.showMessageDialog(null, "\u30ea\u30af\u30a8\u30b9\u30c8\u30c8\u30fc\u30af\u30f3\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u3057\u3070\u3089\u304f\u7d4c\u3063\u3066\u304b\u3089\u304a\u8a66\u3057\u304f\u3060\u3055\u3044\u3002\n\n" + e.getLocalizedMessage(), "elnetw", 0);
                throw e;
            }
            String strURL = requestToken.getAuthorizationURL();
            try {
                this.configuration.getUtility().openBrowser(strURL);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "PIN code\u3092\u8868\u793a\u3059\u308b\u305f\u3081\u306e\u30d6\u30e9\u30a6\u30b6\u3092\u691c\u7d22\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\n" + e.getLocalizedMessage(), "\u30a8\u30e9\u30fc", 0);
            }
            String viewMessage = "Please input PIN code";
            if (message != null) {
                viewMessage = viewMessage + "\n\n" + message;
                message = null;
            }
            String pin = JOptionPane.showInputDialog(null, viewMessage, "PIN CODE", 1);
            try {
                if (pin != null) {
                    if (pin.length() > 0) {
                        twitter.getOAuthAccessToken(requestToken, pin);
                        return twitter;
                    }
                    message = "PIN code\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    continue;
                }
                return null;
            }
            catch (TwitterException te) {
                if (401 == te.getStatusCode()) {
                    JOptionPane.showMessageDialog(null, "oAuth\u306b\u5931\u6557\u3057\u307e\u3057\u305f: PIN code\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc", 0);
                    continue;
                }
                JOptionPane.showMessageDialog(null, "oAuth\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + te.getLocalizedMessage(), "\u30a8\u30e9\u30fc", 0);
                continue;
            }
            break;
        }
    }
}

