/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ImageCacher;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.TweetLengthCalculator;
import jp.syuriken.snsw.twclient.TwitterClientMain;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.gui.ClientTab;
import jp.syuriken.snsw.twclient.gui.VersionInfoFrame;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.internal.DefaultTweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.HTMLFactoryDelegator;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

class TwitterClientFrame
extends JFrame
implements WindowListener,
ClientFrameApi {
    @Deprecated
    public static final String APPLICATION_NAME = "elnetw";
    static final Logger logger = LoggerFactory.getLogger(TwitterClientFrame.class);
    public final Font DEFAULT_FONT;
    public final Font UI_FONT;
    final transient ClientConfiguration configuration;
    final transient ActionListener menuActionListener = new ActionListenerImplementation();
    final transient TweetLengthCalculator DEFAULT_TWEET_LENGTH_CALCULATOR = new DefaultTweetLengthCalculator(this);
    Status inReplyToStatus = null;
    JPanel editPanel;
    JPanel postPanel;
    JScrollPane postBoxScrollPane;
    JSplitPane jSplitPane1;
    JButton postActionButton;
    JTextArea postBox;
    JTabbedPane viewTab;
    ClientProperties configProperties;
    JMenuBar clientMenu;
    JPanel tweetViewPanel;
    JMenu accountMenu;
    JMenu readTimelineJMenu;
    JMenu postToJMenu;
    JScrollPane tweetViewScrollPane;
    JEditorPane tweetViewEditorPane;
    JLabel tweetViewCreatedByLabel;
    JLabel tweetViewCreatedAtLabel;
    transient ImageCacher imageCacher;
    JLabel tweetViewUserIconLabel;
    Map<String, String> shortcutKeyMap = new HashMap<String, String>();
    JLabel postLengthLabel;
    protected transient ClientTab selectingTab;
    transient TweetLengthCalculator tweetLengthCalculator = this.DEFAULT_TWEET_LENGTH_CALCULATOR;
    transient DefaultMouseListener tweetViewListener = new DefaultMouseListener();
    transient ClientTab tweetViewingTab;
    JPanel operationPanelContainer;
    JLayeredPane tweetViewTextLayeredPane;
    JLabel tweetViewTextOverlayLabel;
    int tweetViewCreatedByFlag;
    int tweetViewCreatedAtFlag;
    int tweetViewTextOverlayFlag;

    public TwitterClientFrame(ClientConfiguration configuration) {
        logger.info("initializing frame");
        this.configuration = configuration;
        configuration.setFrameApi(this);
        this.configProperties = configuration.getConfigProperties();
        this.UI_FONT = this.configProperties.getFont("gui.font.ui");
        this.DEFAULT_FONT = this.configProperties.getFont("gui.font.default");
        this.initActionHandlerTable();
        this.getLoginUser();
        this.initComponents();
        this.imageCacher = new ImageCacher(configuration);
        logger.info("frame initialized");
    }

    @Override
    @Deprecated
    public ActionHandler addActionHandler(String name, ActionHandler handler) {
        return this.configuration.addActionHandler(name, handler);
    }

    @Override
    public void addShortcutKey(String keyString, String actionName) {
        this.shortcutKeyMap.put(keyString, actionName);
    }

    protected void addTab(ClientTab tab) {
        this.getViewTab().add(tab.getTitle(), tab.getTabComponent());
        tab.initTimeline();
    }

    @Override
    public void clearTweetView() {
        this.setTweetViewText(null, null, 0);
        this.setTweetViewCreatedAt(null, null, 0);
        this.setTweetViewCreatedBy(null, null, null, 0);
        this.setTweetViewOperationPanel(null);
    }

    @Override
    public void doPost() {
        if (this.postActionButton.isEnabled() && !this.postBox.getText().isEmpty()) {
            String text = this.tweetLengthCalculator.getShortenedText(this.getPostBox().getText());
            this.postActionButton.setEnabled(false);
            this.postBox.setEnabled(false);
            this.configuration.addJob((byte)12, new PostTask(text, this.getSelectingTab()));
        }
    }

    void focusFrameTab(ClientTab tab, int index) {
        this.getViewTab().setSelectedIndex(index);
    }

    @Override
    public void focusPostBox() {
        this.getPostBox().requestFocusInWindow();
    }

    private JMenu getAccountMenu() {
        if (this.accountMenu == null) {
            this.accountMenu = new JMenu("\u30a2\u30ab\u30a6\u30f3\u30c8");
            this.configuration.addJob((byte)4, new UserInfoFetcher());
            this.accountMenu.add(this.getReadTimelineJMenu());
            this.accountMenu.add(this.getPostToJMenu());
            JMenuItem verifyAccountMenuItem = new JMenuItem("\u30a2\u30ab\u30a6\u30f3\u30c8\u8a8d\u8a3c(V)...", 86);
            verifyAccountMenuItem.setActionCommand("menu_account_verify");
            verifyAccountMenuItem.addActionListener(this.menuActionListener);
            this.accountMenu.add(verifyAccountMenuItem);
        }
        return this.accountMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActionCommandByShortcutKey(String component, String keyString) {
        Map<String, String> map = this.shortcutKeyMap;
        synchronized (map) {
            String actionCommand = this.shortcutKeyMap.get(component + "." + keyString);
            if (actionCommand == null) {
                actionCommand = this.shortcutKeyMap.get("all." + keyString);
            }
            return actionCommand;
        }
    }

    @Override
    public ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    private JMenuBar getClientMenuBar() {
        if (this.clientMenu == null) {
            this.clientMenu = new JMenuBar();
            JMenu applicationMenu = new JMenu("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3");
            JMenuItem configMenuItem = new JMenuItem("\u8a2d\u5b9a(C)", 67);
            configMenuItem.setActionCommand("menu_config");
            configMenuItem.addActionListener(new ActionListenerImplementation());
            applicationMenu.add(configMenuItem);
            applicationMenu.addSeparator();
            JMenuItem quitMenuItem = new JMenuItem("\u7d42\u4e86(Q)", 81);
            quitMenuItem.setActionCommand("menu_quit");
            quitMenuItem.addActionListener(this.menuActionListener);
            applicationMenu.add(quitMenuItem);
            this.clientMenu.add(applicationMenu);
            this.clientMenu.add(this.getAccountMenu());
            JMenu infoMenu = new JMenu("\u60c5\u5831");
            JMenuItem versionMenuItem = new JMenuItem("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831(V)", 86);
            versionMenuItem.setActionCommand("core!version");
            versionMenuItem.addActionListener(new ActionListenerImplementation());
            infoMenu.add(versionMenuItem);
            this.clientMenu.add(infoMenu);
        }
        return this.clientMenu;
    }

    @Override
    public Font getDefaultFont() {
        return this.DEFAULT_FONT;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.editPanel);
            this.editPanel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getPostPanel(), GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.getTweetViewPanel()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.getPostPanel(), 64, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getTweetViewPanel(), 72, 72, Short.MAX_VALUE)));
        }
        return this.editPanel;
    }

    @Override
    public Component getFrame() {
        return this;
    }

    @Override
    public ImageCacher getImageCacher() {
        return this.imageCacher;
    }

    @Override
    public int getInfoSurviveTime() {
        return this.configProperties.getInteger("core.info.survive_time");
    }

    @Override
    public User getLoginUser() {
        return this.configuration.getCacheManager().getUser(Long.parseLong(this.configuration.getAccountIdForRead()));
    }

    private JButton getPostActionButton() {
        if (this.postActionButton == null) {
            this.postActionButton = new JButton();
            this.postActionButton.setText("\u6295\u7a3f");
            this.postActionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TwitterClientFrame.this.doPost();
                }
            });
        }
        return this.postActionButton;
    }

    JTextArea getPostBox() {
        if (this.postBox == null) {
            this.postBox = new JTextArea();
            this.postBox.setColumns(20);
            this.postBox.setRows(3);
            this.postBox.setFont(this.UI_FONT);
            this.postBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    TwitterClientFrame.this.handleShortcutKey("postbox", e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    TwitterClientFrame.this.updatePostLength();
                    TwitterClientFrame.this.handleShortcutKey("postbox", e);
                }
            });
        }
        return this.postBox;
    }

    private JScrollPane getPostBoxScrollPane() {
        if (this.postBoxScrollPane == null) {
            this.postBoxScrollPane = new JScrollPane();
            this.postBoxScrollPane.setViewportView(this.getPostBox());
        }
        return this.postBoxScrollPane;
    }

    private JLabel getPostLengthLabel() {
        if (this.postLengthLabel == null) {
            this.postLengthLabel = new JLabel();
            this.postLengthLabel.setText("0");
            this.postLengthLabel.setFont(this.UI_FONT);
        }
        return this.postLengthLabel;
    }

    private JPanel getPostPanel() {
        if (this.postPanel == null) {
            this.postPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.postPanel);
            this.postPanel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.getPostBoxScrollPane(), -1, 475, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.getPostActionButton()).addComponent(this.getPostLengthLabel())).addGap(18, 18, 18)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.getPostLengthLabel()).addComponent(this.getPostActionButton())).addComponent(this.getPostBoxScrollPane(), 32, 64, -2)).addContainerGap(6, Short.MAX_VALUE)));
        }
        return this.postPanel;
    }

    @Override
    public String getPostText() {
        return this.getPostBox().getText();
    }

    JMenu getPostToJMenu() {
        if (this.postToJMenu == null) {
            this.postToJMenu = new JMenu("\u6295\u7a3f\u5148");
        }
        return this.postToJMenu;
    }

    JMenu getReadTimelineJMenu() {
        if (this.readTimelineJMenu == null) {
            this.readTimelineJMenu = new JMenu("\u30bf\u30a4\u30e0\u30e9\u30a4\u30f3\u8aad\u307f\u8fbc\u307f");
        }
        return this.readTimelineJMenu;
    }

    @Override
    public ClientTab getSelectingTab() {
        return this.selectingTab;
    }

    private JSplitPane getSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setOrientation(0);
            this.jSplitPane1.setTopComponent(this.getEditPanel());
            this.jSplitPane1.setRightComponent(this.getViewTab());
            String pos = this.configProperties.getProperty("gui.main.split.pos");
            if (pos != null) {
                this.jSplitPane1.setDividerLocation(Integer.parseInt(pos));
            } else {
                this.jSplitPane1.setDividerLocation(-1);
            }
        }
        return this.jSplitPane1;
    }

    JLabel getTweetViewCreatedAtLabel() {
        if (this.tweetViewCreatedAtLabel == null) {
            this.tweetViewCreatedAtLabel = new JLabel();
            this.tweetViewCreatedAtLabel.setText("2012/1/1 00:00:00");
            this.tweetViewCreatedAtLabel.setHorizontalAlignment(4);
            this.tweetViewCreatedAtLabel.setAlignmentX(1.0f);
            this.tweetViewCreatedAtLabel.addMouseListener(this.tweetViewListener);
        }
        return this.tweetViewCreatedAtLabel;
    }

    JLabel getTweetViewCreatedByLabel() {
        if (this.tweetViewCreatedByLabel == null) {
            this.tweetViewCreatedByLabel = new JLabel();
            this.tweetViewCreatedByLabel.setText("@elnetw (\u540d\u524d\u306f\u3053\u308c\u3067\u6c7a\u307e\u308a\uff1f)");
            this.tweetViewCreatedByLabel.setToolTipText("from \u6697\u9ed2\u306e\u8abf\u548c\u5e2b");
            this.tweetViewCreatedByLabel.addMouseListener(this.tweetViewListener);
        }
        return this.tweetViewCreatedByLabel;
    }

    JEditorPane getTweetViewEditorPane() {
        if (this.tweetViewEditorPane == null) {
            this.tweetViewEditorPane = new JEditorPane();
            this.tweetViewEditorPane.setEditable(false);
            this.tweetViewEditorPane.setContentType("text/html");
            this.tweetViewEditorPane.setFont(this.UI_FONT);
            this.tweetViewEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.tweetViewEditorPane.setEditorKit(new HTMLEditorKitExtension());
            this.tweetViewEditorPane.setText("elnetw\u3078\u3088\u3046\u3053\u305d\uff01<br><b>\u3086\u3063\u304f\u308a\u3057\u3066\u3044\u3063\u3066\u306d\uff01</b>");
            this.tweetViewEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String url = e.getURL().toString();
                        if (url.startsWith("http://command/")) {
                            String command = url.substring("http://command/".length());
                            TwitterClientFrame.this.selectingTab.handleAction(Utility.getIntentArguments(command));
                        } else {
                            try {
                                TwitterClientFrame.this.configuration.getUtility().openBrowser(url);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        return this.tweetViewEditorPane;
    }

    private JPanel getTweetViewOperationPanelContainer() {
        if (this.operationPanelContainer == null) {
            this.operationPanelContainer = new JPanel();
        }
        return this.operationPanelContainer;
    }

    private JPanel getTweetViewPanel() {
        if (this.tweetViewPanel == null) {
            this.tweetViewPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.tweetViewPanel);
            this.tweetViewPanel.setLayout(layout);
            layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getTweetViewCreatedByLabel(), GroupLayout.Alignment.LEADING).addComponent(this.getTweetViewCreatedAtLabel(), GroupLayout.Alignment.LEADING)).addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.getTweetViewUserIconLabel(), -2, 48, -2)).addComponent(this.getTweetViewTextLayeredPane(), GroupLayout.Alignment.LEADING))).addComponent(this.getTweetViewOperationPanelContainer(), GroupLayout.Alignment.CENTER, 0, -2, -2));
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.getTweetViewCreatedByLabel()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap(8, Short.MAX_VALUE).addComponent(this.getTweetViewCreatedAtLabel())).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.getTweetViewUserIconLabel(), -2, 48, -2).addGap(4, 4, 4).addComponent(this.getTweetViewTextLayeredPane(), -2, 200, Short.MAX_VALUE))).addComponent(this.getTweetViewOperationPanelContainer(), 0, -2, -2));
        }
        return this.tweetViewPanel;
    }

    private JLayeredPane getTweetViewTextLayeredPane() {
        if (this.tweetViewTextLayeredPane == null) {
            this.tweetViewTextLayeredPane = new JLayeredPane();
            this.tweetViewTextLayeredPane.setLayout(new LayoutManager2(){
                Dimension minimumSize;
                Dimension prefferedSize;
                Dimension maximumSize;
                final Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

                @Override
                public void addLayoutComponent(Component comp, Object constraints) {
                    this.invalidateLayout();
                }

                @Override
                public void addLayoutComponent(String name, Component comp) {
                    if (TwitterClientFrame.this.tweetViewTextLayeredPane != comp.getParent()) {
                        throw new IllegalArgumentException("parent is already setted");
                    }
                    this.invalidateLayout();
                }

                private void calculateLayout(Container parent) {
                    if (this.minimumSize != null && this.prefferedSize != null && this.maximumSize != null) {
                        return;
                    }
                    int minw = 0;
                    int minh = 0;
                    int prefw = 0;
                    int prefh = 0;
                    int maxw = 0;
                    int maxh = 0;
                    int count = parent.getComponentCount();
                    for (int i = 0; i < count; ++i) {
                        Component component = parent.getComponent(i);
                        Dimension size = component.getMinimumSize();
                        minw = Math.max(minw, size.width);
                        minh = Math.max(minh, size.height);
                        size = component.getPreferredSize();
                        prefw = Math.max(prefw, size.width);
                        prefh = Math.max(prefh, size.height);
                        size = component.getMaximumSize();
                        maxw = Math.max(maxw, size.width);
                        maxh = Math.max(maxh, size.height);
                    }
                    this.minimumSize = new Dimension(minw, minh);
                    this.prefferedSize = new Dimension(prefw, prefh);
                    this.maximumSize = new Dimension(maxh, maxw);
                }

                @Override
                public float getLayoutAlignmentX(Container target) {
                    return 0.0f;
                }

                @Override
                public float getLayoutAlignmentY(Container target) {
                    return 0.0f;
                }

                private void invalidateLayout() {
                    this.minimumSize = null;
                    this.prefferedSize = null;
                    this.maximumSize = null;
                }

                @Override
                public void invalidateLayout(Container target) {
                    this.invalidateLayout();
                }

                @Override
                public void layoutContainer(Container parent) {
                    Insets insets = parent.getInsets();
                    Dimension size = parent.getSize();
                    int width = size.width - insets.left - insets.right;
                    int height = size.height - insets.top - insets.bottom;
                    int count = parent.getComponentCount();
                    for (int i = 0; i < count; ++i) {
                        int y;
                        int comph;
                        int x;
                        int compw;
                        Component comp = parent.getComponent(i);
                        Dimension prefSize = comp.getPreferredSize();
                        Dimension minSize = comp.getMinimumSize();
                        if ((double)Math.abs(comp.getAlignmentX() - 0.5f) < 1.0E-7) {
                            compw = width;
                            x = 0;
                        } else {
                            compw = width < prefSize.width ? (width > minSize.width ? width : minSize.width) : prefSize.width;
                            x = (int)((float)(width - compw) * comp.getAlignmentX());
                        }
                        if ((double)Math.abs(comp.getAlignmentY() - 0.5f) < 1.0E-7) {
                            comph = height;
                            y = 0;
                        } else {
                            comph = height < prefSize.height ? (height > minSize.height ? height : minSize.height) : prefSize.height;
                            y = (int)((float)(height - comph) * comp.getAlignmentY());
                        }
                        comp.setBounds(x, y, compw, comph);
                    }
                }

                @Override
                public Dimension maximumLayoutSize(Container target) {
                    return this.MAXIMUM_SIZE;
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    this.calculateLayout(parent);
                    return this.minimumSize;
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    this.calculateLayout(parent);
                    return this.prefferedSize;
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                    this.invalidateLayout();
                }
            });
            this.tweetViewTextLayeredPane.add((Component)this.getTweetViewTextOverlayLabel(), JLayeredPane.MODAL_LAYER);
            this.tweetViewTextLayeredPane.add((Component)this.getTweetViewTextScrollPane(), JLayeredPane.DEFAULT_LAYER);
        }
        return this.tweetViewTextLayeredPane;
    }

    JLabel getTweetViewTextOverlayLabel() {
        if (this.tweetViewTextOverlayLabel == null) {
            this.tweetViewTextOverlayLabel = new JLabel();
            this.tweetViewTextOverlayLabel.setAlignmentX(1.0f);
            this.tweetViewTextOverlayLabel.setAlignmentY(1.0f);
            this.tweetViewTextOverlayLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 24));
            this.tweetViewTextOverlayLabel.addMouseListener(this.tweetViewListener);
        }
        return this.tweetViewTextOverlayLabel;
    }

    private JScrollPane getTweetViewTextScrollPane() {
        if (this.tweetViewScrollPane == null) {
            this.tweetViewScrollPane = new JScrollPane();
            this.tweetViewScrollPane.getViewport().setView(this.getTweetViewEditorPane());
            this.tweetViewScrollPane.getVerticalScrollBar().setUnitIncrement(this.configProperties.getInteger("gui.list.scroll"));
            this.tweetViewScrollPane.setAlignmentX(0.5f);
            this.tweetViewScrollPane.setAlignmentY(0.5f);
        }
        return this.tweetViewScrollPane;
    }

    private JLabel getTweetViewUserIconLabel() {
        if (this.tweetViewUserIconLabel == null) {
            this.tweetViewUserIconLabel = new JLabel();
            this.tweetViewUserIconLabel.setHorizontalAlignment(0);
            this.tweetViewUserIconLabel.setVerticalAlignment(0);
        }
        return this.tweetViewUserIconLabel;
    }

    @Override
    @Deprecated
    public Twitter getTwitter() {
        return this.getTwitterForRead();
    }

    @Override
    @Deprecated
    public Twitter getTwitterForRead() {
        return this.configuration.getTwitterForRead();
    }

    @Override
    @Deprecated
    public Twitter getTwitterForWrite() {
        return this.configuration.getTwitterForWrite();
    }

    @Override
    public Font getUiFont() {
        return this.UI_FONT;
    }

    @Override
    public Utility getUtility() {
        return this.configuration.getUtility();
    }

    JTabbedPane getViewTab() {
        if (this.viewTab == null) {
            this.viewTab = new JTabbedPane();
            this.viewTab.setBackground(Color.WHITE);
            this.viewTab.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (TwitterClientFrame.this.selectingTab != null) {
                        TwitterClientFrame.this.selectingTab.focusLost();
                    }
                    TwitterClientFrame.this.selectingTab = TwitterClientFrame.this.configuration.getFrameTab(TwitterClientFrame.this.viewTab.getSelectedIndex());
                    if (TwitterClientFrame.this.selectingTab != null) {
                        TwitterClientFrame.this.selectingTab.focusGained();
                    }
                }
            });
        }
        return this.viewTab;
    }

    @Override
    @Deprecated
    public void handleAction(String name, StatusData statusData) {
        IntentArguments intentArguments = new IntentArguments(name);
        ActionHandler actionHandler = this.configuration.getActionHandler(intentArguments);
        if (actionHandler == null) {
            logger.warn("ActionHandler {} is not found.", (Object)name);
        } else {
            logger.trace("ActionHandler {} called.", (Object)name);
            actionHandler.handleAction(intentArguments);
        }
    }

    @Override
    public void handleException(Exception ex) {
    }

    @Override
    public void handleException(TwitterException e) {
        this.handleException((Exception)((Object)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleShortcutKey(String component, KeyEvent e) {
        int id = e.getID();
        if (id == 400) {
            throw new IllegalArgumentException("KeyEvent.getID() must not be KEY_TYPED");
        }
        Map<String, String> map = this.shortcutKeyMap;
        synchronized (map) {
            String keyString = Utility.toKeyString(e);
            String actionCommandName = this.getActionCommandByShortcutKey(component, keyString);
            if (actionCommandName != null) {
                this.getSelectingTab().handleAction(Utility.getIntentArguments(actionCommandName));
                e.consume();
            }
        }
    }

    private void initActionHandlerTable() {
        this.configuration.addActionHandler("core", new CoreFrameActionHandler());
    }

    private void initComponents() {
        this.setTitle(APPLICATION_NAME);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getSplitPane1(), -1, 553, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getSplitPane1(), -1, 324, Short.MAX_VALUE));
        this.pack();
        this.setJMenuBar(this.getClientMenuBar());
        Dimension size = this.configProperties.getDimension("gui.main.size");
        if (size != null) {
            this.setSize(size);
        }
    }

    boolean isFocusTab(int index) {
        return this.getViewTab().getSelectedIndex() == index;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initActionHandlerTable();
    }

    void refreshTab(int indexOf, ClientTab tab) {
        JTabbedPane tabbedPane = this.getViewTab();
        tabbedPane.setIconAt(indexOf, tab.getIcon());
        tabbedPane.setTitleAt(indexOf, tab.getTitle());
        tabbedPane.setToolTipTextAt(indexOf, tab.getToolTip());
    }

    void removeFrameTab(int indexOf, ClientTab tab) {
        JTabbedPane viewTab = this.getViewTab();
        viewTab.remove(indexOf);
    }

    @Override
    public Status setInReplyToStatus(Status status) {
        Status previousInReplyToStatus = this.inReplyToStatus;
        this.inReplyToStatus = status;
        return previousInReplyToStatus;
    }

    @Override
    public String setPostText(String text) {
        return this.setPostText(text, text.length(), text.length());
    }

    @Override
    public String setPostText(String text, int selectionStart, int selectionEnd) {
        JTextArea textArea = this.getPostBox();
        String oldText = textArea.getText();
        textArea.setText(text);
        textArea.select(selectionStart, selectionEnd);
        this.updatePostLength();
        return oldText;
    }

    @Override
    public TweetLengthCalculator setTweetLengthCalculator(TweetLengthCalculator newCalculator) {
        TweetLengthCalculator oldCalculator = this.tweetLengthCalculator;
        this.tweetLengthCalculator = newCalculator == null ? this.DEFAULT_TWEET_LENGTH_CALCULATOR : newCalculator;
        return oldCalculator;
    }

    @Override
    public void setTweetViewCreatedAt(String createdAt, String toolTip, int actionFlag) {
        this.getTweetViewCreatedAtLabel().setText(createdAt);
        this.getTweetViewCreatedAtLabel().setToolTipText(toolTip);
        this.tweetViewCreatedAtFlag = actionFlag;
    }

    @Override
    public void setTweetViewCreatedBy(Icon icon, String createdBy, String toolTip, int actionFlag) {
        this.getTweetViewUserIconLabel().setIcon(icon);
        this.getTweetViewCreatedByLabel().setText(createdBy);
        this.getTweetViewCreatedByLabel().setToolTipText(toolTip);
        this.tweetViewCreatedByFlag = actionFlag;
    }

    @Override
    public void setTweetViewOperationPanel(JPanel operationPanel) {
        this.operationPanelContainer.removeAll();
        if (operationPanel != null) {
            this.operationPanelContainer.add(operationPanel);
        }
    }

    @Override
    public void setTweetViewText(String tweetData, String overlayString, int actionFlag) {
        this.tweetViewingTab = this.selectingTab;
        this.getTweetViewEditorPane().setText(tweetData);
        this.getTweetViewTextOverlayLabel().setText(overlayString);
        this.tweetViewTextOverlayFlag = actionFlag;
    }

    @Override
    @Deprecated
    public void setTweetViewText(String tweetData, String createdBy, String createdByToolTip, String createdAt, String createdAtToolTip, Icon icon, JPanel operationPanel) {
        this.clearTweetView();
        this.setTweetViewText(tweetData, null, 0);
        this.setTweetViewCreatedAt(createdAt, createdAtToolTip, 0);
        this.setTweetViewCreatedBy(icon, createdBy, createdByToolTip, 0);
        this.setTweetViewOperationPanel(operationPanel);
    }

    public void start() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TwitterClientFrame.this.setVisible(true);
            }
        });
    }

    void updatePostLength() {
        this.tweetLengthCalculator.calcTweetLength(this.getPostBox().getText());
    }

    @Override
    public void updatePostLength(String length, Color color, String tooltip) {
        JLabel label = this.getPostLengthLabel();
        label.setText(length);
        label.setForeground(color);
        label.setToolTipText(tooltip);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        logger.debug("closing main-window...");
        StringBuilder tabs = new StringBuilder();
        for (ClientTab tab : this.configuration.getFrameTabs()) {
            String tabId = tab.getTabId();
            String uniqId = tab.getUniqId();
            tabs.append(tabId).append(':').append(uniqId).append(' ');
            this.configProperties.setProperty("gui.tabs.data." + uniqId, tab.getSerializedData());
        }
        this.configProperties.setProperty("gui.tabs.list", tabs.toString().trim());
        this.configProperties.setDimension("gui.main.size", this.getSize());
        this.configProperties.setInteger("gui.main.split.pos", this.getSplitPane1().getDividerLocation());
        this.configProperties.store();
        TwitterClientMain.quit();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    final class UserInfoFetcher
    implements Runnable {
        public final String[] accountList;
        final UserInfoFetcher this$uif;
        public int offset;
        public JMenuItem[] readTimelineMenuItems;
        public JMenuItem[] postToMenuItems;

        public UserInfoFetcher() {
            this.accountList = TwitterClientFrame.this.configuration.getAccountList();
            this.this$uif = this;
            this.offset = 0;
            this.readTimelineMenuItems = new JMenuItem[this.accountList.length];
            this.postToMenuItems = new JMenuItem[this.accountList.length];
            String defaultAccountId = TwitterClientFrame.this.configuration.getDefaultAccountId();
            ButtonGroup readButtonGroup = new ButtonGroup();
            ButtonGroup writeButtonGroup = new ButtonGroup();
            for (int i = 0; i < this.accountList.length; ++i) {
                String accountId = this.accountList[i];
                JRadioButtonMenuItem readMenuItem = new JRadioButtonMenuItem(accountId);
                readMenuItem.setActionCommand("menu_login_read!accountId=" + accountId);
                readMenuItem.addActionListener(TwitterClientFrame.this.menuActionListener);
                if (accountId.equals(defaultAccountId)) {
                    readMenuItem.setSelected(true);
                    readMenuItem.setFont(readMenuItem.getFont().deriveFont(1));
                }
                this.readTimelineMenuItems[i] = readMenuItem;
                TwitterClientFrame.this.getReadTimelineJMenu().add(readMenuItem);
                readButtonGroup.add(readMenuItem);
                JRadioButtonMenuItem writeMenuItem = new JRadioButtonMenuItem(accountId);
                writeMenuItem.setActionCommand("menu_login_write!accountId=" + accountId);
                writeMenuItem.addActionListener(TwitterClientFrame.this.menuActionListener);
                if (accountId.equals(defaultAccountId)) {
                    writeMenuItem.setSelected(true);
                    writeMenuItem.setFont(writeMenuItem.getFont().deriveFont(1));
                }
                this.postToMenuItems[i] = writeMenuItem;
                TwitterClientFrame.this.getPostToJMenu().add(writeMenuItem);
                writeButtonGroup.add(writeMenuItem);
            }
        }

        @Override
        public void run() {
            if (this.offset < this.accountList.length) {
                int lookupUsersSize = this.accountList.length - this.offset;
                lookupUsersSize = lookupUsersSize <= 100 ? lookupUsersSize : 100;
                try {
                    long[] ids = new long[lookupUsersSize];
                    for (int i = 0; i < lookupUsersSize; ++i) {
                        ids[i] = Long.parseLong(this.accountList[this.offset + i]);
                    }
                    ResponseList users = TwitterClientFrame.this.configuration.getTwitterForRead().lookupUsers(ids);
                    int finish = this.offset + lookupUsersSize;
                    for (User user : users) {
                        for (int i = this.offset; i < finish; ++i) {
                            if (!this.accountList[i].equals(String.valueOf(user.getId()))) continue;
                            this.readTimelineMenuItems[i].setText(user.getScreenName());
                            this.postToMenuItems[i].setText(user.getScreenName());
                        }
                    }
                    this.offset += lookupUsersSize;
                }
                catch (TwitterException e) {
                    e.printStackTrace();
                }
                TwitterClientFrame.this.configuration.getTimer().schedule(new Runnable(){

                    @Override
                    public void run() {
                        TwitterClientFrame.this.configuration.addJob((byte)4, UserInfoFetcher.this.this$uif);
                    }
                }, 10L, TimeUnit.SECONDS);
            }
        }
    }

    private class PostTask
    extends TwitterRunnable
    implements ParallelRunnable {
        private final String text;
        private ClientTab tab;

        public PostTask(String text, ClientTab selectingTab) {
            this.text = text;
            this.tab = selectingTab;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void access() throws TwitterException {
            block12: {
                try {
                    String escapedText = this.text;
                    StatusUpdate statusUpdate = new StatusUpdate(escapedText);
                    if (TwitterClientFrame.this.inReplyToStatus != null) {
                        statusUpdate.setInReplyToStatusId(TwitterClientFrame.this.inReplyToStatus.getId());
                    }
                    this.configuration.getTwitterForWrite().updateStatus(statusUpdate);
                    TwitterClientFrame.this.postBox.setText("");
                    TwitterClientFrame.this.updatePostLength();
                    TwitterClientFrame.this.inReplyToStatus = null;
                    TwitterClientFrame.this.tweetLengthCalculator = TwitterClientFrame.this.DEFAULT_TWEET_LENGTH_CALCULATOR;
                }
                catch (Throwable throwable) {
                    try {
                        TwitterClientFrame this$tcf = TwitterClientFrame.this;
                        Runnable enabler = new Runnable(this$tcf){
                            final /* synthetic */ TwitterClientFrame val$this$tcf;
                            {
                                this.val$this$tcf = twitterClientFrame;
                            }

                            @Override
                            public void run() {
                                this.val$this$tcf.postActionButton.setEnabled(true);
                                this.val$this$tcf.postBox.setEnabled(true);
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            enabler.run();
                        } else {
                            EventQueue.invokeAndWait(enabler);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException e) {
                        logger.warn("doPost", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    TwitterClientFrame this$tcf = TwitterClientFrame.this;
                    Runnable enabler = new /* invalid duplicate definition of identical inner class */;
                    if (EventQueue.isDispatchThread()) {
                        enabler.run();
                        break block12;
                    }
                    EventQueue.invokeAndWait(enabler);
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException e) {
                    logger.warn("doPost", (Throwable)e);
                }
            }
        }

        @Override
        protected void onException(TwitterException ex) {
            this.tab.getRenderer().onException((Exception)((Object)ex));
        }
    }

    private final class DefaultMouseListener
    implements MouseListener {
        private static final String DEL_FTAG = "<!-- del -->";
        private static final String DEL_ETAG = "<!-- /del -->";
        private static final String DEL_ALL = "<!-- delbefthis -->";
        private static final String UNDERLINE_TAG = "<!-- del --><span style='text-decoration:underline' class='autoinserted'><!-- /del -->";
        private static final String HTML_UNDERLINE_TAG = "<html><span style='text-decoration:underline' class='autohtmled'><!-- delbefthis -->";
        private static final String END_TAG = "<!-- del --></span><!-- /del -->";

        private DefaultMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (TwitterClientFrame.this.tweetViewingTab != null) {
                String messageName;
                Component component = e.getComponent();
                if (component == TwitterClientFrame.this.tweetViewCreatedAtLabel) {
                    messageName = "event createdAt clicked";
                } else if (component == TwitterClientFrame.this.tweetViewCreatedByLabel) {
                    messageName = "event createdBy clicked";
                } else if (component == TwitterClientFrame.this.tweetViewTextOverlayLabel) {
                    messageName = "event overlaylabel clicked";
                } else {
                    return;
                }
                TwitterClientFrame.this.tweetViewingTab.getRenderer().onClientMessage(messageName, e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof JLabel) {
                int flag;
                JLabel label = (JLabel)component;
                if (label == TwitterClientFrame.this.tweetViewCreatedAtLabel) {
                    flag = TwitterClientFrame.this.tweetViewCreatedAtFlag;
                } else if (label == TwitterClientFrame.this.tweetViewCreatedByLabel) {
                    flag = TwitterClientFrame.this.tweetViewCreatedByFlag;
                } else if (label == TwitterClientFrame.this.tweetViewTextOverlayLabel) {
                    flag = TwitterClientFrame.this.tweetViewTextOverlayFlag;
                } else {
                    return;
                }
                if ((flag & 1) != 0) {
                    label.setForeground(Color.BLUE);
                }
                if ((flag & 2) != 0) {
                    StringBuilder stringBuilder = new StringBuilder(label.getText());
                    if (stringBuilder.indexOf("<html>") == 0) {
                        stringBuilder.insert("<html>".length(), UNDERLINE_TAG);
                        stringBuilder.append(END_TAG);
                    } else {
                        stringBuilder.insert(0, HTML_UNDERLINE_TAG);
                        stringBuilder.append(END_TAG);
                    }
                    label.setText(stringBuilder.toString());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof JLabel) {
                int flag;
                JLabel label = (JLabel)e.getComponent();
                if (label == TwitterClientFrame.this.getTweetViewCreatedAtLabel()) {
                    flag = TwitterClientFrame.this.tweetViewCreatedAtFlag;
                } else if (label == TwitterClientFrame.this.getTweetViewCreatedByLabel()) {
                    flag = TwitterClientFrame.this.tweetViewCreatedByFlag;
                } else if (label == TwitterClientFrame.this.getTweetViewTextOverlayLabel()) {
                    flag = TwitterClientFrame.this.tweetViewTextOverlayFlag;
                } else {
                    return;
                }
                if ((flag & 1) != 0) {
                    label.setForeground(Color.BLACK);
                }
                if ((flag & 2) != 0) {
                    int etagStart;
                    int indexOf;
                    StringBuilder stringBuilder = new StringBuilder(label.getText());
                    while ((indexOf = stringBuilder.indexOf(DEL_FTAG)) != -1 && (etagStart = stringBuilder.indexOf(DEL_ETAG, indexOf)) != -1) {
                        stringBuilder.delete(indexOf, etagStart + DEL_ETAG.length());
                    }
                    indexOf = stringBuilder.indexOf(DEL_ALL);
                    if (indexOf != -1) {
                        stringBuilder.delete(0, indexOf + DEL_ALL.length());
                    }
                    label.setText(stringBuilder.toString());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public class CoreFrameActionHandler
    implements ActionHandler {
        @Override
        public JMenuItem createJMenuItem(IntentArguments args) {
            return null;
        }

        @Override
        public void handleAction(IntentArguments args) {
            String actionName = args.getExtraObj("_arg", String.class);
            if (actionName == null) {
                throw new IllegalArgumentException("`action` is not found");
            }
            if (actionName.equals("move_between_list_and_postbox")) {
                actionName = TwitterClientFrame.this.getPostBox().isFocusOwner() ? "focuslist" : "focusinput";
            }
            switch (actionName) {
                case "submenu": {
                    return;
                }
                case "version": {
                    VersionInfoFrame frame = new VersionInfoFrame();
                    frame.setVisible(true);
                    break;
                }
                case "focusinput": {
                    TwitterClientFrame.this.getPostBox().requestFocusInWindow();
                    break;
                }
                case "tabswitch_prev": {
                    JTabbedPane tab = TwitterClientFrame.this.getViewTab();
                    int selectedIndex = tab.getSelectedIndex();
                    if (selectedIndex <= 0) break;
                    tab.setSelectedIndex(selectedIndex - 1);
                    break;
                }
                case "tabswitch_next": {
                    JTabbedPane tab = TwitterClientFrame.this.getViewTab();
                    int selectedIndex = tab.getSelectedIndex();
                    if (selectedIndex >= tab.getTabCount() - 1) break;
                    tab.setSelectedIndex(selectedIndex + 1);
                    break;
                }
                default: {
                    String messageName;
                    switch (actionName) {
                        case "focuslist": {
                            messageName = "request focus tabComponent";
                            break;
                        }
                        case "postnext": {
                            messageName = "request focus nextComponent";
                            break;
                        }
                        case "postprev": {
                            messageName = "request focus prevComponent";
                            break;
                        }
                        case "postuserprev": {
                            messageName = "request focus userPrevComponent";
                            break;
                        }
                        case "postusernext": {
                            messageName = "request focus userNextComponent";
                            break;
                        }
                        case "postfirst": {
                            messageName = "request focus firstComponent";
                            break;
                        }
                        case "postlast": {
                            messageName = "request focus lastComponent";
                            break;
                        }
                        case "postwindowfirst": {
                            messageName = "request focus windowFirstComponent";
                            break;
                        }
                        case "postwindowlast": {
                            messageName = "request focus windowLastComponent";
                            break;
                        }
                        case "scroll_as_windowlast": {
                            messageName = "scroll as window last";
                            break;
                        }
                        case "jump_inReplyTo": {
                            messageName = "request focus inReplyTo";
                            break;
                        }
                        case "jump_inReplyToBack": {
                            messageName = "request focus back inReplyTo";
                            break;
                        }
                        default: {
                            logger.warn("[core AH] {} is not command", (Object)actionName);
                            return;
                        }
                    }
                    TwitterClientFrame.this.getSelectingTab().getRenderer().onClientMessage(messageName, null);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments args) {
            if ("core!submenu".equals(menuItem.getActionCommand())) {
                Component[] subItems;
                if (!(menuItem instanceof JMenu)) {
                    logger.error("\"core!submenu\" argued menuItem not as JMenu");
                    throw new AssertionError();
                }
                for (Component subItem : subItems = ((JMenu)menuItem).getMenuComponents()) {
                    if (!(subItem instanceof JMenuItem)) continue;
                    JMenuItem subMenuItem = (JMenuItem)subItem;
                    String actionCommand = subMenuItem.getActionCommand();
                    IntentArguments intentArguments = new IntentArguments(actionCommand);
                    TwitterClientFrame.this.configuration.getActionHandler(intentArguments).popupMenuWillBecomeVisible(subMenuItem, intentArguments);
                }
            }
        }
    }

    private final class ActionListenerImplementation
    implements ActionListener {
        private ActionListenerImplementation() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TwitterClientFrame.this.configuration.handleAction(Utility.getIntentArguments(e.getActionCommand()));
        }
    }

    private static final class HTMLEditorKitExtension
    extends HTMLEditorKit {
        private transient HTMLEditorKit.HTMLFactory viewFactory = new HTMLFactoryDelegator();

        private HTMLEditorKitExtension() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }
    }
}

