/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ImageCacher;
import jp.syuriken.snsw.twclient.JobWorkerThread;
import jp.syuriken.snsw.twclient.OAuthHelper;
import jp.syuriken.snsw.twclient.TwitterClientFrame;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.config.ActionButtonConfigType;
import jp.syuriken.snsw.twclient.config.BooleanConfigType;
import jp.syuriken.snsw.twclient.config.ConfigFrameBuilder;
import jp.syuriken.snsw.twclient.config.IntegerConfigType;
import jp.syuriken.snsw.twclient.filter.FilterCompiler;
import jp.syuriken.snsw.twclient.filter.FilterConfigurator;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.UserFilter;
import jp.syuriken.snsw.twclient.filter.func.AndFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.ExtractFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.IfFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.InRetweetFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.NotFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.OneOfFilterFunction;
import jp.syuriken.snsw.twclient.filter.func.OrFilterFunction;
import jp.syuriken.snsw.twclient.filter.prop.InListProperty;
import jp.syuriken.snsw.twclient.filter.prop.StandardBooleanProperties;
import jp.syuriken.snsw.twclient.filter.prop.StandardIntProperties;
import jp.syuriken.snsw.twclient.filter.prop.StandardStringProperties;
import jp.syuriken.snsw.twclient.gui.ClientTab;
import jp.syuriken.snsw.twclient.gui.DirectMessageViewTab;
import jp.syuriken.snsw.twclient.gui.MentionViewTab;
import jp.syuriken.snsw.twclient.gui.TimelineViewTab;
import jp.syuriken.snsw.twclient.gui.UserInfoFrameTab;
import jp.syuriken.snsw.twclient.handler.AccountVerifierActionHandler;
import jp.syuriken.snsw.twclient.handler.ClearPostBoxActionHandler;
import jp.syuriken.snsw.twclient.handler.FavoriteActionHandler;
import jp.syuriken.snsw.twclient.handler.HashtagActionHandler;
import jp.syuriken.snsw.twclient.handler.ListActionHandler;
import jp.syuriken.snsw.twclient.handler.MenuPropertyEditorActionHandler;
import jp.syuriken.snsw.twclient.handler.MenuQuitActionHandler;
import jp.syuriken.snsw.twclient.handler.MuteActionHandler;
import jp.syuriken.snsw.twclient.handler.OpenImageActionHandler;
import jp.syuriken.snsw.twclient.handler.PostActionHandler;
import jp.syuriken.snsw.twclient.handler.QuoteTweetActionHandler;
import jp.syuriken.snsw.twclient.handler.ReloginActionHandler;
import jp.syuriken.snsw.twclient.handler.RemoveTweetActionHandler;
import jp.syuriken.snsw.twclient.handler.ReplyActionHandler;
import jp.syuriken.snsw.twclient.handler.RetweetActionHandler;
import jp.syuriken.snsw.twclient.handler.SearchActionHandler;
import jp.syuriken.snsw.twclient.handler.TweetActionHandler;
import jp.syuriken.snsw.twclient.handler.UnofficialRetweetActionHandler;
import jp.syuriken.snsw.twclient.handler.UrlActionHandler;
import jp.syuriken.snsw.twclient.handler.UserInfoViewActionHandler;
import jp.syuriken.snsw.twclient.init.DynamicInitializeService;
import jp.syuriken.snsw.twclient.init.InitCondition;
import jp.syuriken.snsw.twclient.init.InitializeException;
import jp.syuriken.snsw.twclient.init.InitializeService;
import jp.syuriken.snsw.twclient.init.Initializer;
import jp.syuriken.snsw.twclient.init.InitializerInstance;
import jp.syuriken.snsw.twclient.internal.MenuConfiguratorActionHandler;
import jp.syuriken.snsw.twclient.internal.NotifySendMessageNotifier;
import jp.syuriken.snsw.twclient.internal.TrayIconMessageNotifier;
import jp.syuriken.snsw.twclient.jni.LibnotifyMessageNotifier;
import jp.syuriken.snsw.twclient.net.DirectMessageFetcherFactory;
import jp.syuriken.snsw.twclient.net.MentionsFetcherFactory;
import jp.syuriken.snsw.twclient.net.StreamFetcherFactory;
import jp.syuriken.snsw.twclient.net.TimelineFetcherFactory;
import jp.syuriken.snsw.twclient.net.TwitterDataFetchScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.auth.AccessToken;

public class TwitterClientMain {
    protected static final String CONFIG_FILE_NAME = "elnetw.cfg";
    public static final int JOBWORKER_JOIN_TIMEOUT = 32;
    @InitializerInstance
    private static volatile TwitterClientMain SINGLETON;
    protected final ClientConfiguration configuration;
    private final Thread MAIN_THREAD;
    protected ClientProperties configProperties;
    protected Object threadHolder = new Object();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Getopt getopt;
    protected JobWorkerThread jobWorkerThread;
    protected boolean debugMode;
    protected boolean portable;
    protected TwitterDataFetchScheduler fetchScheduler;
    protected TwitterClientFrame frame;
    private boolean isInterrupted;

    public static synchronized TwitterClientMain getInstance(String[] args, ClassLoader classLoader) {
        if (SINGLETON != null) {
            throw new IllegalStateException("another instance always seems to be running");
        }
        SINGLETON = new TwitterClientMain(args, classLoader);
        return SINGLETON;
    }

    public static synchronized void quit() {
        if (SINGLETON == null) {
            throw new IllegalStateException("no instance running!");
        }
        TwitterClientMain.SINGLETON.isInterrupted = true;
        TwitterClientMain.SINGLETON.MAIN_THREAD.interrupt();
    }

    private TwitterClientMain(String[] args, ClassLoader classLoader) {
        this.MAIN_THREAD = Thread.currentThread();
        this.configuration = ClientConfiguration.getInstance();
        this.configuration.setExtraClassLoader(classLoader);
        this.configuration.setOpts(args);
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("debug", 0, null, 100)};
        this.getopt = new Getopt("elnetw", args, "dL:D:", longOpts);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            this.logger.warn("LookAndFeel\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Throwable)e);
        }
    }

    @Initializer(name="internal-addClientTabConstructor", phase="init")
    public void addClientTabConstructor() {
        ClientConfiguration.putClientTabConstructor("timeline", TimelineViewTab.class);
        ClientConfiguration.putClientTabConstructor("mention", MentionViewTab.class);
        ClientConfiguration.putClientTabConstructor("directmessage", DirectMessageViewTab.class);
        ClientConfiguration.putClientTabConstructor("userinfo", UserInfoFrameTab.class);
    }

    @Initializer(name="internal-addConfigurator-filter", dependencies={"init-gui", "configBuilder"}, phase="init")
    public void addConfiguratorOfFilter() {
        this.configuration.getConfigBuilder().getGroup("\u30d5\u30a3\u30eb\u30bf").addConfig("<ignore>", "\u30d5\u30a3\u30eb\u30bf\u306e\u7de8\u96c6", "", new FilterConfigurator(this.configuration));
    }

    @Initializer(name="actionHandler", phase="init")
    public void initActionHandlerTable() {
        this.configuration.addActionHandler("reply", new ReplyActionHandler());
        this.configuration.addActionHandler("qt", new QuoteTweetActionHandler());
        this.configuration.addActionHandler("unofficial_rt", new UnofficialRetweetActionHandler());
        this.configuration.addActionHandler("rt", new RetweetActionHandler());
        this.configuration.addActionHandler("fav", new FavoriteActionHandler());
        this.configuration.addActionHandler("remove", new RemoveTweetActionHandler());
        this.configuration.addActionHandler("userinfo", new UserInfoViewActionHandler());
        this.configuration.addActionHandler("url", new UrlActionHandler());
        this.configuration.addActionHandler("clear", new ClearPostBoxActionHandler());
        this.configuration.addActionHandler("post", new PostActionHandler());
        this.configuration.addActionHandler("mute", new MuteActionHandler());
        this.configuration.addActionHandler("tweet", new TweetActionHandler());
        this.configuration.addActionHandler("list", new ListActionHandler());
        this.configuration.addActionHandler("hashtag", new HashtagActionHandler());
        this.configuration.addActionHandler("search", new SearchActionHandler());
        this.configuration.addActionHandler("openimg", new OpenImageActionHandler());
        this.configuration.addActionHandler("menu_quit", new MenuQuitActionHandler());
        this.configuration.addActionHandler("menu_propeditor", new MenuPropertyEditorActionHandler());
        this.configuration.addActionHandler("menu_account_verify", new AccountVerifierActionHandler());
        this.configuration.addActionHandler("menu_login_read", new ReloginActionHandler(false));
        this.configuration.addActionHandler("menu_login_write", new ReloginActionHandler(true));
        this.configuration.addActionHandler("menu_config", new MenuConfiguratorActionHandler());
    }

    @Initializer(name="cacheManager", dependencies={"config", "twitterAccountId"}, phase="init")
    public void initCacheManager() {
        this.configuration.setCacheManager(new CacheManager(this.configuration));
    }

    @Initializer(name="configBuilder", phase="preinit")
    public void initConfigBuilder() {
        this.configuration.setConfigBuilder(new ConfigFrameBuilder(this.configuration));
    }

    @Initializer(name="configurator", dependencies={"init-gui", "configBuilder"}, phase="init")
    public void initConfigurator() {
        ConfigFrameBuilder configBuilder = this.configuration.getConfigBuilder();
        configBuilder.getGroup("Twitter").getSubgroup("\u53d6\u5f97\u9593\u9694 (\u79d2)").addConfig("twitter.timeline.interval", "\u30bf\u30a4\u30e0\u30e9\u30a4\u30f3", "\u79d2\u6570", new IntegerConfigType(60, 3600)).addConfig("twitter.mention.interval", "\u30e1\u30f3\u30b7\u30e7\u30f3(@\u901a\u77e5)", "\u79d2\u6570", new IntegerConfigType(60, 3600)).addConfig("twitter.dm.interval", "\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8", "\u79d2\u6570", new IntegerConfigType(60, 10800)).getParentGroup().getSubgroup("\u53d6\u5f97\u6570 (\u30c4\u30a4\u30fc\u30c8\u6570)").addConfig("twitter.timeline.count", "\u30bf\u30a4\u30e0\u30e9\u30a4\u30f3", "\u30c4\u30a4\u30fc\u30c8", new IntegerConfigType(1, 200)).addConfig("twitter.mention.count", "\u30e1\u30f3\u30b7\u30e7\u30f3(@\u901a\u77e5)", "\u30c4\u30a4\u30fc\u30c8", new IntegerConfigType(1, 200)).addConfig("twitter.dm.count", "\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8", "\u30e1\u30c3\u30bb\u30fc\u30b8", new IntegerConfigType(1, 200));
        configBuilder.getGroup("UI").addConfig("gui.interval.list_update", "UI\u66f4\u65b0\u9593\u9694 (\u30df\u30ea\u79d2)", "\u30df\u30ea\u79d2(ms)", new IntegerConfigType(100, 5000)).addConfig("gui.list.scroll", "\u30b9\u30af\u30ed\u30fc\u30eb\u91cf", null, new IntegerConfigType(1, 100));
        configBuilder.getGroup("core").addConfig("core.info.survive_time", "\u4e00\u6642\u7684\u306a\u60c5\u5831\u3092\u8868\u793a\u3059\u308b\u6642\u9593 (\u30c4\u30a4\u30fc\u30c8\u306e\u524a\u9664\u901a\u77e5\u306a\u3069)", "\u79d2", new IntegerConfigType(1, 60, 1000)).addConfig("core.match.id_strict_match", "\u30ea\u30d7\u30e9\u30a4\u5224\u5b9a\u6642\u306eID\u306e\u53b3\u683c\u306a\u4e00\u81f4", "\u30c1\u30a7\u30c3\u30af\u304c\u5165\u3063\u3066\u3044\u306a\u3044\u3068\u304d\u306f\u5148\u982d\u4e00\u81f4\u306b\u306a\u308a\u307e\u3059", new BooleanConfigType());
        configBuilder.getGroup("\u9ad8\u5ea6\u306a\u8a2d\u5b9a").addConfig(null, "\u8a2d\u5b9a\u3092\u76f4\u63a5\u7de8\u96c6\u3059\u308b (\u52d5\u4f5c\u4fdd\u8a3c\u5bfe\u8c61\u5916\u3067\u3059)", null, new ActionButtonConfigType("\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30a8\u30c7\u30a3\u30bf\u30fc\u3092\u958b\u304f...", "menu_propeditor", this.frame));
    }

    @Initializer(name="filter-functions", phase="preinit")
    public void initFilterFunctions() {
        FilterCompiler.putFilterFunction("or", OrFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("exactly_one_of", OneOfFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("and", AndFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("not", NotFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("extract", ExtractFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("inrt", InRetweetFilterFunction.getFactory());
        FilterCompiler.putFilterFunction("if", IfFilterFunction.getFactory());
    }

    @Initializer(name="filter-properties", phase="preinit")
    public void initFilterProperties() {
        Constructor<? extends FilterProperty> properties = StandardIntProperties.getFactory();
        FilterCompiler.putFilterProperty("userid", properties);
        FilterCompiler.putFilterProperty("in_reply_to_userid", properties);
        FilterCompiler.putFilterProperty("rtcount", properties);
        FilterCompiler.putFilterProperty("timediff", properties);
        properties = StandardBooleanProperties.getFactory();
        FilterCompiler.putFilterProperty("retweeted", properties);
        FilterCompiler.putFilterProperty("mine", properties);
        FilterCompiler.putFilterProperty("protected", properties);
        FilterCompiler.putFilterProperty("verified", properties);
        FilterCompiler.putFilterProperty("status", properties);
        FilterCompiler.putFilterProperty("dm", properties);
        properties = StandardStringProperties.getFactory();
        FilterCompiler.putFilterProperty("user", properties);
        FilterCompiler.putFilterProperty("text", properties);
        FilterCompiler.putFilterProperty("client", properties);
        FilterCompiler.putFilterProperty("in_list", InListProperty.getFactory());
    }

    @Initializer(name="init-gui", dependencies={"cacheManager", "twitterAccountId"}, phase="init")
    public void initFrame() {
        this.frame = new TwitterClientFrame(this.configuration);
    }

    @Initializer(name="imageCacher", dependencies={"config"}, phase="init")
    public void initImageCacher() {
        this.configuration.setImageCacher(new ImageCacher(this.configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer(name="shortcutKey", dependencies={"init-gui"}, phase="init")
    public void initShortcutKey() {
        File file;
        String parentConfigName = this.configProperties.getProperty("gui.shortcutkey.parent");
        Properties shortcutkeyProperties = new Properties();
        if (!parentConfigName.trim().isEmpty()) {
            InputStream stream = null;
            try {
                stream = TwitterClientMain.class.getResourceAsStream("shortcutkey/" + parentConfigName + ".properties");
                shortcutkeyProperties.load(stream);
            }
            catch (IOException e) {
                this.logger.error("\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\u30ad\u30fc\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557", (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Failed closing resource", (Throwable)e);
                    }
                }
            }
        }
        if ((file = new File(this.configuration.getConfigRootDir(), "shortcutkey.cfg")).exists()) {
            FileInputStream inputStream = null;
            Reader reader = null;
            try {
                inputStream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                shortcutkeyProperties.load(reader);
            }
            catch (FileNotFoundException e) {
                this.logger.error("\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\u30ad\u30fc\u30d5\u30a1\u30a4\u30eb\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error("\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\u30ad\u30fc\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557", (Throwable)e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn("shortcutkey.cfg\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557", (Throwable)e);
                }
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn("shortcutkey.cfg\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557", (Throwable)e);
                }
            }
        }
        for (Object obj : shortcutkeyProperties.keySet()) {
            String key = (String)obj;
            this.frame.addShortcutKey(key, shortcutkeyProperties.getProperty(key));
        }
    }

    @Initializer(name="internal-init-fetchSched", dependencies={"recover-clientTabs"}, phase="prestart")
    public void realConnectFetchSched() {
        this.fetchScheduler.onInitialized();
    }

    @Initializer(name="recover-clientTabs", phase="prestart")
    public void recoverClientTabs() {
        String tabsList = this.configProperties.getProperty("gui.tabs.list");
        if (tabsList == null) {
            try {
                this.configuration.addFrameTab(new TimelineViewTab());
                this.configuration.addFrameTab(new MentionViewTab());
                this.configuration.addFrameTab(new DirectMessageViewTab());
            }
            catch (IllegalSyntaxException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            String[] tabs;
            for (String tabIndetifier : tabs = tabsList.split(" ")) {
                if (tabIndetifier.isEmpty()) continue;
                int separatorPosition = tabIndetifier.indexOf(58);
                String tabId = tabIndetifier.substring(0, separatorPosition);
                String uniqId = tabIndetifier.substring(separatorPosition + 1);
                Constructor<? extends ClientTab> tabConstructor = ClientConfiguration.getClientTabConstructor(tabId);
                if (tabConstructor == null) {
                    this.logger.warn("\u30bf\u30d6\u304c\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093: tabId={}, uniqId={}", (Object)tabId, (Object)uniqId);
                    continue;
                }
                try {
                    ClientTab tab = tabConstructor.newInstance(this.configProperties.getProperty("gui.tabs.data." + uniqId));
                    this.configuration.addFrameTab(tab);
                }
                catch (IllegalArgumentException e) {
                    this.logger.error("\u30bf\u30d6\u304c\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093: \u30bf\u30d6\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002tabId=" + tabId, (Throwable)e);
                }
                catch (InstantiationException e) {
                    this.logger.error("\u30bf\u30d6\u304c\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093: \u30bf\u30d6\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002tabId=" + tabId, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("\u30bf\u30d6\u304c\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093: \u6b63\u3057\u304f\u306a\u3044\u30a2\u30af\u30bb\u30b9\u6307\u5b9a\u5b50\u3067\u3059\u3002tabId=" + tabId, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.logger.error("\u30bf\u30d6\u304c\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093: \u521d\u671f\u5316\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002tabId=" + tabId, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        int c;
        Getopt getopt = this.getopt;
        this.portable = Boolean.getBoolean("config.portable");
        this.debugMode = false;
        block13: while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 100: {
                    this.portable = true;
                    this.debugMode = true;
                    continue block13;
                }
                case 68: 
                case 76: {
                    continue block13;
                }
            }
        }
        this.setDebugLogger();
        DynamicInitializeService initializeService = DynamicInitializeService.use(this.configuration);
        ((InitializeService)initializeService).registerPhase("earlyinit").registerPhase("preinit").registerPhase("init").registerPhase("postinit").registerPhase("prestart").registerPhase("start").register(TwitterClientMain.class);
        try {
            ((InitializeService)initializeService).enterPhase("earlyinit").enterPhase("preinit").enterPhase("init").enterPhase("postinit").enterPhase("prestart").enterPhase("start");
        }
        catch (InitializeException e) {
            this.logger.error("failed initialization", (Throwable)e);
            return e.getExitCode();
        }
        this.logger.info("Initialized");
        Object e = this.threadHolder;
        synchronized (e) {
            try {
                while (!this.isInterrupted) {
                    this.threadHolder.wait();
                }
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
        try {
            ((InitializeService)initializeService).uninit();
        }
        catch (InitializeException e2) {
            this.logger.error("failed quitting", (Throwable)e2);
            return e2.getExitCode();
        }
        return 0;
    }

    @Initializer(name="twitterAccountId", dependencies={"config"}, phase="earlyinit")
    public void setAccountId() {
        String defaultAccountId = this.configuration.getDefaultAccountId();
        this.configuration.setAccountIdForRead(defaultAccountId);
        this.configuration.setAccountIdForWrite(defaultAccountId);
    }

    @Initializer(name="config", dependencies={"default-config"}, phase="earlyinit")
    public void setConfigProperties(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            this.configProperties = new ClientProperties(this.configuration.getConfigDefaultProperties());
            File configFile = new File(this.configuration.getConfigRootDir(), CONFIG_FILE_NAME);
            this.configProperties.setStoreFile(configFile);
            if (configFile.exists()) {
                this.logger.debug("elnetw.cfg is found.");
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8");
                    this.configProperties.load(reader);
                }
                catch (IOException e) {
                    this.logger.warn("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc", (Throwable)e);
                }
            }
            this.configuration.setConfigProperties(this.configProperties);
            String configVersion = this.configProperties.getProperty("cfg.version", "0");
            InitializeService.getService().provideInitializer("config-v" + configVersion, true);
        } else {
            this.configProperties.store();
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void setConfigRootDirPermission(File configRootDir) {
        configRootDir.setReadable(false, false);
        configRootDir.setWritable(false, false);
        configRootDir.setExecutable(false, false);
        configRootDir.setReadable(true, true);
        configRootDir.setWritable(true, true);
        configRootDir.setExecutable(true, true);
    }

    private void setDebugLogger() {
        if (this.debugMode) {
            URL resource = TwitterClientMain.class.getResource("/logback-debug.xml");
            if (resource == null) {
                this.logger.error("resource /logback-debug.xml is not found");
            } else {
                LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
                try {
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext((Context)context);
                    context.reset();
                    configurator.doConfigure(resource);
                }
                catch (JoranException joranException) {
                    // empty catch block
                }
            }
        }
    }

    @Initializer(name="default-config", dependencies={"internal-portableConfig"}, phase="earlyinit")
    public void setDefaultConfigProperties() {
        ClientProperties defaultConfig = new ClientProperties();
        try {
            InputStream stream = TwitterClientMain.class.getResourceAsStream("config.properties");
            if (stream == null) {
                this.logger.error("\u30ea\u30bd\u30fc\u30b9(default) config.properties \u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
            } else {
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                defaultConfig.load(reader);
            }
        }
        catch (IOException e) {
            this.logger.error("\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", (Throwable)e);
        }
        this.configuration.setConfigDefaultProperties(defaultConfig);
    }

    @Initializer(name="set-globalfilter", dependencies={"config", "filter-functions", "filter-properties"}, phase="init")
    public void setDefaultFilter() {
        this.configuration.addFilter(new UserFilter(this.configuration));
    }

    @Initializer(name="fetch-sched", dependencies={"set-globalfilter", "cacheManager"}, phase="init")
    public void setFetchScheduler(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            this.fetchScheduler = new TwitterDataFetchScheduler();
            this.configuration.setFetchScheduler(this.fetchScheduler);
        } else {
            this.fetchScheduler.cleanUp();
        }
    }

    @Initializer(name="set-fetchsched-notifier", dependencies={"fetch-sched"}, phase="init")
    public void setFetcherFactory() {
        this.fetchScheduler.addVirtualNotifier("my/timeline", new String[]{"stream/user", "statuses/timeline"});
        this.fetchScheduler.addFetcherFactory("stream/user", new StreamFetcherFactory());
        this.fetchScheduler.addFetcherFactory("statuses/timeline", new TimelineFetcherFactory());
        this.fetchScheduler.addFetcherFactory("statuses/mentions", new MentionsFetcherFactory());
        this.fetchScheduler.addFetcherFactory("direct_messages", new DirectMessageFetcherFactory());
    }

    @Initializer(name="finish-initPhase", phase="start")
    public void setInitializePhaseFinished() {
        this.configuration.setInitializing(false);
        this.fetchScheduler.onInitialized();
    }

    @Initializer(name="internal-messageNotifiers", phase="prestart")
    public void setMessageNotifiersCandidate() {
        Utility.addMessageNotifier(2000, LibnotifyMessageNotifier.class);
        Utility.addMessageNotifier(1000, NotifySendMessageNotifier.class);
        Utility.addMessageNotifier(0, TrayIconMessageNotifier.class);
    }

    @Initializer(name="internal-portableConfig", phase="earlyinit")
    public void setPortabledConfigDir() {
        this.configuration.setPortabledConfiguration(this.portable);
        File configRootDir = new File(this.configuration.getConfigRootDir());
        if (!this.portable && !configRootDir.exists()) {
            if (configRootDir.mkdirs()) {
                this.setConfigRootDirPermission(configRootDir);
            } else {
                this.logger.warn("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f: {}", (Object)configRootDir.getPath());
            }
        }
    }

    @Initializer(name="timer", phase="earlyinit")
    public void setTimer(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            this.configuration.setTimer(Executors.newSingleThreadScheduledExecutor());
        } else {
            ScheduledExecutorService timer = this.configuration.getTimer();
            timer.shutdown();
            try {
                if (!timer.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.logger.error("Failed shutdown timer: timeout");
                    timer.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                timer.shutdownNow();
            }
        }
    }

    @Initializer(name="show-trayicon", phase="start")
    public void setTrayIcon(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            if (SystemTray.isSupported()) {
                try {
                    SystemTray.getSystemTray().add(this.configuration.getTrayIcon());
                }
                catch (AWTException e) {
                    this.logger.warn("SystemTray\u3078\u306e\u8ffd\u52a0\u306b\u5931\u6557", (Throwable)e);
                }
            }
        } else if (SystemTray.isSupported()) {
            SystemTray.getSystemTray().remove(this.configuration.getTrayIcon());
        }
    }

    @Initializer(name="tray", phase="prestart")
    public void setTrayIcon() {
        try {
            this.configuration.setTrayIcon(new TrayIcon(ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("jp/syuriken/snsw/twclient/img/icon16.png")), "elnetw"));
        }
        catch (IOException e) {
            this.logger.error("icon \u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3002");
        }
    }

    @Initializer(name="show-gui", phase="start")
    public void showFrame(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TwitterClientMain.this.frame.start();
                }
            });
        } else {
            this.logger.info("Exiting elnetw...");
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TwitterClientMain.this.frame.setVisible(false);
                        TwitterClientMain.this.frame.dispose();
                    }
                });
            }
            catch (InterruptedException e) {
                this.logger.error("interrupted while closing frame", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("Caught error", e.getCause());
            }
        }
    }

    @Initializer(name="jobqueue", dependencies={"config"}, phase="preinit")
    public void startJobWorkerThread(InitCondition cond) {
        if (cond.isInitializingPhase()) {
            this.jobWorkerThread = new JobWorkerThread(this.configuration.getJobQueue());
            this.jobWorkerThread.start();
        } else {
            this.jobWorkerThread.cleanUp();
            block2: while (true) {
                try {
                    while (true) {
                        this.jobWorkerThread.join(32L);
                        if (!this.jobWorkerThread.isAlive()) break block2;
                        this.jobWorkerThread.cleanUp();
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    @Initializer(name="accesstoken", dependencies={"config"}, phase="earlyinit")
    public void tryGetOAuthAccessToken(InitCondition cond) {
        String userId;
        AccessToken accessToken;
        Twitter twitter;
        if (!cond.isInitializingPhase()) {
            return;
        }
        if (this.configuration.getAccountList().length != 0) {
            return;
        }
        try {
            while ((twitter = new OAuthHelper(this.configuration).show()) == null) {
                int button = JOptionPane.showConfirmDialog(null, "\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f", "elnetw", 0, 3);
                if (button != 0) continue;
                cond.setFailStatus("OAuth failed: canceled", -1);
                return;
            }
            accessToken = twitter.getOAuthAccessToken();
        }
        catch (TwitterException e) {
            cond.setFailStatus("error", 1);
            return;
        }
        try {
            userId = String.valueOf(twitter.getId());
        }
        catch (TwitterException e) {
            JOptionPane.showMessageDialog(null, "\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6642\u9593\u3092\u304a\u3044\u3066\u8a66\u3057\u3066\u307f\u3066\u4e0b\u3055\u3044: " + e.getLocalizedMessage(), "\u30a8\u30e9\u30fc", 0);
            throw new RuntimeException(e);
        }
        this.configProperties.setProperty("twitter.oauth.access_token.list", userId);
        this.configProperties.setProperty("twitter.oauth.access_token.default", userId);
        this.configuration.storeAccessToken(accessToken);
        this.configProperties.store();
    }

    @Initializer(name="config-v1", dependencies={"config-v0"}, phase="earlyinit")
    public void updateConfigToV1() {
        this.logger.info("Updating config to v1");
        this.configProperties.setProperty("cfg.version", "1");
    }

    @Initializer(name="config-v2", dependencies={"config-v1"}, phase="earlyinit")
    public void updateConfigToV2() {
        this.logger.info("Updating config to v2");
        if (this.configProperties.containsKey("twitter.timeline.interval")) {
            this.configProperties.setInteger("twitter.timeline.interval", this.configProperties.getInteger("twitter.timeline.interval") / 1000);
        }
        this.configProperties.setProperty("cfg.version", "2");
    }
}

