/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Date;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.TwitterExtendedObject;
import jp.syuriken.snsw.twclient.TwitterUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.Place;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.SymbolEntity;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.DataObjectFactory;

public class TwitterStatus
implements Status,
TwitterExtendedObject {
    private static final long serialVersionUID = -188757917578787367L;
    private static final Logger logger = LoggerFactory.getLogger(TwitterStatus.class);
    private final long[] contributors;
    private final Date createdAt;
    private final long id;
    private final long inReplyToStatusId;
    private final long inReplyToUserId;
    private final boolean isTruncated;
    private final TwitterStatus retweetedStatus;
    private final User user;
    private GeoLocation geoLocation;
    private HashtagEntity[] hashtagEntities;
    private String inReplyToScreenName;
    private boolean loadedInitialization;
    private MediaEntity[] mediaEntities;
    private Place place;
    private String source;
    private String text;
    private URLEntity[] urlEntities;
    private UserMentionEntity[] userMentionEntities;
    private volatile boolean favorited;
    private volatile int retweetCount;
    private volatile boolean retweetedByMe;
    private boolean possiblySensitive;
    private long currentUserRetweetId;
    private boolean retweeted;
    private int favoriteCount;
    private String isoLanguageCode;
    private SymbolEntity[] symbolEntities;

    private static JSONObject getJsonObject(Status originalStatus) throws AssertionError {
        String json = DataObjectFactory.getRawJSON((Object)originalStatus);
        JSONObject jsonObject = null;
        if (json != null) {
            try {
                jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                logger.error("Cannot parse json", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
        return jsonObject;
    }

    public TwitterStatus(Status originalStatus) {
        this(originalStatus, TwitterStatus.getJsonObject(originalStatus));
    }

    public TwitterStatus(Status originalStatus, JSONObject jsonObject) {
        this.favorited = originalStatus.isFavorited();
        this.retweetedByMe = originalStatus.isRetweetedByMe();
        this.urlEntities = originalStatus.getURLEntities();
        this.hashtagEntities = originalStatus.getHashtagEntities();
        this.mediaEntities = originalStatus.getMediaEntities();
        this.userMentionEntities = originalStatus.getUserMentionEntities();
        this.text = originalStatus.getText();
        this.createdAt = originalStatus.getCreatedAt();
        this.id = originalStatus.getId();
        this.source = originalStatus.getSource();
        this.isTruncated = originalStatus.isTruncated();
        this.inReplyToStatusId = originalStatus.getInReplyToStatusId();
        this.inReplyToUserId = originalStatus.getInReplyToUserId();
        this.favorited = originalStatus.isFavorited();
        this.inReplyToScreenName = originalStatus.getInReplyToScreenName();
        this.geoLocation = originalStatus.getGeoLocation();
        this.place = originalStatus.getPlace();
        this.retweetCount = originalStatus.getRetweetCount();
        this.retweetedByMe = originalStatus.isRetweetedByMe();
        this.contributors = originalStatus.getContributors();
        this.user = this.getCachedUser(originalStatus.getUser());
        this.possiblySensitive = originalStatus.isPossiblySensitive();
        this.currentUserRetweetId = originalStatus.getCurrentUserRetweetId();
        this.retweeted = originalStatus.isRetweeted();
        this.favoriteCount = originalStatus.getFavoriteCount();
        this.isoLanguageCode = originalStatus.getIsoLanguageCode();
        this.symbolEntities = originalStatus.getSymbolEntities();
        Status retweetedStatus = originalStatus.getRetweetedStatus();
        if (!(originalStatus instanceof TwitterStatus) && retweetedStatus != null && !(retweetedStatus instanceof TwitterStatus)) {
            TwitterStatus status;
            CacheManager cacheManager = ClientConfiguration.getInstance().getCacheManager();
            Status cachedStatus = cacheManager.getCachedStatus(retweetedStatus.getId());
            if (!(cachedStatus != null && cachedStatus instanceof TwitterStatus || (cachedStatus = cacheManager.cacheStatusIfAbsent(status = new TwitterStatus(retweetedStatus))) != null)) {
                cachedStatus = status;
            }
            retweetedStatus = cachedStatus;
        }
        this.retweetedStatus = (TwitterStatus)retweetedStatus;
    }

    public int compareTo(Status b) {
        long thisId = this.id;
        long thatId = b.getId();
        if (thisId < thatId) {
            return -1;
        }
        if (thisId > thatId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Status)) {
            return false;
        }
        return ((Status)obj).getId() == this.id;
    }

    public int getAccessLevel() {
        return -1;
    }

    private User getCachedUser(User user) {
        TwitterUser twitterUser;
        if (user instanceof TwitterUser) {
            return user;
        }
        CacheManager cacheManager = ClientConfiguration.getInstance().getCacheManager();
        User cachedUser = cacheManager.getCachedUser(user.getId());
        if (cachedUser == null && (cachedUser = cacheManager.cacheUserIfAbsent(twitterUser = new TwitterUser(user))) == null) {
            cachedUser = twitterUser;
        }
        return cachedUser;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public long[] getContributors() {
        return this.contributors;
    }

    public Date getCreatedAt() {
        return (Date)this.createdAt.clone();
    }

    public long getCurrentUserRetweetId() {
        return this.currentUserRetweetId;
    }

    public int getFavoriteCount() {
        return this.favoriteCount;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    public long getId() {
        return this.id;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getIsoLanguageCode() {
        return this.isoLanguageCode;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    public Place getPlace() {
        return this.place;
    }

    public RateLimitStatus getRateLimitStatus() {
        return null;
    }

    public int getRetweetCount() {
        return this.retweetCount;
    }

    public TwitterStatus getRetweetedStatus() {
        return this.retweetedStatus;
    }

    public String getSource() {
        return this.source;
    }

    public SymbolEntity[] getSymbolEntities() {
        return this.symbolEntities;
    }

    public String getText() {
        return this.text;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    public User getUser() {
        return this.user;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public boolean isLoadedInitialization() {
        return this.loadedInitialization;
    }

    public boolean isPossiblySensitive() {
        return this.possiblySensitive;
    }

    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    public boolean isRetweeted() {
        return this.retweeted;
    }

    public boolean isRetweetedByMe() {
        return this.retweetedByMe;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
    }

    public void setLoadedInitialization(boolean loadedInitialization) {
        this.loadedInitialization = loadedInitialization;
    }

    public void setRetweetedByMe(boolean retweetedByMe) {
        this.retweetedByMe = retweetedByMe;
    }

    public void update(Status status) {
        this.favorited = status.isFavorited();
        this.retweetedByMe = status.isRetweetedByMe();
        this.urlEntities = status.getURLEntities();
        this.hashtagEntities = status.getHashtagEntities();
        this.mediaEntities = status.getMediaEntities();
        this.userMentionEntities = status.getUserMentionEntities();
        this.text = status.getText();
        this.source = status.getSource();
        this.favorited = status.isFavorited();
        this.inReplyToScreenName = status.getInReplyToScreenName();
        this.geoLocation = status.getGeoLocation();
        this.place = status.getPlace();
        this.retweetCount = status.getRetweetCount();
        this.retweetedByMe = status.isRetweetedByMe();
        this.possiblySensitive = status.isPossiblySensitive();
        this.currentUserRetweetId = status.getCurrentUserRetweetId();
    }
}

