/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.MessageNotifier;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    public static final long SEC2MS = 1000L;
    public static final long MINUTE2MS = 60000L;
    public static final long HOUR2MS = 3600000L;
    public static final long DAY2MS = 86400000L;
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);
    private static final LinkedList<MessageNotifierEntry> messageNotifiers = new LinkedList();
    private static volatile OSType ostype;
    private static KVEntry[] privacyEntries;
    private static ThreadLocal<SimpleDateFormat> dateFormat;
    private final ClientConfiguration configuration;
    private String detectedBrowser = null;
    public volatile MessageNotifier notifySender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageNotifier(int priority, Class<? extends MessageNotifier> messageNotifierClass) {
        try {
            messageNotifierClass.getMethod("checkUsable", ClientConfiguration.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("messageNotifierClass must implement static method 'checkUsable(ClientConfiguration'", e);
        }
        try {
            messageNotifierClass.getConstructor(ClientConfiguration.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("messageNotifierClass must implement <init>(ClientConfiguration)", e);
        }
        LinkedList<MessageNotifierEntry> linkedList = messageNotifiers;
        synchronized (linkedList) {
            block9: {
                ListIterator<MessageNotifierEntry> listIterator = messageNotifiers.listIterator();
                while (listIterator.hasNext()) {
                    MessageNotifierEntry entry = (MessageNotifierEntry)listIterator.next();
                    int entryPriority = entry.priority;
                    if (entryPriority < priority) {
                        listIterator.previous();
                        listIterator.add(new MessageNotifierEntry(priority, messageNotifierClass));
                        break block9;
                    }
                    if (entryPriority != priority) continue;
                    --priority;
                }
                listIterator.add(new MessageNotifierEntry(priority, messageNotifierClass));
            }
        }
    }

    public static Color blendColor(Color target, Color source) {
        double alpha = (double)source.getAlpha() / 255.0;
        int newr = (int)((double)target.getRed() * (1.0 - alpha) + (double)source.getRed() * alpha);
        int newg = (int)((double)target.getGreen() * (1.0 - alpha) + (double)source.getGreen() * alpha);
        int newb = (int)((double)target.getBlue() * (1.0 - alpha) + (double)source.getBlue() * alpha);
        Color color = new Color(newr, newg, newb, target.getAlpha());
        return color;
    }

    private static void detectOS() {
        String osName = System.getProperty("os.name");
        ostype = osName.startsWith("Mac OS") ? OSType.MAC : (osName.startsWith("Windows") ? OSType.WINDOWS : OSType.OTHER);
    }

    public static SimpleDateFormat getDateFormat() {
        return dateFormat.get();
    }

    public static String getDateString(Date date, boolean html) {
        long timeDiff = System.currentTimeMillis() - date.getTime();
        String dateFormatted = dateFormat.get().format(date);
        if (timeDiff < 0L || timeDiff > 86400000L) {
            return dateFormatted;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (html) {
            stringBuilder.append("<html>");
        }
        if (timeDiff < 60000L) {
            stringBuilder.append(timeDiff / 1000L).append("\u79d2\u524d");
        } else if (timeDiff < 3600000L) {
            stringBuilder.append(timeDiff / 60000L).append("\u5206\u524d");
        } else {
            stringBuilder.append(timeDiff / 3600000L).append("\u6642\u9593\u524d");
        }
        stringBuilder.append(" (").append(dateFormatted).append(')');
        return stringBuilder.toString();
    }

    public static IntentArguments getIntentArguments(String actionCommand) {
        int argSeparatorIndex = actionCommand.indexOf(33);
        IntentArguments intentArguments = new IntentArguments(argSeparatorIndex < 0 ? actionCommand : actionCommand.substring(0, argSeparatorIndex));
        String argsString = actionCommand.substring(argSeparatorIndex + 1);
        if (!argsString.isEmpty()) {
            String[] args;
            for (String arg : args = (argSeparatorIndex < 0 ? "" : argsString).split(";")) {
                int kvSeparatorIndex = arg.indexOf(61);
                String name = kvSeparatorIndex < 0 ? "_arg" : arg.substring(0, kvSeparatorIndex);
                String value = kvSeparatorIndex < 0 ? arg : arg.substring(kvSeparatorIndex + 1);
                intentArguments.putExtra(name, value);
            }
        }
        return intentArguments;
    }

    private static String getKeyNameByChar(int character) {
        switch (character) {
            case 94: {
                return "%caret";
            }
            case 43: {
                return "%plus";
            }
            case 64: {
                return "%at";
            }
            case 61: {
                return "%equal";
            }
            case 44: {
                return "%colon";
            }
            case 32: {
                return "%space";
            }
            case 91: {
                return "%bracketstart";
            }
            case 93: {
                return "%bracketend";
            }
        }
        return null;
    }

    private static String getKeyNameByCode(int code) {
        switch (code) {
            case 10: {
                return "%return";
            }
            case 38: {
                return "%up";
            }
            case 40: {
                return "%down";
            }
            case 39: {
                return "%right";
            }
            case 37: {
                return "%left";
            }
            case 9: {
                return "%tab";
            }
            case 34: {
                return "%pagedown";
            }
            case 33: {
                return "%pageup";
            }
            case 36: {
                return "%home";
            }
            case 35: {
                return "%end";
            }
            case 112: {
                return "%F1";
            }
            case 113: {
                return "%F2";
            }
            case 114: {
                return "%F3";
            }
            case 115: {
                return "%F4";
            }
            case 116: {
                return "%F5";
            }
            case 117: {
                return "%F6";
            }
            case 118: {
                return "%F7";
            }
            case 119: {
                return "%F8";
            }
            case 120: {
                return "%F9";
            }
            case 121: {
                return "%F10";
            }
            case 122: {
                return "%F11";
            }
            case 123: {
                return "%F12";
            }
        }
        return null;
    }

    public static OSType getOstype() {
        if (ostype == null) {
            Utility.detectOS();
        }
        return ostype;
    }

    public static String protectPrivacy(String string) {
        return Utility.protectPrivacy(new StringBuilder(string)).toString();
    }

    public static StringBuilder protectPrivacy(StringBuilder builder) {
        for (KVEntry entry : privacyEntries) {
            String before = entry.key;
            String after = entry.value;
            int offset = 0;
            while (offset < builder.length() && (offset = builder.indexOf(before)) != -1) {
                int end = offset + before.length();
                builder.replace(offset, end, after);
            }
        }
        return builder;
    }

    public static String toKeyString(KeyEvent e) {
        String key;
        int keyCode;
        if (e.getID() == 400) {
            throw new IllegalArgumentException("KeyEvent.getID() must not be KEY_TYPED");
        }
        int modifiers = e.getModifiersEx();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(e.getID() == 402 ? "release(" : "press(");
        if ((modifiers & 0x80) != 0) {
            stringBuilder.append('^');
        }
        if ((modifiers & 0x200) != 0) {
            stringBuilder.append('@');
        }
        if ((keyCode = e.getKeyChar()) != 65535 && keyCode >= 32 && keyCode <= 126) {
            key = Utility.getKeyNameByChar(keyCode);
        } else {
            keyCode = e.getKeyCode();
            if ((modifiers & 0x40) != 0) {
                stringBuilder.append('+');
            }
            key = Utility.getKeyNameByCode(keyCode);
        }
        stringBuilder.append(key != null ? key : Character.valueOf((char)keyCode));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public Utility(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    protected String detectBrowser() {
        if (this.detectedBrowser != null) {
            return this.detectedBrowser;
        }
        String[] browsers = new String[]{"xdg-open", "firefox", "chrome", "opera", "konqueror", "epiphany", "mozilla"};
        String detectedBrowser = null;
        for (String browser : browsers) {
            try {
                if (Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() != 0) continue;
                detectedBrowser = browser;
                break;
            }
            catch (InterruptedException e2) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (detectedBrowser == null) {
            detectedBrowser = JOptionPane.showInputDialog(null, "Please input path-to-browser.", "elnetw", 1);
        }
        return detectedBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectNotifier() {
        if (this.notifySender == null) {
            LinkedList<MessageNotifierEntry> linkedList = messageNotifiers;
            synchronized (linkedList) {
                for (MessageNotifierEntry entry : messageNotifiers) {
                    Class<? extends MessageNotifier> messageNotifierClass = entry.messageNotifierClass;
                    try {
                        MessageNotifier messageNotifier;
                        Method checkUsableMethod = messageNotifierClass.getMethod("checkUsable", ClientConfiguration.class);
                        boolean usability = (Boolean)checkUsableMethod.invoke(null, this.configuration);
                        if (!usability) continue;
                        Constructor<? extends MessageNotifier> constructor = messageNotifierClass.getConstructor(ClientConfiguration.class);
                        this.notifySender = messageNotifier = constructor.newInstance(this.configuration);
                        logger.info("use {} as MessageNotifier", (Object)this.notifySender);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        logger.warn("#detectNotifier", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        logger.warn("#detectNotifier", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("#detectNotifier", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.warn("#detectNotifier", (Throwable)e);
                    }
                }
            }
        }
    }

    public Throwable openBrowser(String url) {
        Utility.detectOS();
        try {
            switch (ostype) {
                case WINDOWS: {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url.trim());
                    break;
                }
                case MAC: {
                    Class<?> fileMgr = null;
                    fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url.trim());
                    break;
                }
                case OTHER: {
                    String browser = this.detectBrowser();
                    Runtime.getRuntime().exec(new String[]{browser, url.trim()});
                    break;
                }
            }
            return null;
        }
        catch (Throwable ex) {
            logger.warn("Failed opening browser", ex);
            return ex;
        }
    }

    public void sendNotify(String summary, String text) {
        this.sendNotify(summary, text, null);
    }

    public void sendNotify(String summary, String text, File imageFile) {
        if (this.configuration.isInitializing()) {
            return;
        }
        this.detectNotifier();
        if (this.notifySender != null) {
            try {
                this.notifySender.sendNotify(summary, text, imageFile);
            }
            catch (IOException e) {
                logger.warn("\u901a\u77e5\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", (Throwable)e);
            }
        } else {
            logger.warn("\u6709\u52b9\u306aNotifier\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
        }
    }

    static {
        dateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            }
        };
        privacyEntries = new KVEntry[]{new KVEntry(System.getProperty("user.dir"), "{USER}/"), new KVEntry(System.getProperty("java.io.tmpdir"), "{TEMP}/"), new KVEntry(System.getProperty("user.home"), "{HOME}/")};
    }

    public static enum OSType {
        WINDOWS,
        MAC,
        OTHER;

    }

    private static class MessageNotifierEntry {
        protected int priority;
        protected Class<? extends MessageNotifier> messageNotifierClass;

        protected MessageNotifierEntry(int priority, Class<? extends MessageNotifier> messageNotifierClass) {
            this.priority = priority;
            this.messageNotifierClass = messageNotifierClass;
        }
    }

    private static class KVEntry {
        final String key;
        final String value;

        public KVEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

