/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.config;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.config.ConfigFrame;
import jp.syuriken.snsw.twclient.config.ConfigType;

public class ConfigFrameBuilder {
    private final ClientConfiguration configuration;
    private ArrayList<Config> configsList = new ArrayList();

    public ConfigFrameBuilder(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFrameBuilder addConfig(Config config) {
        ArrayList<Config> arrayList = this.configsList;
        synchronized (arrayList) {
            this.configsList.add(config);
        }
        return this;
    }

    public ConfigGroup getGroup(String group) {
        return new ConfigGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        Object[] configs;
        ArrayList<Config> arrayList = this.configsList;
        synchronized (arrayList) {
            configs = this.configsList.toArray(new Config[this.configsList.size()]);
        }
        Arrays.sort(configs);
        JFrame frame = ConfigFrame.build((Config[])configs, this.configuration);
        frame.setVisible(true);
    }

    public final class ConfigSubgroup {
        private final String subgroup;
        private final ConfigGroup group;

        ConfigSubgroup(ConfigGroup group, String subgroup) {
            this.group = group;
            this.subgroup = subgroup;
        }

        public ConfigSubgroup addConfig(String configKey, String description, String hint, ConfigType type) {
            ConfigFrameBuilder.this.addConfig(new Config(this.group.getGroupName(), this.subgroup, configKey, description, hint, type));
            return this;
        }

        public ConfigSubgroup addConfig(String configKey, String description, String hint, ConfigType type, int priority) {
            ConfigFrameBuilder.this.addConfig(new Config(this.group.getGroupName(), this.subgroup, configKey, description, hint, type, priority));
            return this;
        }

        public String getGroupName() {
            return this.group.getGroupName();
        }

        public ConfigGroup getParentGroup() {
            return this.group;
        }

        public String getSubgroupName() {
            return this.subgroup;
        }
    }

    public final class ConfigGroup {
        private final String group;

        ConfigGroup(String group) {
            this.group = group;
        }

        public ConfigGroup addConfig(String configKey, String description, String hint, ConfigType type) {
            ConfigFrameBuilder.this.addConfig(new Config(this.group, null, configKey, description, hint, type));
            return this;
        }

        public ConfigGroup addConfig(String configKey, String description, String hint, ConfigType type, int priority) {
            ConfigFrameBuilder.this.addConfig(new Config(this.group, null, configKey, description, hint, type, priority));
            return this;
        }

        public ConfigFrameBuilder getBuilder() {
            return ConfigFrameBuilder.this;
        }

        public String getGroupName() {
            return this.group;
        }

        public ConfigSubgroup getSubgroup(String subgroup) {
            return new ConfigSubgroup(this, subgroup);
        }
    }

    public static class Config
    implements Comparable<Config> {
        private final String group;
        private final String subgroup;
        private final String configKey;
        private final String description;
        private final String hint;
        private final ConfigType type;
        private final int priority;

        public Config(String group, String subgroup, String configKey, String description, ConfigType type) {
            this(group, subgroup, configKey, description, null, type);
        }

        public Config(String group, String subgroup, String configKey, String description, String hint, ConfigType type) {
            this(group, subgroup, configKey, description, hint, type, 0);
        }

        public Config(String group, String subgroup, String configKey, String description, String hint, ConfigType type, int priority) {
            if (group == null || description == null || type == null) {
                throw new IllegalArgumentException("group, description, type must not be null");
            }
            this.group = group;
            this.subgroup = subgroup;
            this.configKey = configKey;
            this.description = description;
            this.hint = hint;
            this.type = type;
            this.priority = priority;
        }

        @Override
        public int compareTo(Config o) {
            int result = this.group.compareTo(o.group);
            if (result == 0) {
                result = this.subgroup == null && o.subgroup == null ? 0 : (this.subgroup == null || o.subgroup == null ? (this.subgroup == null ? -1 : 1) : this.subgroup.compareTo(o.subgroup));
            }
            if (result == 0) {
                result = o.getPriority() - this.getPriority();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Config)) {
                return false;
            }
            return this.compareTo((Config)obj) == 0;
        }

        public String getConfigKey() {
            return this.configKey;
        }

        public String getDescription() {
            return this.description;
        }

        public String getGroup() {
            return this.group;
        }

        public String getHint() {
            return this.hint;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getSubgroup() {
            return this.subgroup;
        }

        public ConfigType getType() {
            return this.type;
        }

        public int hashCode() {
            int h = this.group.hashCode();
            h = h * 31 + this.subgroup.hashCode();
            h = h * 31 + this.priority;
            return h;
        }
    }
}

