/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.config.ConfigFrame;
import jp.syuriken.snsw.twclient.config.ConfigType;
import jp.syuriken.snsw.twclient.filter.FilterEditFrame;
import jp.syuriken.snsw.twclient.gui.ClientTab;

public class FilterConfigurator
implements ConfigType,
ActionListener {
    private JComboBox<KVItem> filterChooser;
    private ClientConfiguration configuration;
    private JButton editButton;

    public FilterConfigurator(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox<KVItem> componentFilterChooser = this.getComponentFilterChooser();
        KVItem kvItem = (KVItem)componentFilterChooser.getSelectedItem();
        FilterEditFrame editFrame = new FilterEditFrame(this.configuration, kvItem.displayString, kvItem.propertyKey);
        editFrame.setVisible(true);
        editFrame.toFront();
    }

    @Override
    public JComponent getComponent(String configKey, String nowValue, ConfigFrame listener) {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getComponentFilterChooser()).addComponent(this.getComponentEditButton(), GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getComponentFilterChooser()).addComponent(this.getComponentEditButton()));
        return panel;
    }

    private Component getComponentEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton("\u7de8\u96c6");
            this.editButton.addActionListener(this);
        }
        return this.editButton;
    }

    private JComboBox<KVItem> getComponentFilterChooser() {
        if (this.filterChooser == null) {
            this.filterChooser = new JComboBox();
            this.filterChooser.addItem(new KVItem("(\u30b0\u30ed\u30fc\u30d0\u30eb)", "core.filter._global"));
            int count = this.configuration.getFrameTabCount();
            for (int i = 0; i < count; ++i) {
                ClientTab tab = this.configuration.getFrameTab(i);
                this.filterChooser.addItem(new KVItem(tab.getTitle() + " (" + tab.getUniqId() + ")", "core.filter._tabs." + tab.getUniqId()));
            }
        }
        return this.filterChooser;
    }

    @Override
    public String getValue(JComponent component) {
        return null;
    }

    @Override
    public boolean isPreferedAsMultiline() {
        return true;
    }

    @Override
    public boolean isValid(JComponent component) {
        return true;
    }

    protected static class KVItem {
        protected String displayString;
        protected String propertyKey;

        public KVItem(String displayString, String propertyKey) {
            this.displayString = displayString;
            this.propertyKey = propertyKey;
        }

        public String toString() {
            return this.displayString;
        }
    }
}

