/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TreeSet;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.filter.FilterCompiler;
import jp.syuriken.snsw.twclient.filter.FilterDispatcherBase;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.MessageFilter;
import jp.syuriken.snsw.twclient.filter.NullFilter;
import jp.syuriken.snsw.twclient.gui.TabRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;

public class TeeFilter
implements TabRenderer,
PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TeeFilter.class);
    private final String filterPropertyName;
    private final ClientProperties configProperties;
    private final MessageFilter[] globalFilters;
    private FilterDispatcherBase filterQuery;
    private TabRenderer renderer;
    private ClientConfiguration configuration;
    private TreeSet<Long> statusSet = new TreeSet();

    public TeeFilter(String uniqId, TabRenderer tabRenderer) {
        this(uniqId, tabRenderer, true);
    }

    public TeeFilter(String uniqId, TabRenderer tabRenderer, boolean useGlobalFilter) {
        this.configuration = ClientConfiguration.getInstance();
        this.renderer = tabRenderer;
        this.configProperties = this.configuration.getConfigProperties();
        this.filterPropertyName = "core.filter._tabs." + uniqId;
        this.initQuery();
        this.configProperties.addPropertyChangedListener(this);
        this.globalFilters = useGlobalFilter ? this.configuration.getFilters() : new MessageFilter[0];
    }

    protected void initQuery() {
        String filterQueryString = this.configProperties.getProperty(this.filterPropertyName);
        if (filterQueryString == null || filterQueryString.trim().isEmpty()) {
            this.filterQuery = NullFilter.getInstance();
        } else {
            try {
                this.filterQuery = FilterCompiler.getCompiledObject(this.configuration, filterQueryString);
            }
            catch (IllegalSyntaxException e) {
                logger.error("Illegal syntax filter query", (Throwable)e);
                this.filterQuery = NullFilter.getInstance();
            }
        }
    }

    public void onBlock(User source, User blockedUser) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onBlock(source, blockedUser)) continue;
            return;
        }
        this.renderer.onBlock(source, blockedUser);
    }

    @Override
    public void onChangeAccount(boolean forWrite) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onChangeAccount(forWrite)) continue;
            return;
        }
        this.renderer.onChangeAccount(forWrite);
    }

    public void onCleanUp() {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onCleanUp()) continue;
            return;
        }
        this.renderer.onCleanUp();
    }

    @Override
    public void onClientMessage(String name, Object arg) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onClientMessage(name, arg)) continue;
            return;
        }
        this.renderer.onClientMessage(name, arg);
    }

    public void onConnect() {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onConnect()) continue;
            return;
        }
        this.renderer.onConnect();
    }

    public void onDeletionNotice(long directMessageId, long userId) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onDeletionNotice(directMessageId, userId)) continue;
            return;
        }
        this.renderer.onDeletionNotice(directMessageId, userId);
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        for (MessageFilter filter : this.globalFilters) {
            if ((statusDeletionNotice = filter.onDeletionNotice(statusDeletionNotice)) != null) continue;
            return;
        }
        this.renderer.onDeletionNotice(statusDeletionNotice);
    }

    public void onDirectMessage(DirectMessage directMessage) {
        for (MessageFilter filter : this.globalFilters) {
            if ((directMessage = filter.onDirectMessage(directMessage)) != null) continue;
            return;
        }
        if (!this.filterQuery.filter(directMessage)) {
            this.renderer.onDirectMessage(directMessage);
        }
    }

    public void onDisconnect() {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onDisconnect()) continue;
            return;
        }
        this.renderer.onDisconnect();
    }

    public void onException(Exception ex) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onException(ex)) continue;
            return;
        }
        this.renderer.onException(ex);
    }

    public void onFavorite(User source, User target, Status favoritedStatus) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onFavorite(source, target, favoritedStatus)) continue;
            return;
        }
        if (!this.filterQuery.filter(favoritedStatus)) {
            this.renderer.onFavorite(source, target, favoritedStatus);
        }
    }

    public void onFollow(User source, User followedUser) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onFollow(source, followedUser)) continue;
            return;
        }
        this.renderer.onFollow(source, followedUser);
    }

    public void onFriendList(long[] friendIds) {
        for (MessageFilter filter : this.globalFilters) {
            if ((friendIds = filter.onFriendList(friendIds)) != null) continue;
            return;
        }
        this.renderer.onFriendList(friendIds);
    }

    public void onScrubGeo(long userId, long upToStatusId) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onScrubGeo(userId, upToStatusId)) continue;
            return;
        }
        this.renderer.onScrubGeo(userId, upToStatusId);
    }

    public void onStallWarning(StallWarning warning) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onStallWarning(warning)) continue;
            return;
        }
        this.renderer.onStallWarning(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatus(Status status) {
        TreeSet<Long> treeSet = this.statusSet;
        synchronized (treeSet) {
            if (this.statusSet.contains(status.getId())) {
                return;
            }
            this.statusSet.add(status.getId());
        }
        for (MessageFilter filter : this.globalFilters) {
            if ((status = filter.onStatus(status)) != null) continue;
            return;
        }
        if (!this.filterQuery.filter(status)) {
            this.renderer.onStatus(status);
        }
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onTrackLimitationNotice(numberOfLimitedStatuses)) continue;
            return;
        }
        this.renderer.onTrackLimitationNotice(numberOfLimitedStatuses);
    }

    public void onUnblock(User source, User unblockedUser) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUnblock(source, unblockedUser)) continue;
            return;
        }
        this.renderer.onUnblock(source, unblockedUser);
    }

    public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUnfavorite(source, target, unfavoritedStatus)) continue;
            return;
        }
        if (!this.filterQuery.filter(unfavoritedStatus)) {
            this.renderer.onUnfavorite(source, target, unfavoritedStatus);
        }
    }

    public void onUserListCreation(User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListCreation(listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListCreation(listOwner, list);
    }

    public void onUserListDeletion(User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListDeletion(listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListDeletion(listOwner, list);
    }

    public void onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListMemberAddition(addedMember, listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListMemberAddition(addedMember, listOwner, list);
    }

    public void onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListMemberDeletion(deletedMember, listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListMemberDeletion(deletedMember, listOwner, list);
    }

    public void onUserListSubscription(User subscriber, User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListSubscription(subscriber, listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListSubscription(subscriber, listOwner, list);
    }

    public void onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListUnsubscription(subscriber, listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListUnsubscription(subscriber, listOwner, list);
    }

    public void onUserListUpdate(User listOwner, UserList list) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserListUpdate(listOwner, list)) continue;
            return;
        }
        this.renderer.onUserListUpdate(listOwner, list);
    }

    public void onUserProfileUpdate(User updatedUser) {
        for (MessageFilter filter : this.globalFilters) {
            if (!filter.onUserProfileUpdate(updatedUser)) continue;
            return;
        }
        this.renderer.onUserProfileUpdate(updatedUser);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(this.filterPropertyName)) {
            this.initQuery();
        }
    }
}

