/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter.prop;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.filter.FilterOperator;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.PagableResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;

public class InListProperty
implements FilterProperty {
    static final Logger logger = LoggerFactory.getLogger(InListProperty.class);
    private static final Constructor<? extends FilterProperty> factory;
    protected ClientConfiguration configuration;
    private boolean isEqual;
    protected String listIdentifier;
    protected long[] userIdsFollowedByList;
    protected UserFollewedByListFetcher listFetcher;

    public static Constructor<? extends FilterProperty> getFactory() {
        return factory;
    }

    public InListProperty(ClientConfiguration configuration, String name, String operatorStr, Object value) throws IllegalSyntaxException {
        this.configuration = configuration;
        if (!"in_list".equals(name)) {
            throw new AssertionError((Object)("[in_list] \u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u304c\u4e0d\u6b63\u3067\u3059: " + name));
        }
        if (operatorStr == null || value == null) {
            throw new IllegalSyntaxException("[in_list] operator\u304a\u3088\u3073value\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093");
        }
        if (!(value instanceof String)) {
            throw new IllegalSyntaxException("[in_list] value\u306f\u6587\u5b57\u5217\u3067\u3042\u308b\u3079\u304d\u3067\u3059");
        }
        this.isEqual = FilterOperator.compileOperatorString(operatorStr) == FilterOperator.EQ;
        this.listIdentifier = (String)value;
        this.listFetcher = new UserFollewedByListFetcher(this.listIdentifier);
        this.listFetcher.run();
        configuration.getTimer().scheduleWithFixedDelay(new ListFetcherScheduler(), 60L, 60L, TimeUnit.MINUTES);
    }

    @Override
    public boolean filter(DirectMessage directMessage) {
        return this.isEqual == (Arrays.binarySearch(this.userIdsFollowedByList, directMessage.getSenderId()) >= 0 ? true : Arrays.binarySearch(this.userIdsFollowedByList, directMessage.getRecipientId()) >= 0);
    }

    @Override
    public boolean filter(Status status) {
        return this.isEqual == Arrays.binarySearch(this.userIdsFollowedByList, status.getUser().getId()) >= 0;
    }

    static {
        try {
            factory = InListProperty.class.getConstructor(ClientConfiguration.class, String.class, String.class, Object.class);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    protected class UserFollewedByListFetcher
    implements ParallelRunnable {
        protected int listId;
        private Logger logger = LoggerFactory.getLogger(UserFollewedByListFetcher.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public UserFollewedByListFetcher(String listIdentifier) throws IllegalSyntaxException {
            if (listIdentifier.startsWith(":")) {
                this.listId = Integer.parseInt(listIdentifier.substring(1));
                return;
            } else {
                String slug;
                String listOwner;
                if (listIdentifier.startsWith("@")) {
                    int indexOf = listIdentifier.indexOf(47);
                    if (indexOf == -1) {
                        throw new IllegalSyntaxException("[inlist] specify listIdentifier as :<listId> or <listName> or @<listOwner>/<listName>");
                    }
                    listOwner = listIdentifier.substring(1, indexOf);
                    slug = listIdentifier.substring(indexOf);
                } else {
                    listOwner = InListProperty.this.configuration.getCacheManager().getUser(Long.parseLong(InListProperty.this.configuration.getAccountIdForRead())).getScreenName();
                    slug = listIdentifier;
                }
                int life = 3;
                while (true) {
                    try {
                        this.listId = InListProperty.this.configuration.getTwitterForRead().showUserList(listOwner, slug).getId();
                        return;
                    }
                    catch (TwitterException e) {
                        if (e.getStatusCode() >= 500) {
                            if (--life > 0) continue;
                            throw new IllegalSyntaxException("[inlist] Could not retrieve ListInformation: @" + listOwner + "/" + slug, e);
                        }
                        if (e.getStatusCode() == 404) throw new IllegalSyntaxException("[inlist] Not Found list: @" + listOwner + "/" + slug);
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public void run() {
            ArrayList<User> userListMembers = new ArrayList<User>();
            int listId = this.listId;
            long cursor = -1L;
            int life = 10;
            do {
                try {
                    PagableResponseList userListMembersResponseList = InListProperty.this.configuration.getTwitterForRead().getUserListMembers(listId, cursor);
                    cursor = userListMembersResponseList.getNextCursor();
                    for (User user : userListMembersResponseList) {
                        userListMembers.add(user);
                    }
                }
                catch (TwitterException e) {
                    int statusCode = e.getStatusCode();
                    if (500 <= statusCode) {
                        if (--life > 0) continue;
                        this.logger.info("failed retrieving listMembers (over retry limit)");
                        return;
                    }
                    if (statusCode == 404) {
                        this.logger.info("failed retrieving listMembers (Not Found): listId={}", (Object)listId);
                        return;
                    }
                    this.logger.warn("Twitter#getUserListMembers(listId=" + listId + ") returned " + statusCode, (Throwable)e);
                    return;
                }
            } while (cursor != 0L);
            long[] users = new long[userListMembers.size()];
            int i = 0;
            for (User user : userListMembers) {
                users[i++] = user.getId();
            }
            Arrays.sort(users);
            InListProperty.this.userIdsFollowedByList = users;
        }
    }

    public class ListFetcherScheduler
    extends TimerTask {
        @Override
        public void run() {
            InListProperty.this.configuration.addJob(InListProperty.this.listFetcher);
        }
    }
}

