/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter.prop;

import java.lang.reflect.Constructor;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.filter.FilterOperator;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import twitter4j.DirectMessage;
import twitter4j.Status;

public class StandardStringProperties
implements FilterProperty {
    private static final byte PROPERTY_ID_USER = 1;
    private static final byte PROPERTY_ID_TEXT = 2;
    private static final byte PROPERTY_ID_CLIENT = 3;
    private static Constructor<? extends FilterProperty> factory;
    private FilterOperator operatorType;
    private Object value;
    private byte propertyId;

    public static Constructor<? extends FilterProperty> getFactory() {
        return factory;
    }

    public StandardStringProperties(ClientConfiguration configuration, String name, String operator, Object value) throws IllegalSyntaxException {
        switch (name) {
            case "user": {
                this.propertyId = 1;
                break;
            }
            case "text": {
                this.propertyId = (byte)2;
                break;
            }
            case "client": {
                this.propertyId = (byte)3;
                break;
            }
            default: {
                throw new IllegalSyntaxException("[StandardStringProperties] \u5bfe\u5fdc\u3057\u3066\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3067\u3059\u3002\u30d0\u30b0\u5831\u544a\u3092\u304a\u9858\u3044\u3057\u307e\u3059: " + name);
            }
        }
        if (operator == null) {
            throw new IllegalSyntaxException("[" + name + "] string\u6f14\u7b97\u5b50\u304c\u5fc5\u8981\u3067\u3059");
        }
        this.operatorType = FilterOperator.compileOperatorString(operator);
        if (this.operatorType == null) {
            throw new IllegalSyntaxException("[" + name + "] \u6b63\u3057\u304f\u306a\u3044string\u6f14\u7b97\u5b50\u3067\u3059: " + operator);
        }
        if (!(value instanceof String)) {
            throw new IllegalSyntaxException("[" + name + "] \u6b63\u3057\u304f\u306a\u3044string\u5024\u3067\u3059: " + operator);
        }
        this.value = FilterOperator.compileValueString((String)value);
    }

    @Override
    public boolean filter(DirectMessage directMessage) {
        String target;
        switch (this.propertyId) {
            case 1: {
                target = directMessage.getSenderScreenName();
                break;
            }
            case 2: {
                target = directMessage.getText();
                break;
            }
            case 3: {
                return false;
            }
            default: {
                throw new AssertionError((Object)"StandardBooleanProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    @Override
    public boolean filter(Status status) {
        String target;
        switch (this.propertyId) {
            case 1: {
                target = status.getUser().getScreenName();
                break;
            }
            case 2: {
                target = status.getText();
                break;
            }
            case 3: {
                target = status.getSource();
                int nameStart = target.indexOf(62);
                int nameEnd = target.lastIndexOf(60);
                target = target.substring(nameStart < 0 ? 0 : nameStart + 1, nameEnd < 0 ? target.length() : nameEnd);
                break;
            }
            default: {
                throw new AssertionError((Object)"StandardBooleanProperties: \u4e88\u671f\u3057\u306a\u3044propertyId");
            }
        }
        return this.operatorType.compare(target, this.value);
    }

    static {
        try {
            factory = StandardStringProperties.class.getConstructor(ClientConfiguration.class, String.class, String.class, Object.class);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

