/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.gui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.internal.FetchEventHandler;
import jp.syuriken.snsw.twclient.internal.NetworkSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageViewerFrame
extends JFrame
implements WindowListener {
    private final URL url;
    private JLabel imageLabel;
    private ImageFetcher imageFetcher;

    public ImageViewerFrame(URL url) {
        this.url = url;
        this.initComponents();
        this.scheduleImageFetcher(url);
    }

    private JLabel getComponentImageLabel() {
        if (this.imageLabel == null) {
            this.imageLabel = new JLabel("\u30ad\u30e5\u30fc\u304c\u958b\u304f\u306e\u3092\u5f85\u3063\u3066\u3044\u307e\u3059...");
        }
        return this.imageLabel;
    }

    private void initComponents() {
        this.setSize(256, 256);
        this.setTitle(this.url.toString());
        this.addWindowListener(this);
        this.add(this.getComponentImageLabel());
    }

    @Override
    public void pack() {
        super.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < 64) {
            width = 64;
        }
        if (height < 64) {
            height = 64;
        }
        this.setSize(width, height);
    }

    private void scheduleImageFetcher(URL url) {
        this.imageFetcher = new ImageFetcher(url);
        ClientConfiguration.getInstance().addJob((byte)12, this.imageFetcher);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.imageFetcher.interrupt();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    protected class ImageFetcher
    implements ParallelRunnable,
    FetchEventHandler {
        private final Logger logger = LoggerFactory.getLogger(ImageFetcher.class);
        private final URL url;
        private volatile boolean isInterrupted;
        private int contentLength;

        public ImageFetcher(URL url) {
            this.url = url;
        }

        public void interrupt() {
            this.isInterrupted = true;
        }

        @Override
        public void onContentLength(int contentLength) throws InterruptedException {
            this.contentLength = contentLength;
            this.onLoaded(0);
        }

        @Override
        public void onException(URLConnection connection, IOException e) {
            this.logger.warn(MessageFormat.format("Error while fetching: {0}", this.url), (Throwable)e);
        }

        @Override
        public void onLoaded(int imageLen) throws InterruptedException {
            if (this.isInterrupted) {
                throw new InterruptedException();
            }
            if (this.contentLength == -1) {
                this.updateImageLabel("\u8aad\u8fbc\u4e2d(" + imageLen + ")");
            } else {
                this.updateImageLabel("\u8aad\u8fbc\u4e2d(" + imageLen + "/" + this.contentLength + ")");
            }
        }

        @Override
        public void run() {
            try {
                byte[] contents = NetworkSupport.fetchContents(this.url, this);
                if (contents != null) {
                    final Image image = Toolkit.getDefaultToolkit().createImage(contents);
                    final ImageIcon imageIcon = new ImageIcon(image);
                    if (imageIcon.getIconHeight() < 0) {
                        this.updateImageLabel("\u753b\u50cf\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u305f\u3082\u3088\u3046");
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImageViewerFrame.this.getComponentImageLabel().setText(null);
                                ImageViewerFrame.this.getComponentImageLabel().setIcon(imageIcon);
                                ImageViewerFrame.this.pack();
                                ImageViewerFrame.this.setIconImage(image);
                            }
                        });
                    }
                }
            }
            catch (InterruptedException e) {
                this.updateImageLabel("\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f");
            }
        }

        private void updateImageLabel(final String progress) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageViewerFrame.this.getComponentImageLabel().setText(progress);
                }
            });
        }
    }
}

